/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.h5.impl;

import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.management.AssetType;
import com.vmware.license.client.cis.management.VpxManagementEditor;
import com.vmware.license.client.cis.management.VsphereObjectAssetSpec;
import com.vmware.license.client.cis.management.ds.Asset;
import com.vmware.license.client.cis.util.LicenseScopeUtil;
import com.vmware.vim.binding.cis.license.fault.NotFoundFault;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.annotation.ModelMetadata;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public final class LicensingAssetPropertyProvider
implements PropertyProviderBean {
    private final VpxManagementEditor _vpxManagementEditor;
    public static final String PROPERTY = "asset";
    public static final String TARGET_TYPE = "Asset";
    public static final String RELATION = "assets";
    public static final String RESPONSE_PROPERTY_ASSET = "asset";
    public static final String RESPONSE_PROPERTY_ERROR = "notFound";
    public static final String RESPONSE_PROPERTY_OBJECT_TYPE = "managedObjectRef";

    public LicensingAssetPropertyProvider(VpxManagementEditor vpxManagementEditor) {
        this._vpxManagementEditor = vpxManagementEditor;
    }

    @ModelMetadata(type={"HostSystem", "ClusterComputeResource", "Folder"}, property="asset")
    public Map<String, Object> getAsset(ManagedObjectReference assetRef, String assetType) {
        LicenseScope scope = LicenseScopeUtil.getLicenseScopeByMoRef((ManagedObjectReference)assetRef);
        return this.getAsset(assetRef, assetType, scope);
    }

    @ModelMetadata(type={"com.vmware.wcp.SupervisorModel"}, property="com.vmware.wcp.SupervisorModel/asset")
    public Map<String, Object> getAsset(URI assetURI, String assetType) {
        LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiObjectUri((URI)assetURI);
        return this.getAsset(assetURI, assetType, scope);
    }

    private <T> Map<String, Object> getAsset(T assetRef, String assetType, LicenseScope scope) {
        if (assetRef == null) {
            return null;
        }
        AssetType type = assetType != null ? AssetType.valueOf((String)assetType) : null;
        VsphereObjectAssetSpec vsphereObjectAssetSpec = new VsphereObjectAssetSpec(assetRef, type);
        Asset[] assets = null;
        try {
            assets = this._vpxManagementEditor.getAssetsByVsphereObjectRefs(new VsphereObjectAssetSpec[]{vsphereObjectAssetSpec}, scope);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof NotFoundFault) {
                return this.transformResultSet(null, assetRef);
            }
            throw e;
        }
        return this.transformResultSet(assets, assetRef);
    }

    private <T> Map<String, Object> transformResultSet(Asset[] assets, T assetRef) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (assets == null) {
            resultMap.put("asset", null);
            resultMap.put(RESPONSE_PROPERTY_ERROR, true);
            resultMap.put(RESPONSE_PROPERTY_OBJECT_TYPE, assetRef);
            return resultMap;
        }
        if (assets.length > 0) {
            resultMap.put("asset", assets[0]);
            resultMap.put(RESPONSE_PROPERTY_ERROR, false);
            resultMap.put(RESPONSE_PROPERTY_OBJECT_TYPE, assetRef);
        }
        return resultMap;
    }
}

