/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.h5.notifications;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.license.client.cis.global.ds.LicensingGlobalData;
import com.vmware.license.client.cis.management.ds.Asset;
import com.vmware.license.client.cis.management.ds.License;
import com.vmware.license.client.h5.notifications.LicensingNotificationUtil;
import com.vmware.vise.data.uri.resolve.DefaultUriSchemeUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.notifications.NotificationData;
import com.vmware.vise.vim.commons.notifications.NotificationsDataProvider;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VcLicensingExpirationNotificationsProvider
implements NotificationsDataProvider {
    private static final String NO_ERROR_CODE = "noError";
    private static final String LICENSE_GLOBAL_DATA_PROP = "licensingGlobalData";
    private static final String LICENSING_GLOBAL_DATA_TYPE = "LicensingGlobalData";
    private static final String CIS_LICENSING_SCOPE = "licensing_service_version1";
    private static final String CIS_LICENSING_GUID = "urn:vri:LicensingGlobalData:licensing_service_version1";
    private static final String LICENSING_ADMIN_PRIVILEGE_GRANTED_OP_ID = "licensing-admin-privilege-granted";
    private static final String ASSET_TYPE_RESOURCE_MODEL = "Asset";
    private static final String SCOPE_PROP = "scope";
    private static final String LICENSE_STATE_PROP = "licenseState";
    private static final String ASSET_PROP = "asset";
    private static final String LICENSING_EXPIRATION_NOTIFICATIONS_PROP = "licensingExpirationNotifications";
    private static final String LICENSE_RESOURCE_MODEL = "License";
    private static final String LICENSE_TYPE_PROPERTY = "type";
    private static final String SERIAL_KEY_TYPE = "SERIAL_KEY";
    private static final String LICENSE_PROPERTY = "license";
    private static final Log _logger = LogFactory.getLog(VcLicensingExpirationNotificationsProvider.class);
    private static final int FIRST_RESULT_ITEM_INDEX = 0;
    private final QueryService _queryService;

    public VcLicensingExpirationNotificationsProvider(QueryServiceFactory queryServiceFactory) {
        this._queryService = queryServiceFactory.getQueryService();
    }

    public List<NotificationData> getNotificationData() {
        ArrayList<NotificationData> resultList = new ArrayList<NotificationData>();
        boolean expiringLicensesFound = false;
        if (this.hasConnectedVc() && this.isLicensingAdminPrivilegeGranted()) {
            expiringLicensesFound = this.areAnyAssignedLicensesExpiring() || this.areAnyAssetsWithEvaluationLicense();
        }
        NotificationData notification = new NotificationData();
        notification.type = "licensing-expiration-notification";
        notification.notification = this.transformResults(expiringLicensesFound);
        resultList.add(notification);
        return resultList;
    }

    private List<License> retrieveAllLicenses() {
        ArrayList<License> resultList = new ArrayList<License>();
        PropertyPredicate first = new PropertyPredicate(SCOPE_PROP, PropertyPredicate.ComparisonOperator.EQUAL, (Object)CIS_LICENSING_SCOPE, false);
        PropertyPredicate second = new PropertyPredicate(LICENSE_TYPE_PROPERTY, PropertyPredicate.ComparisonOperator.EQUAL, (Object)SERIAL_KEY_TYPE, false);
        List<PropertyPredicate> predicates = Arrays.asList(first, second);
        try {
            ResultSet resultSet = this._queryService.select(new String[]{LICENSE_PROPERTY}).from(new String[]{LICENSE_RESOURCE_MODEL}).where(new Filter(predicates, LogicalOperator.AND)).opId("licensing-expiration-notification").fetch();
            for (ResourceItem resourceItem : resultSet.getItems()) {
                License license = (License)resourceItem.get(LICENSE_PROPERTY);
                if (license == null) continue;
                resultList.add(license);
            }
        }
        catch (Exception e) {
            _logger.error((Object)"Error while retrieving vc assets", (Throwable)e);
        }
        return resultList;
    }

    private boolean isLicensingAdminPrivilegeGranted() {
        URI licensingGlobalDataUri = DefaultUriSchemeUtil.createUri((String)LICENSING_GLOBAL_DATA_TYPE, (String)CIS_LICENSING_SCOPE);
        try {
            ResultSet resultSet = this._queryService.select(new String[]{LICENSE_GLOBAL_DATA_PROP}).from(new String[]{LICENSING_GLOBAL_DATA_TYPE}).where("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)licensingGlobalDataUri).opId(LICENSING_ADMIN_PRIVILEGE_GRANTED_OP_ID).fetch();
            ResourceItem resourceItem = (ResourceItem)resultSet.getItems().get(0);
            if (resourceItem == null) {
                return false;
            }
            LicensingGlobalData licensingGlobalData = (LicensingGlobalData)resourceItem.get(LICENSE_GLOBAL_DATA_PROP);
            return licensingGlobalData != null && licensingGlobalData.isLicensingAdminPrivilegeGranted();
        }
        catch (Exception e) {
            _logger.error((Object)"Error while retrieving granted licensing admin privilege", (Throwable)e);
            return false;
        }
    }

    private boolean areAnyAssetsWithEvaluationLicense() {
        ArrayList<Asset> resultList = new ArrayList<Asset>();
        PropertyPredicate first = new PropertyPredicate(LICENSE_STATE_PROP, PropertyPredicate.ComparisonOperator.EQUAL, (Object)"evaluation", false);
        PropertyPredicate second = new PropertyPredicate("maxResultObjects", PropertyPredicate.ComparisonOperator.EQUAL, (Object)1, false);
        List<PropertyPredicate> predicates = Arrays.asList(first, second);
        try {
            ResultSet resultSet = this._queryService.select(new String[]{ASSET_PROP}).from(new String[]{ASSET_TYPE_RESOURCE_MODEL}).where(new Filter(predicates, LogicalOperator.AND)).opId("licensing-expiration-notification").fetch();
            for (ResourceItem resourceItem : resultSet.getItems()) {
                Asset asset = (Asset)resourceItem.get(ASSET_PROP);
                if (asset == null) continue;
                resultList.add(asset);
            }
        }
        catch (Exception e) {
            _logger.error((Object)"Error while retrieving vc assets", (Throwable)e);
        }
        return resultList.size() > 0;
    }

    private Map<String, Object> transformResults(boolean expiringLicensesFound) {
        HashMap<String, Object> propsMap = new HashMap<String, Object>();
        if (expiringLicensesFound) {
            propsMap.put(LICENSING_EXPIRATION_NOTIFICATIONS_PROP, new Boolean(true));
        }
        return propsMap;
    }

    private boolean areAnyAssignedLicensesExpiring() {
        List<License> licensesList = this.retrieveAllLicenses();
        if (licensesList != null) {
            for (License license : licensesList) {
                if (!license.isAssigned() || !LicensingNotificationUtil.isLicenseExpiring(license)) continue;
                return true;
            }
        }
        return false;
    }

    boolean hasConnectedVc() {
        LinkedVcGroupRegistry vcRegistry = VimSessionUtil.getLinkedVcGroupRegistryByClientId((String)SessionUtil.getClientId((HttpSession)SessionUtil.getHttpSession()));
        if (vcRegistry == null) {
            return false;
        }
        LinkedVcGroup[] linkedVcGroups = vcRegistry.getLinkedVcGroups();
        if (linkedVcGroups == null) {
            return false;
        }
        for (LinkedVcGroup linkedVcGroup : linkedVcGroups) {
            for (VcService vcService : linkedVcGroup.getVcServices()) {
                if (!this.isVcConnected(vcService)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isVcConnected(VcService vcService) {
        return vcService != null && vcService.getConnectionInfo() != null && NO_ERROR_CODE.equals(vcService.getConnectionInfo().getErrorCode());
    }
}

