/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms;

import com.vmware.opsmgmt.client.commons.util.ManagedObjectTypes;
import com.vmware.opsmgmt.client.extension.alarms.Localization;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.ManagedEntity;
import com.vmware.vim.binding.vim.Network;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vim.StoragePod;
import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.alarm.AlarmExpression;
import com.vmware.vim.binding.vim.alarm.AndAlarmExpression;
import com.vmware.vim.binding.vim.alarm.EventAlarmExpression;
import com.vmware.vim.binding.vim.alarm.MetricAlarmExpression;
import com.vmware.vim.binding.vim.alarm.OrAlarmExpression;
import com.vmware.vim.binding.vim.alarm.StateAlarmExpression;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.TypeName;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import java.util.HashMap;
import java.util.Map;

public class AlarmsUtil {
    private static Map<String, String> _imageKeyByMoType = new HashMap<String, String>();
    private static Map<String, String> _objectTypeKeyByMoType = new HashMap<String, String>();

    public static String getAlarmStatusIcon(ManagedEntity.Status status) {
        if (status == null) {
            return null;
        }
        if (status == ManagedEntity.Status.red) {
            return "statusRed";
        }
        if (status == ManagedEntity.Status.yellow) {
            return "statusYellow";
        }
        if (status == ManagedEntity.Status.green) {
            return "statusGreen";
        }
        return "statusUnknown";
    }

    public static String getLocalizedMonitorType(TypeName type) {
        if (type == null) {
            return null;
        }
        return AlarmsUtil.getLocalizedMonitorType(type.getName());
    }

    public static String getLocalizedMonitorType(String type) {
        if (type == null) {
            return null;
        }
        String key = _objectTypeKeyByMoType.get(type);
        if (key != null) {
            return Localization.getString(key);
        }
        return null;
    }

    public static String getMonitorType(AlarmExpression alarmExpression) {
        String monitorType = null;
        AlarmExpression firstAlarmExp = null;
        if (alarmExpression instanceof OrAlarmExpression) {
            OrAlarmExpression orAlarmExp = (OrAlarmExpression)alarmExpression;
            if (orAlarmExp.expression.length > 0) {
                firstAlarmExp = orAlarmExp.expression[0];
                monitorType = AlarmsUtil.getMonitorType(firstAlarmExp);
            }
        } else if (alarmExpression instanceof AndAlarmExpression) {
            AndAlarmExpression andExp = (AndAlarmExpression)alarmExpression;
            if (andExp.expression.length > 0) {
                firstAlarmExp = andExp.expression[0];
                monitorType = AlarmsUtil.getMonitorType(firstAlarmExp);
            }
        } else if (alarmExpression instanceof MetricAlarmExpression) {
            MetricAlarmExpression metricExp = (MetricAlarmExpression)alarmExpression;
            monitorType = metricExp.type.getName();
        } else if (alarmExpression instanceof StateAlarmExpression) {
            StateAlarmExpression stateExp = (StateAlarmExpression)alarmExpression;
            monitorType = stateExp.type.getName();
        } else if (alarmExpression instanceof EventAlarmExpression) {
            EventAlarmExpression eventEx = (EventAlarmExpression)alarmExpression;
            monitorType = eventEx.objectType == null ? ManagedObjectTypes.VIRTUAL_CENTER.getObjectType() : eventEx.objectType.getName();
        }
        if (Folder.class.getName().equals(monitorType)) {
            monitorType = ManagedObjectTypes.VIRTUAL_CENTER.getObjectType();
        }
        return monitorType;
    }

    public static String getNormalizeType(ManagedObjectReference objRef) {
        String objType = objRef.getType();
        if (ManagedObjectTypes.FOLDER.getObjectType().equals(objType)) {
            if (ManagedObjectUtil.isVmFolder((ManagedObjectReference)objRef)) {
                objType = FolderType.VM.getType();
            } else if (ManagedObjectUtil.isHostFolder((ManagedObjectReference)objRef)) {
                objType = FolderType.HOST.getType();
            } else if (ManagedObjectUtil.isStorageFolder((ManagedObjectReference)objRef)) {
                objType = FolderType.STORAGE.getType();
            } else if (ManagedObjectUtil.isNetworkFolder((ManagedObjectReference)objRef)) {
                objType = FolderType.NETWORK.getType();
            } else if (ManagedObjectUtil.isRootFolder((ManagedObjectReference)objRef)) {
                objType = FolderType.ROOT.getType();
            }
        }
        return objType;
    }

    static {
        _imageKeyByMoType.put(VirtualMachine.class.getName(), "virtualmachine");
        _imageKeyByMoType.put(ClusterComputeResource.class.getName(), "clustercomputeresource");
        _imageKeyByMoType.put(Datacenter.class.getName(), "datacenter");
        _imageKeyByMoType.put(HostSystem.class.getName(), "hostsystem");
        _imageKeyByMoType.put(ComputeResource.class.getName(), "hostsystem");
        _imageKeyByMoType.put(DistributedVirtualPortgroup.class.getName(), "distributedvirtualportgroup");
        _imageKeyByMoType.put(Folder.class.getName(), "folder");
        _imageKeyByMoType.put(ResourcePool.class.getName(), "resourcepool");
        _imageKeyByMoType.put(VirtualApp.class.getName(), "virtualapp");
        _imageKeyByMoType.put(Datastore.class.getName(), "datastore");
        _imageKeyByMoType.put(Network.class.getName(), "network");
        _imageKeyByMoType.put(StoragePod.class.getName(), "storagepod");
        _imageKeyByMoType.put(DistributedVirtualSwitch.class.getName(), "distributedvirtualswitch");
        _imageKeyByMoType.put(VmwareDistributedVirtualSwitch.class.getName(), "distributedvirtualswitch");
        _imageKeyByMoType.put(ManagedObjectTypes.VIRTUAL_CENTER.getObjectType(), "rootFolder");
        _objectTypeKeyByMoType.put(ManagedEntity.class.getName(), "objectType.managedEntity");
        _objectTypeKeyByMoType.put(VirtualMachine.class.getName(), "objectType.vm");
        _objectTypeKeyByMoType.put(ClusterComputeResource.class.getName(), "objectType.cluster");
        _objectTypeKeyByMoType.put(Datacenter.class.getName(), "objectType.datacenter");
        _objectTypeKeyByMoType.put(HostSystem.class.getName(), "objectType.host");
        _objectTypeKeyByMoType.put(ComputeResource.class.getName(), "objectType.computeResource");
        _objectTypeKeyByMoType.put(DistributedVirtualPortgroup.class.getName(), "objectType.dvPortGroup");
        _objectTypeKeyByMoType.put(Folder.class.getName(), "objectType.folder");
        _objectTypeKeyByMoType.put(ResourcePool.class.getName(), "objectType.resourcePool");
        _objectTypeKeyByMoType.put(VirtualApp.class.getName(), "objectType.vapp");
        _objectTypeKeyByMoType.put(Datastore.class.getName(), "objectType.datastore");
        _objectTypeKeyByMoType.put(Network.class.getName(), "objectType.network");
        _objectTypeKeyByMoType.put(StoragePod.class.getName(), "objectType.storagePod");
        _objectTypeKeyByMoType.put(DistributedVirtualSwitch.class.getName(), "objectType.switch");
        _objectTypeKeyByMoType.put(VmwareDistributedVirtualSwitch.class.getName(), "objectType.dvVMSwitch");
        _objectTypeKeyByMoType.put(ManagedObjectTypes.VIRTUAL_CENTER.getObjectType(), "objectType.virtualCenter");
    }

    static enum FolderType {
        VM("VirtualMachineFolder"),
        HOST("HostFolder"),
        STORAGE("StorageFolder"),
        NETWORK("NetworkFolder"),
        ROOT("VirtualCenter");

        private String type;

        private FolderType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }
}

