/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms.definition.actions;

import com.vmware.opsmgmt.client.extension.alarms.definition.actions.ActionConfigDescription;
import com.vmware.opsmgmt.client.extension.alarms.definition.actions.ActionGroup;
import com.vmware.opsmgmt.client.extension.alarms.definition.actions.ActionWrapper;
import com.vmware.opsmgmt.client.extension.alarms.definition.actions.ActionWrapperFactory;
import com.vmware.vim.binding.vim.action.Action;
import com.vmware.vim.binding.vim.action.CreateTaskAction;
import com.vmware.vim.binding.vim.action.MethodAction;
import com.vmware.vim.binding.vim.action.RunScriptAction;
import com.vmware.vim.binding.vim.action.SendEmailAction;
import com.vmware.vim.binding.vim.action.SendSNMPAction;
import com.vmware.vim.binding.vim.alarm.AlarmTriggeringAction;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class ActionGroupBuilder {
    public static final String NEW_LINE = "<br />";
    protected ActionWrapperFactory _actionWrapperFactory = new ActionWrapperFactory();

    public List<ActionGroup> build(AlarmTriggeringAction action, Map<ManagedObjectReference, String> objectNames) {
        Validate.notNull((Object)action);
        Validate.notNull(objectNames);
        ArrayList<ActionGroup> result = new ArrayList<ActionGroup>();
        if (ArrayUtils.isEmpty((Object[])action.transitionSpecs)) {
            return result;
        }
        for (AlarmTriggeringAction.TransitionSpec spec : action.transitionSpecs) {
            result.add(this.createActionGroup(action, spec, objectNames));
        }
        return result;
    }

    protected ActionGroup createActionGroup(AlarmTriggeringAction action, AlarmTriggeringAction.TransitionSpec spec, Map<ManagedObjectReference, String> objectNames) {
        ActionWrapper iWrapper = this._actionWrapperFactory.create(action, objectNames);
        String body = "";
        for (ActionConfigDescription actionDescr : iWrapper.getConfiguration()) {
            body = this.appendProperty(body, actionDescr);
        }
        return new ActionGroup(action.action.getClass().getSimpleName(), iWrapper.getTitle(), iWrapper.getTitleLower(), body, spec);
    }

    protected String appendProperty(String message, ActionConfigDescription actionDescr) {
        if (actionDescr == null || StringUtils.isEmpty((CharSequence)actionDescr.toString())) {
            return message;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(message);
        sb.append(NEW_LINE);
        sb.append(actionDescr.getLocalizedName());
        sb.append(actionDescr.getLocalizedValue());
        return sb.toString();
    }

    public boolean isSupported(Action action) {
        return action instanceof CreateTaskAction || action instanceof MethodAction || action instanceof RunScriptAction || action instanceof SendEmailAction || action instanceof SendSNMPAction;
    }
}

