/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms.definition.actions;

import com.vmware.opsmgmt.client.commons.util.ManagedObjectTypes;
import com.vmware.opsmgmt.client.extension.alarms.Localization;
import com.vmware.opsmgmt.client.extension.alarms.definition.actions.ActionWrapper;
import com.vmware.opsmgmt.client.extension.alarms.definition.actions.CreateTaskActionWrapper;
import com.vmware.opsmgmt.client.extension.alarms.definition.actions.MethodNameWrapper;
import com.vmware.opsmgmt.client.extension.alarms.definition.actions.MigrateVmActionWrapper;
import com.vmware.opsmgmt.client.extension.alarms.definition.actions.RunScriptActionWrapper;
import com.vmware.opsmgmt.client.extension.alarms.definition.actions.SendMailActionWrapper;
import com.vmware.vim.binding.impl.vmodl.MethodNameImpl;
import com.vmware.vim.binding.vim.ManagedEntity;
import com.vmware.vim.binding.vim.action.Action;
import com.vmware.vim.binding.vim.action.CreateTaskAction;
import com.vmware.vim.binding.vim.action.MethodAction;
import com.vmware.vim.binding.vim.action.MethodActionArgument;
import com.vmware.vim.binding.vim.action.RunScriptAction;
import com.vmware.vim.binding.vim.action.SendEmailAction;
import com.vmware.vim.binding.vim.action.SendSNMPAction;
import com.vmware.vim.binding.vim.alarm.AlarmTriggeringAction;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;

public class ActionWrapperFactory {
    private static final String POWER_ON_ACTION = "PowerOnVM_Task";
    private static final String POWER_OFF_ACTION = "PowerOffVM_Task";
    private static final String SUSPEND_ACTION = "SuspendVM_Task";
    private static final String RESET_VM_ACTION = "ResetVM_Task";
    private static final String REBOOT_GUEST_ACTION = "RebootGuest";
    private static final String SHUTDOWN_GUEST_ACTION = "ShutdownGuest";
    private static final String MIGRATE_VM_ACTION = "MigrateVM_Task";
    private static final String ENTER_MAINTENANCE_ACTION = "EnterMaintenanceMode_Task";
    private static final String EXIT_MAINTENANCE_ACTION = "ExitMaintenanceMode_Task";
    private static final String ENTER_STANDBY_ACTION = "PowerDownHostToStandBy_Task";
    private static final String EXIT_STANDBY_ACTION = "PowerUpHostFromStandBy_Task";
    private static final String REBOOT_HOST_ACTION = "RebootHost_Task";
    private static final String SHUTDOWN_HOST_ACTION = "ShutdownHost_Task";

    public ActionWrapper create(AlarmTriggeringAction triggeringAction, Map<ManagedObjectReference, String> objectNames) {
        Validate.notNull((Object)triggeringAction);
        Validate.notNull(objectNames);
        Action action = triggeringAction.action;
        if (action instanceof SendSNMPAction) {
            return new ActionWrapper(triggeringAction, "Alarm.AlarmHelper.SendTrap");
        }
        if (action instanceof SendEmailAction) {
            return new SendMailActionWrapper(triggeringAction);
        }
        if (action instanceof RunScriptAction) {
            return new RunScriptActionWrapper(triggeringAction);
        }
        if (action instanceof CreateTaskAction) {
            return new CreateTaskActionWrapper(triggeringAction);
        }
        if (action instanceof MethodAction) {
            String actionName;
            MethodAction methodAction = (MethodAction)action;
            switch (actionName = ((MethodNameImpl)methodAction.name).getWsdlName()) {
                case "PowerOnVM_Task": {
                    return new ActionWrapper(triggeringAction, "Alarm.AlarmHelper.PowerOnVM");
                }
                case "PowerOffVM_Task": {
                    return new ActionWrapper(triggeringAction, "Alarm.AlarmHelper.PowerOffVM");
                }
                case "SuspendVM_Task": {
                    return new ActionWrapper(triggeringAction, "Alarm.AlarmHelper.SuspendVM");
                }
                case "ResetVM_Task": {
                    return new ActionWrapper(triggeringAction, "Alarm.AlarmHelper.ResetVM");
                }
                case "RebootHost_Task": {
                    return new ActionWrapper(triggeringAction, "Alarm.AlarmHelper.RebootHost");
                }
                case "RebootGuest": {
                    return new ActionWrapper(triggeringAction, this.getVpxString("Alarm.AlarmHelper.RebootGuestOnVM"));
                }
                case "ShutdownHost_Task": {
                    return new ActionWrapper(triggeringAction, "Alarm.AlarmHelper.ShutdownHost");
                }
                case "ShutdownGuest": {
                    return new ActionWrapper(triggeringAction, "Alarm.AlarmHelper.ShutdownGuestOnVM");
                }
                case "EnterMaintenanceMode_Task": {
                    return new ActionWrapper(triggeringAction, "Alarm.AlarmHelper.EnterMaintenanceMode");
                }
                case "ExitMaintenanceMode_Task": {
                    return new ActionWrapper(triggeringAction, "Alarm.AlarmHelper.ExitMaintenanceMode");
                }
                case "PowerDownHostToStandBy_Task": {
                    return new ActionWrapper(triggeringAction, "Alarm.AlarmHelper.EnterStandbyMode");
                }
                case "PowerUpHostFromStandBy_Task": {
                    return new ActionWrapper(triggeringAction, "Alarm.AlarmHelper.ExitStandbyMode");
                }
                case "MigrateVM_Task": {
                    MigrateVmActionWrapper migrateWrapper = new MigrateVmActionWrapper(triggeringAction);
                    migrateWrapper.setRpName(objectNames.get(migrateWrapper.getResourcePool()));
                    migrateWrapper.setHostName(objectNames.get(migrateWrapper.getHost()));
                    return migrateWrapper;
                }
            }
        }
        return null;
    }

    private String getVpxString(String key) {
        return Localization.getVpxString(key);
    }

    public List<ActionWrapper> createDefault(String moType) {
        ArrayList<ActionWrapper> defaultActions = new ArrayList<ActionWrapper>();
        AlarmTriggeringAction action = new AlarmTriggeringAction();
        action.action = new SendEmailAction();
        defaultActions.add(new SendMailActionWrapper(action));
        action = new AlarmTriggeringAction();
        action.action = new SendSNMPAction();
        defaultActions.add(new ActionWrapper(action, "Alarm.AlarmHelper.SendTrap"));
        action = new AlarmTriggeringAction();
        action.action = new RunScriptAction();
        defaultActions.add(new RunScriptActionWrapper(action));
        if (ManagedObjectTypes.VIRTUAL_MACHINE.name().equals(moType)) {
            this.addVmDefaultActions(defaultActions);
        }
        if (ManagedObjectTypes.HOST.name().equals(moType)) {
            this.addHostDefaultActions(defaultActions);
        }
        for (ActionWrapper wrapper : defaultActions) {
            this.addDefaulTransitionSpec(wrapper);
        }
        return defaultActions;
    }

    private void addVmDefaultActions(List<ActionWrapper> actions) {
        AlarmTriggeringAction action = new AlarmTriggeringAction();
        MethodAction methodAction = new MethodAction();
        methodAction.name = new MethodNameWrapper(RESET_VM_ACTION);
        action.action = methodAction;
        actions.add(new ActionWrapper(action, "Alarm.AlarmHelper.ResetVM"));
        action = new AlarmTriggeringAction();
        methodAction = new MethodAction();
        methodAction.name = new MethodNameWrapper(POWER_ON_ACTION);
        action.action = methodAction;
        actions.add(new ActionWrapper(action, "Alarm.AlarmHelper.PowerOnVM"));
        action = new AlarmTriggeringAction();
        methodAction = new MethodAction();
        methodAction.name = new MethodNameWrapper(POWER_OFF_ACTION);
        action.action = methodAction;
        actions.add(new ActionWrapper(action, "Alarm.AlarmHelper.PowerOffVM"));
        action = new AlarmTriggeringAction();
        methodAction = new MethodAction();
        methodAction.name = new MethodNameWrapper(SUSPEND_ACTION);
        action.action = methodAction;
        actions.add(new ActionWrapper(action, "Alarm.AlarmHelper.SuspendVM"));
        action = new AlarmTriggeringAction();
        methodAction = new MethodAction();
        methodAction.name = new MethodNameWrapper(MIGRATE_VM_ACTION);
        action.action = methodAction;
        actions.add(new MigrateVmActionWrapper(action));
        action = new AlarmTriggeringAction();
        methodAction = new MethodAction();
        methodAction.name = new MethodNameWrapper(REBOOT_GUEST_ACTION);
        action.action = methodAction;
        actions.add(new ActionWrapper(action, "Alarm.AlarmHelper.RebootGuestOnVM"));
        action = new AlarmTriggeringAction();
        methodAction = new MethodAction();
        methodAction.name = new MethodNameWrapper(SHUTDOWN_GUEST_ACTION);
        action.action = methodAction;
        actions.add(new ActionWrapper(action, "Alarm.AlarmHelper.ShutdownGuestOnVM"));
    }

    private void addHostDefaultActions(List<ActionWrapper> actions) {
        actions.add(this.createEnterMaintenanceMode());
        actions.add(this.createExitMaintenanceMode());
        actions.add(this.createStandByMode());
        actions.add(this.createExitStandByMode());
        actions.add(this.createRebootHost());
        actions.add(this.createShutdownHost());
    }

    private ActionWrapper createShutdownHost() {
        AlarmTriggeringAction action = new AlarmTriggeringAction();
        MethodAction methodAction = new MethodAction();
        methodAction.name = new MethodNameWrapper(SHUTDOWN_HOST_ACTION);
        MethodActionArgument methodArgument = new MethodActionArgument();
        methodArgument.value = true;
        methodAction.argument = new MethodActionArgument[]{methodArgument};
        action.action = methodAction;
        return new ActionWrapper(action, "Alarm.AlarmHelper.ShutdownHost");
    }

    private ActionWrapper createRebootHost() {
        AlarmTriggeringAction action = new AlarmTriggeringAction();
        MethodAction methodAction = new MethodAction();
        methodAction.name = new MethodNameWrapper(REBOOT_HOST_ACTION);
        MethodActionArgument methodArgument = new MethodActionArgument();
        methodArgument.value = true;
        methodAction.argument = new MethodActionArgument[]{methodArgument};
        action.action = methodAction;
        return new ActionWrapper(action, "Alarm.AlarmHelper.RebootHost");
    }

    private ActionWrapper createExitStandByMode() {
        AlarmTriggeringAction action = new AlarmTriggeringAction();
        MethodAction methodAction = new MethodAction();
        methodAction.name = new MethodNameWrapper(EXIT_STANDBY_ACTION);
        MethodActionArgument methodArgument = new MethodActionArgument();
        methodArgument.value = 0;
        methodAction.argument = new MethodActionArgument[]{methodArgument};
        action.action = methodAction;
        return new ActionWrapper(action, "Alarm.AlarmHelper.ExitStandbyMode");
    }

    private ActionWrapper createStandByMode() {
        AlarmTriggeringAction action = new AlarmTriggeringAction();
        MethodAction methodAction = new MethodAction();
        methodAction.name = new MethodNameWrapper(ENTER_STANDBY_ACTION);
        MethodActionArgument methodArgument = new MethodActionArgument();
        methodArgument.value = 0;
        MethodActionArgument methodArgument2 = new MethodActionArgument();
        methodArgument.value = false;
        methodAction.argument = new MethodActionArgument[]{methodArgument, methodArgument2};
        action.action = methodAction;
        return new ActionWrapper(action, "Alarm.AlarmHelper.EnterStandbyMode");
    }

    private ActionWrapper createExitMaintenanceMode() {
        AlarmTriggeringAction action = new AlarmTriggeringAction();
        MethodAction methodAction = new MethodAction();
        methodAction.name = new MethodNameWrapper(EXIT_MAINTENANCE_ACTION);
        MethodActionArgument methodArgument = new MethodActionArgument();
        methodArgument.value = 0;
        methodAction.argument = new MethodActionArgument[]{methodArgument};
        action.action = methodAction;
        return new ActionWrapper(action, "Alarm.AlarmHelper.ExitMaintenanceMode");
    }

    private ActionWrapper createEnterMaintenanceMode() {
        AlarmTriggeringAction action = new AlarmTriggeringAction();
        MethodAction methodAction = new MethodAction();
        methodAction.name = new MethodNameWrapper(ENTER_MAINTENANCE_ACTION);
        MethodActionArgument methodArgument = new MethodActionArgument();
        methodArgument.value = 0;
        MethodActionArgument methodArgument2 = new MethodActionArgument();
        methodArgument.value = false;
        methodAction.argument = new MethodActionArgument[]{methodArgument, methodArgument2};
        action.action = methodAction;
        return new ActionWrapper(action, "Alarm.AlarmHelper.EnterMaintenanceMode");
    }

    private void addDefaulTransitionSpec(ActionWrapper wrapper) {
        AlarmTriggeringAction.TransitionSpec spec = new AlarmTriggeringAction.TransitionSpec();
        spec.startState = ManagedEntity.Status.yellow;
        spec.finalState = ManagedEntity.Status.red;
        spec.repeats = false;
        wrapper.setYellowToRed(spec);
    }
}

