/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms.definition.actions;

import com.vmware.opsmgmt.client.extension.alarms.Localization;
import com.vmware.opsmgmt.client.extension.alarms.definition.actions.ActionConfigDescription;
import com.vmware.opsmgmt.client.extension.alarms.definition.actions.ActionWrapper;
import com.vmware.vim.binding.vim.action.CreateTaskAction;
import com.vmware.vim.binding.vim.alarm.AlarmTriggeringAction;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class CreateTaskActionWrapper
extends ActionWrapper {
    public static final String CANCELABLE = "cancelable";
    public static final String TASK_TYPE_ID = "taskTypeId";

    public CreateTaskActionWrapper(AlarmTriggeringAction action) {
        super(action, "action.task.actionName");
    }

    @Override
    public List<ActionConfigDescription> getConfiguration() {
        ArrayList<ActionConfigDescription> configs = new ArrayList<ActionConfigDescription>();
        CreateTaskAction taskAction = (CreateTaskAction)this._action.action;
        ActionConfigDescription canelable = new ActionConfigDescription(CANCELABLE, Localization.getString("action.task.cancelable"), taskAction.cancelable, this.getTaskCancelable(taskAction));
        configs.add(canelable);
        ActionConfigDescription typeId = new ActionConfigDescription(TASK_TYPE_ID, Localization.getString("action.task.taskTypeId"), taskAction.taskTypeId.toString(), taskAction.taskTypeId.toString());
        configs.add(typeId);
        return configs;
    }

    @Override
    public void setConfiguration(List<ActionConfigDescription> conf) {
        Validate.notNull(conf);
        CreateTaskAction taskAction = (CreateTaskAction)this._action.action;
        for (ActionConfigDescription descr : conf) {
            String propName;
            switch (propName = descr.getName()) {
                case "taskTypeId": {
                    taskAction.taskTypeId = descr.getValue().toString();
                    break;
                }
                case "cancelable": {
                    taskAction.cancelable = Boolean.getBoolean(descr.getValue().toString());
                }
            }
        }
    }

    @Override
    public String getConfigString() {
        CreateTaskAction taskAction = (CreateTaskAction)this._action.action;
        String cancelable = Boolean.toString(taskAction.cancelable);
        String taskId = taskAction.taskTypeId;
        if (StringUtils.isEmpty((CharSequence)taskId)) {
            return "";
        }
        if (StringUtils.isEmpty((CharSequence)cancelable)) {
            cancelable = "false";
        }
        return Localization.getString("action.task.taskTypeId") + " " + taskId + ", " + Localization.getString("action.task.cancelable") + " " + cancelable;
    }

    @Override
    public String validateConfigString(String config) {
        if (StringUtils.isEmpty((CharSequence)config)) {
            String s = "createTaskActionWrapper.error.configure.taskId";
            return Localization.getString(s);
        }
        return "";
    }

    @Override
    public boolean supportsConfiguration() {
        return true;
    }

    @Override
    protected String validateConfigurationInternal() {
        CreateTaskAction action = (CreateTaskAction)this._action.action;
        return this.validateConfigString(action.taskTypeId);
    }

    private String getTaskCancelable(CreateTaskAction taskAction) {
        Validate.notNull((Object)taskAction);
        if (taskAction.cancelable) {
            return Localization.getString("action.task.cancelable.true");
        }
        return Localization.getString("action.task.cancelable.false");
    }
}

