/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms.expressions;

import com.vmware.opsmgmt.client.alarms.AlarmDefinitionInfo;
import com.vmware.opsmgmt.client.alarms.EventAlarmDetails;
import com.vmware.opsmgmt.client.extension.alarms.Localization;
import com.vmware.opsmgmt.client.extension.alarms.configuration.Trigger;
import com.vmware.opsmgmt.client.extension.alarms.expressions.ExpressionWrapper;
import com.vmware.vim.binding.vim.alarm.EventAlarmExpression;
import com.vmware.vim.binding.vim.event.EventDescription;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class EventExpressionWrapper
extends ExpressionWrapper {
    private static final String BINDING_PACKAGE = "com.vmware.vim.binding.";
    private final EventAlarmExpression _expression;
    private EventAlarmDetails _details;
    private String _name;

    public EventExpressionWrapper(EventAlarmExpression expression, AlarmDefinitionInfo info) {
        Validate.notNull((Object)expression);
        Validate.notNull((Object)info);
        this._expression = expression;
        this._info = info;
        String eventTypeId = this.getEventTypeId();
        this._details = this.getEventDetails(eventTypeId, this._info);
        if (this._details != null) {
            this._name = this._details.description;
        }
        if (StringUtils.isEmpty((CharSequence)this._name)) {
            this._name = eventTypeId;
        }
    }

    public EventAlarmExpression getExpression() {
        return this._expression;
    }

    public EventAlarmDetails getDetails() {
        return this._details;
    }

    public EventAlarmExpression.Comparison[] getComparisons() {
        return this._expression.comparisons;
    }

    public void setComparisons(EventAlarmExpression.Comparison[] comparissons) {
        this._expression.comparisons = comparissons;
    }

    @Override
    public Trigger getTrigger() {
        return null;
    }

    public String getName() {
        return this._name;
    }

    public String getStatus() {
        if (this._expression.status == null) {
            return Localization.getVpxString("Alarm.AlarmHelper.AlarmStatus.Unset");
        }
        switch (this._expression.status) {
            case gray: {
                return Localization.getVpxString("Alarm.AlarmHelper.AlarmStatus.Unset");
            }
            case green: {
                return Localization.getVpxString("Alarm.AlarmHelper.AlarmStatus.Green");
            }
            case yellow: {
                return Localization.getVpxString("Alarm.AlarmHelper.AlarmStatus.Yellow");
            }
            case red: {
                return Localization.getVpxString("Alarm.AlarmHelper.AlarmStatus.Red");
            }
        }
        return Localization.getVpxString("Alarm.AlarmHelper.AlarmStatus.Unset");
    }

    public String getAttributeName(String attributeName) {
        if (this._details != null) {
            for (EventDescription.EventArgDesc arg : this._details.eventArguments) {
                if (!arg.name.equals(attributeName)) continue;
                return arg.description.label;
            }
        }
        return attributeName;
    }

    public String getOperator(String operator) {
        if (EventAlarmExpression.ComparisonOperator.startsWith.name().equals(operator)) {
            return Localization.getVpxString("Alarm.AlarmHelper.Comparison.StartsWith");
        }
        if (EventAlarmExpression.ComparisonOperator.doesNotStartWith.name().equals(operator)) {
            return Localization.getVpxString("Alarm.AlarmHelper.Comparison.DoesNotStartWith");
        }
        if (EventAlarmExpression.ComparisonOperator.endsWith.name().equals(operator)) {
            return Localization.getVpxString("Alarm.AlarmHelper.Comparison.EndsWith");
        }
        if (EventAlarmExpression.ComparisonOperator.doesNotEndWith.name().equals(operator)) {
            return Localization.getVpxString("Alarm.AlarmHelper.Comparison.DoesNotEndWith");
        }
        if (EventAlarmExpression.ComparisonOperator.equals.name().equals(operator)) {
            return Localization.getVpxString("Alarm.AlarmHelper.Comparison.Equals");
        }
        if (EventAlarmExpression.ComparisonOperator.notEqualTo.name().equals(operator)) {
            return Localization.getVpxString("Alarm.AlarmHelper.Comparison.NotEqualTo");
        }
        return operator;
    }

    public boolean isCustomEvent() {
        if (this.getDetails() == null) {
            return true;
        }
        return this._details.isCustomEvent;
    }

    public Boolean isSystemUnknownEvent() {
        return !this.isCustomEvent() && (this._details == null || StringUtils.isEmpty((CharSequence)this._details.description));
    }

    private String getEventTypeId() {
        String eventTypeId = this._expression.eventTypeId;
        if (StringUtils.isEmpty((CharSequence)eventTypeId)) {
            String className = this._expression.eventType.getName();
            eventTypeId = className.replace(BINDING_PACKAGE, "");
        }
        return eventTypeId;
    }

    private EventAlarmDetails getEventDetails(String eventTypeId, AlarmDefinitionInfo info) {
        for (EventAlarmDetails detail : info.events) {
            if (!detail.eventTypeId.equals(eventTypeId)) continue;
            return detail;
        }
        return null;
    }
}

