/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms.expressions;

import com.vmware.opsmgmt.client.alarms.AlarmDefinitionInfo;
import com.vmware.opsmgmt.client.extension.alarms.Localization;
import com.vmware.opsmgmt.client.extension.alarms.configuration.MetricTrigger;
import com.vmware.opsmgmt.client.extension.alarms.expressions.ExpressionWrapper;
import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vim.binding.vim.alarm.MetricAlarmExpression;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class MetricExpressionWrapper
extends ExpressionWrapper {
    private MetricTrigger _trigger;
    private final MetricAlarmExpression _expression;
    private final String _name;
    private final String _valueUnit;

    public MetricExpressionWrapper(MetricAlarmExpression expression, AlarmDefinitionInfo info) {
        Validate.notNull((Object)expression);
        Validate.notNull((Object)info);
        this._expression = expression;
        this._info = info;
        String counter = this.getCounter(expression, info);
        this._trigger = this.alarmConfig.getMetricTrigger(expression, counter);
        if (this._trigger == null) {
            this._trigger = new MetricTrigger();
            this._trigger.monitorObjectType = this._expression.type.getName();
            this._name = this.getNameFallback();
        } else {
            this._name = Localization.getTriggerName(this._trigger);
        }
        this._valueUnit = this.getUnit();
    }

    public String getName() {
        return this._name;
    }

    @Override
    public MetricTrigger getTrigger() {
        return this._trigger;
    }

    public String getCondition() {
        if (MetricAlarmExpression.MetricOperator.isAbove == this._expression.operator) {
            return Localization.getString("triggers.metric.above");
        }
        return Localization.getString("triggers.metric.below");
    }

    public String getWarningValue() {
        return this.getValue(this._expression.yellow);
    }

    public String getCriticalValue() {
        return this.getValue(this._expression.red);
    }

    public String getWarningInterval() {
        return this.getInterval(this._expression.yellowInterval);
    }

    public String getCriticalInterval() {
        return this.getInterval(this._expression.redInterval);
    }

    public String getWarningIntervalUnit() {
        return this.getIntervalUnit(this._expression.yellowInterval);
    }

    public String getCriticalIntervalUnit() {
        return this.getIntervalUnit(this._expression.redInterval);
    }

    public String getValueUnit() {
        return this._valueUnit;
    }

    private String getNameFallback() {
        return Localization.getFormattedString("triggers.metric.name", new String[]{Integer.toString(this._expression.metric.counterId)});
    }

    private String getCounter(MetricAlarmExpression expression, AlarmDefinitionInfo info) {
        int counterId = expression.metric.counterId;
        for (PerformanceManager.CounterInfo counterInfo : info.counters) {
            if (counterInfo.key != counterId) continue;
            return counterInfo.groupInfo.key + "." + counterInfo.nameInfo.key + "." + counterInfo.rollupType;
        }
        return null;
    }

    private String getValue(int value) {
        if (this._trigger.uiToApiValueFactor != 0) {
            value /= this._trigger.uiToApiValueFactor;
        }
        return Integer.toString(value);
    }

    private String getUnit() {
        String valueUnit = "";
        if (StringUtils.isNotEmpty((CharSequence)this._trigger.unitResourceId)) {
            valueUnit = Localization.getVpxString("Alarm.Metadata." + this._trigger.unitResourceId);
        }
        return valueUnit;
    }

    private String getInterval(int interval) {
        if (interval >= 60) {
            interval /= 60;
        }
        return Integer.toString(interval);
    }

    private String getIntervalUnit(int interval) {
        String key = interval < 60 ? "triggers.seconds" : "triggers.minutes";
        return Localization.getString(key);
    }
}

