/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms.expressions;

import com.vmware.opsmgmt.client.alarms.AlarmDefinitionInfo;
import com.vmware.opsmgmt.client.alarms.ServerCollection;
import com.vmware.opsmgmt.client.extension.alarms.AlarmsUtil;
import com.vmware.opsmgmt.client.extension.alarms.Localization;
import com.vmware.opsmgmt.client.extension.alarms.configuration.State;
import com.vmware.opsmgmt.client.extension.alarms.configuration.StateTrigger;
import com.vmware.opsmgmt.client.extension.alarms.expressions.ExpressionWrapper;
import com.vmware.vim.binding.vim.alarm.StateAlarmExpression;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class StateExpressionWrapper
extends ExpressionWrapper {
    private final StateAlarmExpression _expression;
    private StateTrigger _trigger;
    private final String _name;

    public StateExpressionWrapper(StateAlarmExpression expression, AlarmDefinitionInfo info) {
        Validate.notNull((Object)expression);
        Validate.notNull((Object)info);
        this._expression = expression;
        this._info = info;
        this._trigger = this.alarmConfig.getStateTrigger(expression);
        if (this._trigger == null) {
            this._trigger = new StateTrigger();
            this._trigger.monitorObjectType = this._expression.type.getName();
            this._name = this.getNameFallback();
        } else {
            this._name = Localization.getTriggerName(this._trigger);
        }
    }

    public String getName() {
        return this._name;
    }

    public String getCondition() {
        if (StateAlarmExpression.StateOperator.isEqual.equals((Object)this._expression.operator)) {
            return Localization.getString("triggers.state.equal");
        }
        return Localization.getString("triggers.state.notEqual");
    }

    public String warningValue() {
        return this.getExpressionValue(this._expression.yellow);
    }

    public String criticalValue() {
        return this.getExpressionValue(this._expression.red);
    }

    private String getNameFallback() {
        return AlarmsUtil.getLocalizedMonitorType(this._expression.type) + " " + this._expression.statePath;
    }

    private String getExpressionValue(String stateValue) {
        if (StringUtils.isEmpty((CharSequence)stateValue)) {
            return Localization.getVpxString("Alarm.Configuration.State.None");
        }
        String result = this.getState(stateValue);
        if (result.equals(stateValue) && this._trigger.states != null && this._trigger.states.includeStates != null) {
            for (State state : this._trigger.states.includeStates) {
                if (!state.key.equals(stateValue)) continue;
                result = Localization.getVpxString("Alarm.Metadata." + state.labelResourceId);
                break;
            }
        }
        return result;
    }

    private String getState(String stateValue) {
        if (this._trigger.states == null || StringUtils.isEmpty((CharSequence)this._trigger.states.serverCollection) || this._info == null || this._info.states == null) {
            return stateValue;
        }
        String collectionName = this._trigger.states.serverCollection;
        ServerCollection serverCollection = null;
        for (ServerCollection serverCollection2 : this._info.states) {
            if (!collectionName.equals(serverCollection2.name)) continue;
            serverCollection = serverCollection2;
            break;
        }
        if (serverCollection == null) {
            return stateValue;
        }
        for (ServerCollection serverCollection3 : serverCollection.states) {
            if (!serverCollection3.key.equals(stateValue)) continue;
            return serverCollection3.label;
        }
        return stateValue;
    }
}

