/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.capacity;

import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.cluster.ResourceUsageSummary;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.capacity.data.util.CapacityObjectTypeConstants;
import com.vmware.vsphere.client.capacity.data.util.CapacityPropertyConstants;
import com.vmware.vsphere.client.capacity.util.CapacityAggregator;
import com.vmware.vsphere.client.capacity.util.CapacityQueryBuilder;
import com.vmware.vsphere.client.data.util.DataUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CapacityPropertyProviderAdapter
implements PropertyProviderAdapter {
    private static final String[] SUPPORTED_OBJECT_TYPES = new String[]{CapacityObjectTypeConstants.DATACENTER, CapacityObjectTypeConstants.CLUSTER, CapacityObjectTypeConstants.HOST_SYSTEM, CapacityObjectTypeConstants.FOLDER};
    private static final int MB_TO_BYTE = 0x100000;
    private static final Log _logger = LogFactory.getLog(CapacityPropertyProviderAdapter.class);
    private final DataService _dataService;

    public CapacityPropertyProviderAdapter(DataServiceExtensionRegistry registry, DataService dataService) {
        this._dataService = dataService;
        registry.registerDataAdapter((PropertyProviderAdapter)this, CapacityPropertyProviderAdapter.getProvidedTypeInfos());
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        _logger.debug((Object)("Requesting capacity related properties: " + Arrays.toString(propertyRequest.properties) + " for " + Arrays.toString(propertyRequest.objects)));
        ArrayList<ManagedObjectReference> clusters = new ArrayList<ManagedObjectReference>();
        ArrayList<ManagedObjectReference> allOtherObjects = new ArrayList<ManagedObjectReference>();
        ManagedObjectReference[] moRefs = DataUtil.extractObjectRefs((PropertyRequestSpec)propertyRequest);
        ArrayList<ResultItem> resultSetItems = new ArrayList<ResultItem>();
        for (ManagedObjectReference moRef : moRefs) {
            if (ClusterComputeResource.class.getSimpleName().equals(moRef.getType())) {
                clusters.add(moRef);
                continue;
            }
            allOtherObjects.add(moRef);
        }
        if (!clusters.isEmpty()) {
            Map<ManagedObjectReference, ResourceUsageSummary> clusterResourceUsageData = CapacityPropertyProviderAdapter.getClusterResourceUsageData(clusters);
            resultSetItems.addAll(CapacityPropertyProviderAdapter.aggregateClusterResults(clusterResourceUsageData, propertyRequest));
        }
        if (!allOtherObjects.isEmpty()) {
            if (allOtherObjects.size() == 1) {
                return this.requestSingleObject((ManagedObjectReference)allOtherObjects.get(0), propertyRequest);
            }
            QuerySpec[] querySpecs = CapacityQueryBuilder.buildQueries(allOtherObjects, propertyRequest.properties);
            RequestSpec requestSpec = new RequestSpec();
            requestSpec.querySpec = querySpecs;
            ResultSet[] rawData = this._dataService.getData((RequestSpec)requestSpec).resultSet;
            resultSetItems.addAll(CapacityPropertyProviderAdapter.aggregateResults(allOtherObjects, rawData, propertyRequest));
        }
        if (resultSetItems.isEmpty()) {
            _logger.info((Object)("No results received after an attempt to retrieve " + Arrays.toString(propertyRequest.properties) + " for " + Arrays.toString(propertyRequest.objects)));
            return new ResultSet();
        }
        ResultSet finalResult = new ResultSet();
        finalResult.items = resultSetItems.toArray(new ResultItem[0]);
        _logger.debug((Object)"Capacity related properties were successfully collected.");
        return finalResult;
    }

    private ResultSet requestSingleObject(ManagedObjectReference ref, PropertyRequestSpec propertyRequest) {
        PropertySpec[] properties = propertyRequest.properties;
        QuerySpec hostSpec = CapacityQueryBuilder.buildHostQuerySpec(ref, properties);
        QuerySpec datastoreSpec = CapacityQueryBuilder.buildDatastoreQuerySpec(ref, properties);
        if (hostSpec == null && datastoreSpec == null) {
            ResultSet result = new ResultSet();
            result.items = new ResultItem[0];
            return result;
        }
        QuerySpec[] querySpecs = hostSpec == null ? new QuerySpec[]{datastoreSpec} : (datastoreSpec == null ? new QuerySpec[]{hostSpec} : new QuerySpec[]{hostSpec, datastoreSpec});
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = querySpecs;
        Response response = this._dataService.getData(requestSpec);
        ResultItem resultItem = CapacityPropertyProviderAdapter.getZeroedResultItem(propertyRequest, ref);
        for (ResultSet rs : response.resultSet) {
            CapacityAggregator.aggregateData(rs, resultItem);
        }
        ResultSet result = new ResultSet();
        result.items = new ResultItem[]{resultItem};
        return result;
    }

    private static Map<ManagedObjectReference, ResourceUsageSummary> getClusterResourceUsageData(List<ManagedObjectReference> moRefs) {
        HashMap<ManagedObjectReference, ResourceUsageSummary> rawClusterData = new HashMap<ManagedObjectReference, ResourceUsageSummary>(moRefs.size());
        for (ManagedObjectReference moRef : moRefs) {
            try {
                ClusterComputeResource cluster = (ClusterComputeResource)ManagedObjectUtil.getManagedObject((ManagedObjectReference)moRef);
                ResourceUsageSummary clusterResourceUsage = cluster.getResourceUsage();
                rawClusterData.put(moRef, clusterResourceUsage);
            }
            catch (Exception e) {
                _logger.error((Object)("Unable to retrieve ClusterComputeResource for " + moRef), (Throwable)e);
            }
        }
        return rawClusterData;
    }

    private static TypeInfo[] getProvidedTypeInfos() {
        LinkedList<TypeInfo> typeInfos = new LinkedList<TypeInfo>();
        for (String objectType : SUPPORTED_OBJECT_TYPES) {
            TypeInfo typeInfo = new TypeInfo();
            typeInfo.type = objectType;
            typeInfo.properties = CapacityPropertyConstants.SUPPORTED_PROPERTIES;
            typeInfos.add(typeInfo);
        }
        return typeInfos.toArray(new TypeInfo[typeInfos.size()]);
    }

    private static List<ResultItem> aggregateResults(List<ManagedObjectReference> targetObjects, ResultSet[] rawResultSets, PropertyRequestSpec propertyRequest) {
        ArrayList<ResultItem> aggregatedItems = new ArrayList<ResultItem>(rawResultSets.length);
        for (ResultSet rawData : rawResultSets) {
            ManagedObjectReference targetObjectRef = CapacityPropertyProviderAdapter.findRefByQueryName(rawData, targetObjects);
            ResultItem resultItem = CapacityPropertyProviderAdapter.getZeroedResultItem(propertyRequest, targetObjectRef);
            CapacityAggregator.aggregateData(rawData, resultItem);
            aggregatedItems.add(resultItem);
        }
        return aggregatedItems;
    }

    private static List<ResultItem> aggregateClusterResults(Map<ManagedObjectReference, ResourceUsageSummary> clusterUsagesMap, PropertyRequestSpec propertyRequest) {
        ArrayList<ResultItem> clustersData = new ArrayList<ResultItem>(clusterUsagesMap.size());
        for (Map.Entry<ManagedObjectReference, ResourceUsageSummary> e : clusterUsagesMap.entrySet()) {
            ResourceUsageSummary clusterData = e.getValue();
            ResultItem resultItem = CapacityPropertyProviderAdapter.getZeroedResultItem(propertyRequest, e.getKey());
            for (PropertyValue property : resultItem.properties) {
                if ("totalCpuCapacity".equals(property.propertyName)) {
                    property.value = clusterData.getCpuCapacityMHz();
                    continue;
                }
                if ("usedCpuCapacity".equals(property.propertyName)) {
                    property.value = clusterData.getCpuUsedMHz();
                    continue;
                }
                if ("freeCpuCapacity".equals(property.propertyName)) {
                    property.value = clusterData.getCpuCapacityMHz() - clusterData.getCpuUsedMHz();
                    continue;
                }
                if ("totalMemoryCapacity".equals(property.propertyName)) {
                    property.value = clusterData.getMemCapacityMB();
                    continue;
                }
                if ("usedMemoryCapacity".equals(property.propertyName)) {
                    property.value = clusterData.getMemUsedMB();
                    continue;
                }
                if ("freeMemoryCapacity".equals(property.propertyName)) {
                    property.value = clusterData.getMemCapacityMB() - clusterData.getMemUsedMB();
                    continue;
                }
                if ("totalStorageCapacity".equals(property.propertyName)) {
                    property.value = clusterData.getStorageCapacityMB();
                    continue;
                }
                if ("usedStorageCapacity".equals(property.propertyName)) {
                    property.value = clusterData.getStorageUsedMB();
                    continue;
                }
                if (!"freeStorageCapacity".equals(property.propertyName)) continue;
                property.value = clusterData.getStorageCapacityMB() - clusterData.getStorageUsedMB();
            }
            clustersData.add(resultItem);
        }
        return clustersData;
    }

    private static ManagedObjectReference findRefByQueryName(ResultSet resultSet, List<ManagedObjectReference> targetObjects) {
        String queryName = resultSet.queryName;
        if (StringUtils.isEmpty((CharSequence)queryName)) {
            _logger.warn((Object)"Query without a name!");
            return null;
        }
        int separatorIndex = queryName.indexOf(":");
        String refId = queryName.substring(separatorIndex + 1);
        if (StringUtils.isEmpty((CharSequence)refId)) {
            _logger.warn((Object)("Query name without a moRef Id specified - " + queryName));
            return null;
        }
        for (ManagedObjectReference targetObject : targetObjects) {
            if (!refId.equals(targetObject.toString())) continue;
            return targetObject;
        }
        _logger.warn((Object)("Query's moRef was not found - " + queryName));
        return null;
    }

    private static ResultItem getZeroedResultItem(PropertyRequestSpec propertyRequest, ManagedObjectReference moRef) {
        String[] requestedProps = DataUtil.extractSupportedProperties((PropertySpec[])propertyRequest.properties, (String[])CapacityPropertyConstants.SUPPORTED_PROPERTIES, (ManagedObjectReference)moRef);
        ResultItem resultItem = new ResultItem();
        resultItem.resourceObject = moRef;
        resultItem.properties = new PropertyValue[requestedProps.length];
        for (int i = 0; i < requestedProps.length; ++i) {
            String requestedPropName = requestedProps[i];
            PropertyValue propVal = new PropertyValue();
            propVal.propertyName = requestedPropName;
            propVal.value = 0L;
            resultItem.properties[i] = propVal;
        }
        return resultItem;
    }
}

