/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.capacity.util;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.capacity.data.util.CapacityObjectTypeConstants;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class CapacityAggregator {
    private static final int BYTES_MULTIPLIER = 1024;

    public static void aggregateData(ResultSet rawData, ResultItem resultsContainer) {
        AggregatedInfoMap aggregatedInfoMap = new AggregatedInfoMap();
        for (ResultItem item : rawData.items) {
            ManagedObjectReference rawDataRef = (ManagedObjectReference)item.resourceObject;
            if (ManagedObjectUtil.isOfType((ManagedObjectReference)rawDataRef, (String)CapacityObjectTypeConstants.HOST_SYSTEM)) {
                CapacityAggregator.aggregateHostData(aggregatedInfoMap, item);
                continue;
            }
            if (!ManagedObjectUtil.isOfType((ManagedObjectReference)rawDataRef, (String)CapacityObjectTypeConstants.DATASTORE)) continue;
            CapacityAggregator.aggregateDatastoreData(aggregatedInfoMap, item);
        }
        Set<String> propertyNames = aggregatedInfoMap.getPropertyNames();
        for (String propertyName : propertyNames) {
            PropertyValue propertyValue = CapacityAggregator.findPropertyByName(resultsContainer.properties, propertyName);
            if (propertyValue == null) continue;
            propertyValue.value = aggregatedInfoMap.getAggregatedValue(propertyName);
        }
    }

    private static void aggregateHostData(AggregatedInfoMap map, ResultItem item) {
        int cpuCoreCount = 0;
        long cpuFrequency = -1L;
        long cpuHostUsage = -1L;
        long memoryHostTotal = -1L;
        long memoryHostUsage = -1L;
        for (PropertyValue pv : item.properties) {
            if (pv.propertyName.equals("summary.hardware.numCpuCores")) {
                cpuCoreCount = ((Short)pv.value).shortValue();
                continue;
            }
            if (pv.propertyName.equals("summary.hardware.cpuMhz")) {
                cpuFrequency = ((Integer)pv.value).intValue();
                continue;
            }
            if (pv.propertyName.equals("summary.quickStats.overallCpuUsage")) {
                cpuHostUsage = ((Integer)pv.value).intValue();
                continue;
            }
            if (pv.propertyName.equals("hardware.memorySize")) {
                memoryHostTotal = (Long)pv.value;
                continue;
            }
            if (!pv.propertyName.equals("summary.quickStats.overallMemoryUsage")) continue;
            memoryHostUsage = ((Integer)pv.value).intValue();
        }
        if (cpuFrequency != -1L) {
            long totalHostCpu = (long)cpuCoreCount * cpuFrequency;
            map.accumulate("totalCpuCapacity", totalHostCpu);
        }
        if (cpuHostUsage != -1L) {
            map.accumulate("usedCpuCapacity", cpuHostUsage);
        }
        if (cpuFrequency != -1L && cpuHostUsage != -1L) {
            long totalHostCpu = (long)cpuCoreCount * cpuFrequency;
            map.accumulate("freeCpuCapacity", totalHostCpu - cpuHostUsage);
        }
        if (memoryHostTotal != -1L) {
            map.accumulate("totalMemoryCapacity", memoryHostTotal);
        }
        if (memoryHostUsage != -1L) {
            long usedMemoryB = memoryHostUsage * 1024L * 1024L;
            map.accumulate("usedMemoryCapacity", usedMemoryB);
        }
        if (memoryHostTotal != -1L && memoryHostUsage != -1L) {
            long usedMemoryB = memoryHostUsage * 1024L * 1024L;
            map.accumulate("freeMemoryCapacity", memoryHostTotal - usedMemoryB);
        }
    }

    private static void aggregateDatastoreData(AggregatedInfoMap map, ResultItem item) {
        long datastoreTotalStorage = -1L;
        long datastoreFreeStorage = -1L;
        boolean isAlias = false;
        for (PropertyValue pv : item.properties) {
            if (pv.propertyName.equals("summary.capacity")) {
                datastoreTotalStorage = (Long)pv.value;
                continue;
            }
            if (pv.propertyName.equals("info.freeSpace")) {
                datastoreFreeStorage = (Long)pv.value;
                continue;
            }
            if (!pv.propertyName.equals("info.aliasOf")) continue;
            isAlias = pv.value instanceof String && StringUtils.isNotEmpty((CharSequence)((String)pv.value));
        }
        if (!isAlias) {
            if (datastoreTotalStorage != -1L) {
                map.accumulate("totalStorageCapacity", datastoreTotalStorage);
            }
            if (datastoreFreeStorage != -1L) {
                map.accumulate("freeStorageCapacity", datastoreFreeStorage);
            }
            if (datastoreFreeStorage != -1L && datastoreTotalStorage != -1L) {
                long storageUsed = datastoreTotalStorage - datastoreFreeStorage;
                map.accumulate("usedStorageCapacity", storageUsed);
            }
        }
    }

    private static PropertyValue findPropertyByName(PropertyValue[] props, String propertyName) {
        if (propertyName == null) {
            return null;
        }
        for (PropertyValue pv : props) {
            if (!propertyName.equals(pv.propertyName)) continue;
            return pv;
        }
        return null;
    }

    static class AggregatedInfoMap {
        private Map<String, Long> aggregatedValuesMap = new HashMap<String, Long>();

        AggregatedInfoMap() {
        }

        public void accumulate(String propKey, long valueToAdd) {
            Long value = this.aggregatedValuesMap.get(propKey);
            value = value == null ? Long.valueOf(valueToAdd) : Long.valueOf(value + valueToAdd);
            this.aggregatedValuesMap.put(propKey, value);
        }

        public Long getAggregatedValue(String propertyName) {
            return this.aggregatedValuesMap.get(propertyName);
        }

        public Set<String> getPropertyNames() {
            return this.aggregatedValuesMap.keySet();
        }
    }
}

