/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.perfstats.impl.util;

import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.perfstats.Metric;
import com.vmware.vsphere.client.perfstats.impl.model.EntityMetricsRequest;
import com.vmware.vsphere.client.perfstats.impl.model.VcMetricsRequest;
import com.vmware.vsphere.client.perfstats.impl.util.CounterInfoUtil;
import com.vmware.vsphere.client.perfstats.impl.util.PerfUtil;
import java.util.ArrayList;
import java.util.List;

public class QueryBuilder {
    public static PerformanceManager.QuerySpec[] buildQuerySpecs(VcMetricsRequest vcRequest) {
        ArrayList<PerformanceManager.QuerySpec> queries = new ArrayList<PerformanceManager.QuerySpec>();
        for (EntityMetricsRequest request : vcRequest.entityRequests) {
            PerformanceManager perfManager = PerfUtil.getPerfManager(vcRequest.vcUid);
            queries.add(QueryBuilder.buildQuery(perfManager, request.entity, request.metrics));
        }
        return queries.toArray(new PerformanceManager.QuerySpec[queries.size()]);
    }

    private static PerformanceManager.QuerySpec buildQuery(PerformanceManager perfManager, ManagedObjectReference moRef, List<Metric> metrics) {
        ArrayList<PerformanceManager.MetricId> metricIds = new ArrayList<PerformanceManager.MetricId>();
        for (Metric metric : metrics) {
            int counterId = CounterInfoUtil.getIdByName(perfManager, moRef.getServerGuid(), metric.name);
            metricIds.add(new PerformanceManager.MetricId(counterId, metric.instance));
        }
        PerformanceManager.QuerySpec querySpec = new PerformanceManager.QuerySpec();
        querySpec.setEntity(moRef);
        querySpec.setIntervalId(Integer.valueOf(20));
        querySpec.setMetricId(metricIds.toArray(new PerformanceManager.MetricId[metricIds.size()]));
        return querySpec;
    }
}

