/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.poweractions;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.vmware.vapi.protocol.HttpConfiguration;
import com.vmware.vcenter.apigw.api.sso.SsoService;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vise.usersession.UserSession;
import com.vmware.vise.usersession.UserSessionService;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vsphere.client.h5.poweractions.model.UserLoginSpec;
import com.vmware.vsphere.client.h5.poweractions.utils.PowerActionsUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class ExecutionHostAuthorizationProvider
implements HttpConfiguration.HeadersProvider {
    private static final Log _logger = LogFactory.getLog(ExecutionHostAuthorizationProvider.class);
    private static final String EXECUTION_HOST_AUTH_HEADER = "X-SES-Authorization";
    private static final String API_SESSIONS_URL = "/api/sessions";
    private final SsoService _ssoService;
    private final UserSessionService _userSessionService;
    String _executionHostUrl;
    private static Map<String, String> _authHeaderPerClientId = new ConcurrentHashMap<String, String>();

    public ExecutionHostAuthorizationProvider(SsoService ssoService, UserSessionService userSessionService, String executionHostUrl) {
        this._ssoService = ssoService;
        this._userSessionService = userSessionService;
        this._executionHostUrl = executionHostUrl;
    }

    public Iterable<HttpConfiguration.Header> getHeaders() {
        ArrayList<HttpConfiguration.Header> headers = new ArrayList<HttpConfiguration.Header>();
        HttpSession httpSession = SessionUtil.getHttpSession();
        String clientId = SessionUtil.getClientId((HttpSession)httpSession);
        if (clientId != null) {
            String authorizationHeader = this.getAuthorizationHeader(clientId);
            headers.add((HttpConfiguration.Header)new HttpConfiguration.BasicHeader(EXECUTION_HOST_AUTH_HEADER, authorizationHeader));
        }
        return headers;
    }

    public void clearState(String clientId) {
        if (clientId != null) {
            _authHeaderPerClientId.remove(clientId);
        }
    }

    public void clearAllState() {
        _authHeaderPerClientId.clear();
    }

    public boolean isAuthenticated(String clientId) {
        return _authHeaderPerClientId.containsKey(clientId);
    }

    private String getAuthorizationHeader(String clientId) {
        String authorizationHeader = _authHeaderPerClientId.get(clientId);
        if (authorizationHeader == null) {
            try {
                authorizationHeader = this.loginExecutionHost(clientId);
            }
            catch (Exception ex) {
                _logger.error((Object)"Unable to get the authorization header and login to the execution host.");
            }
        }
        return authorizationHeader;
    }

    private String loginExecutionHost(String clientId) throws Exception {
        Header header;
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpPost httpPost = new HttpPost(this._executionHostUrl + API_SESSIONS_URL);
        httpPost.addHeader("Content-Type", "application/json");
        UserSession userSession = this._userSessionService.getUserSession();
        if (userSession == null) {
            return null;
        }
        SamlToken token = PowerActionsUtil.getUserBearerToken(this._ssoService, userSession);
        UserLoginSpec loginSpec = new UserLoginSpec();
        loginSpec.samlToken = token.toXml();
        ObjectMapper mapper = new ObjectMapper();
        String loginSpecBody = mapper.writeValueAsString((Object)loginSpec);
        StringEntity requestEntity = new StringEntity(loginSpecBody);
        httpPost.setEntity((HttpEntity)requestEntity);
        HttpResponse response = client.execute((HttpUriRequest)httpPost);
        String authorizationHeader = null;
        if (response != null && (header = response.getFirstHeader(EXECUTION_HOST_AUTH_HEADER)) != null && (authorizationHeader = header.getValue()) != null) {
            _authHeaderPerClientId.put(clientId, authorizationHeader);
        }
        return authorizationHeader;
    }
}

