/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.poweractions;

import com.vmware.ses.About;
import com.vmware.ses.PowercliArgumentScripts;
import com.vmware.ses.PowercliScripts;
import com.vmware.ses.RunspaceScript;
import com.vmware.ses.Runspaces;
import com.vmware.ses.Scripts;
import com.vmware.ses.Sessions;
import com.vmware.vapi.client.ApiClient;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExecutionHostClient {
    private static final Log _logger = LogFactory.getLog(ExecutionHostClient.class);
    private final Sessions _sessionsService;
    private final Runspaces _runspacesService;
    private final RunspaceScript _runspaceScript;
    private final PowercliScripts _powerCliScripts;
    private final Scripts _scriptsService;
    private final About _versionService;
    private final PowercliArgumentScripts _powerCliArgumentsScripts;
    private ApiClient _apiClientProvider;

    public ExecutionHostClient(ApiClient apiClientProvider, ClassLoader classLoader) {
        this._apiClientProvider = apiClientProvider;
        ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        this._sessionsService = (Sessions)this._apiClientProvider.createStub(Sessions.class);
        this._runspacesService = (Runspaces)this._apiClientProvider.createStub(Runspaces.class);
        this._runspaceScript = (RunspaceScript)this._apiClientProvider.createStub(RunspaceScript.class);
        this._scriptsService = (Scripts)this._apiClientProvider.createStub(Scripts.class);
        this._powerCliScripts = (PowercliScripts)this._apiClientProvider.createStub(PowercliScripts.class);
        this._versionService = (About)this._apiClientProvider.createStub(About.class);
        this._powerCliArgumentsScripts = (PowercliArgumentScripts)this._apiClientProvider.createStub(PowercliArgumentScripts.class);
        Thread.currentThread().setContextClassLoader(originalLoader);
    }

    public void closeClientConnection() {
        if (this._apiClientProvider != null) {
            try {
                this._apiClientProvider.close();
            }
            catch (IOException ex) {
                _logger.warn((Object)"Unable to close properly the REST client connection.");
            }
        }
    }

    public Sessions getSessionsService() {
        return this._sessionsService;
    }

    public Runspaces getRunspacesService() {
        return this._runspacesService;
    }

    public RunspaceScript getRunspaceScriptService() {
        return this._runspaceScript;
    }

    public Scripts getScriptsService() {
        return this._scriptsService;
    }

    public PowercliScripts getPowerCliVcLoginService() {
        return this._powerCliScripts;
    }

    public PowercliArgumentScripts getPowerCliArgumentsService() {
        return this._powerCliArgumentsScripts;
    }

    public About getVersionService() {
        return this._versionService;
    }
}

