/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.poweractions.execution;

import com.vmware.ses.model.About;
import com.vmware.ses.model.ArgumentScriptParameter;
import com.vmware.ses.model.ArgumentScriptParametersList;
import com.vmware.ses.model.RunspaceResponse;
import com.vmware.ses.model.RunspaceScriptExecutionRequest;
import com.vmware.ses.model.ScriptExecutionRequest;
import com.vmware.ses.model.ScriptExecutionResponse;
import com.vmware.ses.model.ScriptExecutionStreams;
import com.vmware.ses.model.StreamRecord;
import com.vmware.ses.model.VCLoginScriptExecutionRequest;
import com.vmware.vapi.std.errors.InternalServerError;
import com.vmware.vapi.std.errors.NotFound;
import com.vmware.vcenter.apigw.api.sso.SsoService;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vise.security.ClientSessionEndListener;
import com.vmware.vise.usersession.UserSessionService;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.feature.FeatureStateService;
import com.vmware.vise.util.feature.names.Feature;
import com.vmware.vsphere.client.h5.poweractions.ExecutionHostApiClientProvider;
import com.vmware.vsphere.client.h5.poweractions.ExecutionHostClient;
import com.vmware.vsphere.client.h5.poweractions.execution.ScriptExecutionService;
import com.vmware.vsphere.client.h5.poweractions.model.ArgumentScript;
import com.vmware.vsphere.client.h5.poweractions.model.ExecuteScriptResult;
import com.vmware.vsphere.client.h5.poweractions.model.ExecutionHostDetails;
import com.vmware.vsphere.client.h5.poweractions.model.ScriptContent;
import com.vmware.vsphere.client.h5.poweractions.model.ScriptExecutionOutput;
import com.vmware.vsphere.client.h5.poweractions.model.StreamMessage;
import com.vmware.vsphere.client.h5.poweractions.specs.ExecuteScriptSpec;
import com.vmware.vsphere.client.h5.poweractions.specs.ParamSpec;
import com.vmware.vsphere.client.h5.poweractions.specs.ScriptSpec;
import com.vmware.vsphere.client.h5.poweractions.utils.PowerActionsUtil;
import com.vmware.vsphere.client.h5.poweractions.utils.ScriptParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class ScriptExecutionServiceImpl
implements ScriptExecutionService,
ClientSessionEndListener {
    private static final Log _logger = LogFactory.getLog(ScriptExecutionServiceImpl.class);
    private static final String SCRIPT_OBJECT_FORMAT = "text";
    private static final String ABOUT_INFO_API_ENDPOINT = "/api/about";
    private static final int HOST_CONNECTION_TIMEOUT = 10000;
    private static final String INTERNAL_SERVER_ERROR = "serverError";
    private static final String ID_ARGUMENT_NAME = "id";
    private static final String SERVER_GUID_ARGUMENT_NAME = "server_instance_uuid";
    private static final String DATE_ARGUMENT_NAME = "value";
    private static Map<String, String> _runspaceIdPerSessionId = new ConcurrentHashMap<String, String>();
    private static Set<String> _vcLoggedRunspaces = new CopyOnWriteArraySet<String>();
    private static final String EXECUTION_HOST_IP_ADDRESS_PROPERTY = "poweractions.executionHostIp";
    private final SsoService _ssoService;
    private final UserSessionService _userSessionService;
    private final ConfigurationService _configurationService;
    private final ExecutionHostApiClientProvider _apiClientProvider;
    private final FeatureStateService _featureStateService;
    private final String _executionHostUrlTemplate = "http://%s:5050";
    private final String _executionHostAddress;

    public ScriptExecutionServiceImpl(SsoService ssoService, UserSessionService userSessionService, ConfigurationService configurationService, ExecutionHostApiClientProvider apiClientProvider, FeatureStateService featureStateService) {
        this._ssoService = ssoService;
        this._userSessionService = userSessionService;
        this._apiClientProvider = apiClientProvider;
        this._configurationService = configurationService;
        this._featureStateService = featureStateService;
        this._executionHostAddress = this._configurationService.getProperty(EXECUTION_HOST_IP_ADDRESS_PROPERTY);
    }

    @Override
    public ExecuteScriptResult getPersistentScriptExecutionResult(ScriptSpec spec) {
        ScriptExecutionResponse scriptExecutionResponse = this.getClient().getScriptsService().get(spec.scriptId);
        return this.buildExecuteScriptResult(spec.runspaceId, scriptExecutionResponse);
    }

    @Override
    public ExecuteScriptResult getNonPersistentScriptExecutionResult(ScriptSpec spec) {
        ScriptExecutionResponse scriptExecutionResponse = this.getClient().getRunspaceScriptService().get(spec.runspaceId, spec.scriptId);
        return this.buildExecuteScriptResult(spec.runspaceId, scriptExecutionResponse);
    }

    @Override
    public ExecuteScriptResult executeScript(ExecuteScriptSpec spec) {
        ExecuteScriptResult executionScriptResult = new ExecuteScriptResult();
        if (spec.script != null && spec.script.name != null) {
            executionScriptResult.name = spec.script.name;
        }
        try {
            ScriptExecutionResponse scriptExecutionResponse;
            if (!this.isExecutionHostAvailable()) {
                return executionScriptResult;
            }
            String clientId = this._userSessionService.getUserSession().clientId;
            String runspaceId = this.prepareRunspace(clientId, spec.runInNewRunspace);
            try {
                scriptExecutionResponse = this.runScript(spec, runspaceId);
            }
            catch (NotFound notFoundException) {
                _runspaceIdPerSessionId.remove(clientId);
                runspaceId = this.prepareRunspace(clientId, spec.runInNewRunspace);
                scriptExecutionResponse = this.runScript(spec, runspaceId);
            }
            executionScriptResult = this.buildExecuteScriptResult(runspaceId, scriptExecutionResponse);
        }
        catch (InternalServerError internalError) {
            executionScriptResult.status = INTERNAL_SERVER_ERROR;
            executionScriptResult.error = PowerActionsUtil.getLocalizedErrorMessageByCode(internalError);
            _logger.error((Object)internalError);
        }
        catch (Exception exp) {
            _logger.error((Object)"Script execution failed.", (Throwable)exp);
            executionScriptResult.status = "error";
            executionScriptResult.error = exp.getLocalizedMessage();
        }
        return executionScriptResult;
    }

    @Override
    public void stopScriptExecution(String scriptId) {
        this.getClient().getScriptsService().cancel(scriptId);
    }

    @Override
    public ScriptExecutionResponse[] retrieveScriptsExecutions() {
        return this.getClient().getScriptsService().list().toArray(new ScriptExecutionResponse[0]);
    }

    @Override
    public ScriptExecutionStreams getScriptExecutionStreams(String scriptId) {
        return this.getClient().getScriptsService().getStreams(scriptId);
    }

    @Override
    public ScriptExecutionOutput getScriptExecutionOutput(String scriptId) {
        return this.getPersistentScriptOutput(scriptId);
    }

    @Override
    public ScriptExecutionOutput getConsoleExecutionOutput(String scriptId) {
        String clientSessionId = this._userSessionService.getUserSession().clientId;
        String defaultRunspaceId = _runspaceIdPerSessionId.get(clientSessionId);
        return this.getNonPersistentScriptOutput(defaultRunspaceId, scriptId);
    }

    @Override
    public ArgumentScript getArgumentScript(ParamSpec spec) {
        String scriptTemplate;
        ArgumentScript argumentScript = new ArgumentScript();
        if (ScriptParser.isSimpleTypeParameter(spec.type)) {
            return argumentScript;
        }
        String argumentScriptTemplateId = PowerActionsUtil.getArgumentScriptTemplateIdByType(spec.type);
        argumentScript.scriptTemplate = spec.scriptTemplate == null ? (scriptTemplate = this.getClient().getPowerCliArgumentsService().get(argumentScriptTemplateId)) : spec.scriptTemplate;
        if (!ScriptParser.hasParamValueSet(spec.value)) {
            return argumentScript;
        }
        argumentScript.scriptTransformation = this.getScriptTransformation(argumentScriptTemplateId, spec);
        return argumentScript;
    }

    @Override
    public void destroyDefaultRunspace() {
        String clientSessionId = this._userSessionService.getUserSession().clientId;
        this.destroyDefaultRunspace(clientSessionId);
    }

    @Override
    public void destroyRunspace(String runspaceId) {
        try {
            this.getClient().getRunspacesService().delete(runspaceId);
        }
        catch (Exception exp) {
            _logger.error((Object)("Cannot delete runspace: " + runspaceId), (Throwable)exp);
        }
    }

    @Override
    public ExecutionHostDetails retrieveExecutionHostDetails() {
        ExecutionHostDetails hostDetails = new ExecutionHostDetails();
        hostDetails.hostIpAddress = this._executionHostAddress;
        hostDetails.isAvailable = false;
        hostDetails.errorMessage = PowerActionsUtil.getLocalizedString("executionHost.error.initExecutionHostServices");
        try {
            if (!this.isExecutionHostAvailable()) {
                return hostDetails;
            }
            About versionInfo = this.getClient().getVersionService().get();
            if (versionInfo != null && versionInfo.getVersion() != null) {
                hostDetails.hostName = versionInfo.getName();
                hostDetails.hostVersion = versionInfo.getVersion();
                hostDetails.isAvailable = true;
                hostDetails.errorMessage = null;
            }
        }
        catch (Exception ex) {
            _logger.error((Object)ex);
            hostDetails.errorMessage = ex.getLocalizedMessage();
        }
        return hostDetails;
    }

    public void sessionEnded(String clientSessionId) {
        if (this.isPowerActionsFeatureEnabled() && this._apiClientProvider.isAuthenticated(clientSessionId)) {
            this.destroyDefaultRunspace(clientSessionId);
            try {
                this.getClient().getSessionsService().logout();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._apiClientProvider.clearAuthState(clientSessionId);
        }
    }

    private void destroyDefaultRunspace(String clientSessionId) {
        if (clientSessionId == null) {
            return;
        }
        String runspaceId = _runspaceIdPerSessionId.get(clientSessionId);
        if (runspaceId != null) {
            _runspaceIdPerSessionId.remove(clientSessionId);
            _vcLoggedRunspaces.remove(runspaceId);
            this.destroyRunspace(runspaceId);
        }
    }

    private ExecutionHostClient getClient() {
        return this._apiClientProvider.getClient(String.format("http://%s:5050", this._executionHostAddress), this.getClass().getClassLoader());
    }

    private boolean isExecutionHostAvailable() throws Exception {
        if (this._executionHostAddress == null) {
            throw new Exception(PowerActionsUtil.getLocalizedString("executionHost.error.noExecutionHostIp"));
        }
        RequestConfig.Builder requestBuilder = RequestConfig.custom();
        requestBuilder.setConnectTimeout(10000);
        requestBuilder.setConnectionRequestTimeout(10000);
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.setDefaultRequestConfig(requestBuilder.build());
        HttpGet httpGet = new HttpGet(String.format("http://%s:5050", this._executionHostAddress) + ABOUT_INFO_API_ENDPOINT);
        httpGet.addHeader("Content-Type", "application/json");
        CloseableHttpClient client = builder.build();
        CloseableHttpResponse response = client.execute((HttpUriRequest)httpGet);
        client.close();
        if (response == null || response.getStatusLine().getStatusCode() != 200) {
            throw new Exception(PowerActionsUtil.getLocalizedString("executionHost.error.initExecutionHostServices"));
        }
        return true;
    }

    private String prepareRunspace(String clientId, boolean newRunspace) throws Exception {
        String runspaceId = this.getRunspaceId(clientId, newRunspace);
        if (!_vcLoggedRunspaces.contains(runspaceId)) {
            this.loginAllVcenterServers(runspaceId);
            if (!newRunspace) {
                _vcLoggedRunspaces.add(runspaceId);
            }
        }
        return runspaceId;
    }

    private String getRunspaceId(String clientId, boolean newRunspace) throws Exception {
        String runspaceId = newRunspace ? this.createNewRunspace() : this.getDefaultRunspaceForClient(clientId);
        if (runspaceId == null) {
            throw new Exception(PowerActionsUtil.getLocalizedString("executionHost.error.powerCliRunspace"));
        }
        return runspaceId;
    }

    private String getDefaultRunspaceForClient(String clientId) throws Exception {
        String runspaceId = _runspaceIdPerSessionId.get(clientId);
        if (runspaceId == null) {
            runspaceId = this.createNewRunspace();
            if (runspaceId == null) {
                return null;
            }
            _runspaceIdPerSessionId.put(clientId, runspaceId);
        }
        return runspaceId;
    }

    private String createNewRunspace() throws Exception {
        RunspaceResponse runspaceResponse = this.getClient().getRunspacesService().create();
        return runspaceResponse != null ? runspaceResponse.getId() : null;
    }

    private void loginAllVcenterServers(String runspaceId) throws Exception {
        this.executeIgnoreCertificateScript(runspaceId);
        this.executeVcLoginScript(runspaceId);
    }

    private ScriptExecutionResponse executeIgnoreCertificateScript(String runspaceId) throws Exception {
        String certificatePatchCommand = "Set-PowerCLIConfiguration -InvalidCertificateAction Ignore -Scope Session -Confirm:$false";
        RunspaceScriptExecutionRequest scriptRequest = this.createNonPersistentScriptRequestSpec(certificatePatchCommand, null);
        ScriptExecutionResponse response = this.executeNonPersistentScriptRequest(runspaceId, scriptRequest);
        if ((response = this.waitNonPersistentExecutionToComplete(runspaceId, response.getId())) != null && "error".equals(response.getState())) {
            throw new Exception("Set-PowerCLIConfiguration operation failed: " + response.getReason());
        }
        return response;
    }

    private ScriptExecutionResponse executeVcLoginScript(String runspaceId) throws Exception {
        VCLoginScriptExecutionRequest loginRequestSpec = this.createLoginRequestSpec(runspaceId);
        ScriptExecutionResponse vcLoginResult = this.getClient().getPowerCliVcLoginService().vcLogin(loginRequestSpec);
        ScriptExecutionResponse response = this.waitPersistentExecutionToComplete(vcLoginResult.getId());
        if (response != null && "error".equals(response.getState())) {
            throw new Exception("VC Login operation failed: " + response.getReason());
        }
        return response;
    }

    private String getScriptTransformation(String argumentScriptTemplateId, ParamSpec paramSpec) {
        List<Object> transformationSpecs = new ArrayList<List<ArgumentScriptParametersList>>();
        if (ScriptParser.isDateParameter(paramSpec.type)) {
            transformationSpecs = this.buildDateTimeTransformationSpec(paramSpec);
        } else {
            transformationSpecs.add(this.buildVcObjectTransformationSpec(paramSpec));
        }
        StringBuilder scriptTransformation = new StringBuilder();
        for (List list : transformationSpecs) {
            String generatedTransformation = this.generateScriptTransformation(argumentScriptTemplateId, list);
            scriptTransformation.append(generatedTransformation);
            if (transformationSpecs.size() <= 1) continue;
            scriptTransformation.append("\n");
        }
        return scriptTransformation.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateScriptTransformation(String argumentScriptTemplateId, List<ArgumentScriptParametersList> argScriptParamsLists) {
        String scriptTransformation = "";
        try {
            scriptTransformation = this.getClient().getPowerCliArgumentsService().generate(argumentScriptTemplateId, argScriptParamsLists);
            return scriptTransformation;
        }
        catch (Exception ex) {
            _logger.error((Object)"Cannot generate a script params transformation:", (Throwable)ex);
        }
        finally {
            return scriptTransformation;
        }
    }

    private List<List<ArgumentScriptParametersList>> buildDateTimeTransformationSpec(ParamSpec spec) {
        ArrayList<List<ArgumentScriptParametersList>> specsList = new ArrayList<List<ArgumentScriptParametersList>>();
        if (ScriptParser.isDateParameter(spec.type)) {
            List<String> dateParamsArray = new ArrayList<String>();
            if (ArrayUtils.isNotEmpty((Object[])spec.value)) {
                String dateParamValue = spec.value[0];
                if (spec.isArray) {
                    dateParamsArray = Arrays.asList(ScriptParser.splitParamValues(dateParamValue));
                } else {
                    dateParamsArray.add(dateParamValue);
                }
            }
            for (String paramValue : dateParamsArray) {
                ArgumentScriptParameter valueArgument = ScriptParser.buildArgumentScriptParameter(DATE_ARGUMENT_NAME, Arrays.asList(paramValue));
                List<ArgumentScriptParameter> transformationArguments = Collections.singletonList(valueArgument);
                ArgumentScriptParametersList dateScriptParamsList = new ArgumentScriptParametersList();
                dateScriptParamsList.setParameters(transformationArguments);
                List<ArgumentScriptParametersList> argScriptParamsLists = Collections.singletonList(dateScriptParamsList);
                specsList.add(argScriptParamsLists);
            }
        }
        return specsList;
    }

    private List<ArgumentScriptParametersList> buildVcObjectTransformationSpec(ParamSpec spec) {
        ArrayList<ArgumentScriptParametersList> argScriptParamsLists = new ArrayList<ArgumentScriptParametersList>();
        ArrayList<ArgumentScriptParameter> argScriptParameters = new ArrayList<ArgumentScriptParameter>();
        Map<String, Set<String>> objectIdsByServerGuid = ScriptParser.buildServerGuidToObjectIdsMap(spec.value);
        for (Map.Entry<String, Set<String>> entry : objectIdsByServerGuid.entrySet()) {
            ArgumentScriptParametersList argScriptParamsList = new ArgumentScriptParametersList();
            ArgumentScriptParameter serverGuidArgumentParameter = ScriptParser.buildArgumentScriptParameter(SERVER_GUID_ARGUMENT_NAME, Arrays.asList(entry.getKey()));
            ArgumentScriptParameter idArgumentParameter = ScriptParser.buildArgumentScriptParameter(ID_ARGUMENT_NAME, new ArrayList<String>((Collection)entry.getValue()));
            argScriptParameters.add(idArgumentParameter);
            argScriptParameters.add(serverGuidArgumentParameter);
            argScriptParamsList.setParameters(argScriptParameters);
            argScriptParamsLists.add(argScriptParamsList);
        }
        return argScriptParamsLists;
    }

    private void getScriptTransformationsIfNeeded(List<ParamSpec> paramSpecs) {
        if (paramSpecs == null) {
            return;
        }
        for (ParamSpec paramSpec : paramSpecs) {
            if (ScriptParser.isSimpleTypeParameter(paramSpec.type) || !ScriptParser.hasParamValueSet(paramSpec.value) || !StringUtils.isEmpty((String)paramSpec.scriptTransformation)) continue;
            String argumentScriptTemplateId = PowerActionsUtil.getArgumentScriptTemplateIdByType(paramSpec.type);
            paramSpec.scriptTransformation = this.getScriptTransformation(argumentScriptTemplateId, paramSpec);
        }
    }

    private ScriptExecutionResponse runScript(ExecuteScriptSpec spec, String runspaceId) {
        if (spec.isPersistent) {
            ScriptExecutionRequest scriptExecutionRequest = this.createPersistentScriptRequestSpec(runspaceId, spec.script);
            return this.executePersistentScriptRequest(scriptExecutionRequest);
        }
        RunspaceScriptExecutionRequest runspaceScriptExecutionRequest = this.createNonPersistentScriptRequestSpec(spec.script);
        return this.executeNonPersistentScriptRequest(runspaceId, runspaceScriptExecutionRequest);
    }

    private ScriptExecutionResponse executePersistentScriptRequest(ScriptExecutionRequest scriptRequest) {
        return this.getClient().getScriptsService().start(scriptRequest);
    }

    private ScriptExecutionResponse executeNonPersistentScriptRequest(String runspaceId, RunspaceScriptExecutionRequest scriptRequest) {
        return this.getClient().getRunspaceScriptService().start(runspaceId, scriptRequest);
    }

    private ScriptExecutionResponse waitNonPersistentExecutionToComplete(String runspaceId, String scriptId) throws Exception {
        ScriptExecutionResponse response;
        do {
            Thread.sleep(500L);
        } while ("running".equals((response = this.getClient().getRunspaceScriptService().get(runspaceId, scriptId)).getState()));
        return response;
    }

    private ScriptExecutionResponse waitPersistentExecutionToComplete(String scriptId) throws Exception {
        ScriptExecutionResponse response;
        do {
            Thread.sleep(500L);
        } while ("running".equals((response = this.getClient().getScriptsService().get(scriptId)).getState()));
        return response;
    }

    private ScriptExecutionOutput getPersistentScriptOutput(String scriptId) {
        ScriptExecutionStreams streams = this.getClient().getScriptsService().getStreams(scriptId);
        ScriptExecutionOutput scriptExecutionOutput = new ScriptExecutionOutput();
        scriptExecutionOutput.streamMessages = this.getScriptExecutionStreamsMessages(streams);
        List scriptOutput = this.getClient().getScriptsService().getOutput(scriptId);
        scriptExecutionOutput.output = StringUtils.join((Collection)scriptOutput, (String)"");
        return scriptExecutionOutput;
    }

    private ScriptExecutionOutput getNonPersistentScriptOutput(String runspaceId, String scriptId) {
        ScriptExecutionStreams streams = this.getClient().getRunspaceScriptService().getStreams(runspaceId, scriptId);
        ScriptExecutionOutput scriptExecutionOutput = new ScriptExecutionOutput();
        scriptExecutionOutput.streamMessages = this.getScriptExecutionStreamsMessages(streams);
        List scriptOutput = this.getClient().getRunspaceScriptService().getOutput(runspaceId, scriptId);
        scriptExecutionOutput.output = StringUtils.join((Collection)scriptOutput, (String)"");
        return scriptExecutionOutput;
    }

    private List<StreamMessage> getScriptExecutionStreamsMessages(ScriptExecutionStreams streams) {
        List verboseStreams;
        List informationStreams;
        List warningStreams;
        ArrayList<StreamRecord> records = new ArrayList<StreamRecord>();
        List errorStreams = streams.getError();
        if (errorStreams != null) {
            records.addAll(errorStreams);
        }
        if ((warningStreams = streams.getWarning()) != null) {
            records.addAll(warningStreams);
        }
        if ((informationStreams = streams.getInformation()) != null) {
            records.addAll(informationStreams);
        }
        if ((verboseStreams = streams.getVerbose()) != null) {
            records.addAll(verboseStreams);
        }
        records.sort(new ScriptExecutionStreamRecordByDateComparator());
        ArrayList<StreamMessage> result = new ArrayList<StreamMessage>();
        for (StreamRecord record : records) {
            StreamMessage streamMessage = new StreamMessage();
            streamMessage.message = record.getMessage();
            streamMessage.type = errorStreams.contains(record) ? "error" : (warningStreams.contains(record) ? "warning" : "info");
            result.add(streamMessage);
        }
        return result;
    }

    private ExecuteScriptResult buildExecuteScriptResult(String runspaceId, ScriptExecutionResponse response) {
        ExecuteScriptResult executionScriptResult = new ExecuteScriptResult();
        executionScriptResult.runspaceId = runspaceId;
        executionScriptResult.id = response.getId();
        executionScriptResult.name = response.getName();
        executionScriptResult.status = response.getState();
        executionScriptResult.error = response.getReason();
        executionScriptResult.startTime = response.getStartTime();
        executionScriptResult.endTime = response.getEndTime();
        return executionScriptResult;
    }

    private VCLoginScriptExecutionRequest createLoginRequestSpec(String runspaceId) throws Exception {
        VCLoginScriptExecutionRequest loginRequestSpec = new VCLoginScriptExecutionRequest();
        loginRequestSpec.setRunspaceId(runspaceId);
        PowerActionsUtil.populateServerConnectionInfo(loginRequestSpec, this._userSessionService);
        SamlToken token = PowerActionsUtil.getUserBearerToken(this._ssoService, this._userSessionService.getUserSession());
        loginRequestSpec.setSamlToken(token.toXml());
        return loginRequestSpec;
    }

    private ScriptExecutionRequest createPersistentScriptRequestSpec(String runspaceId, String name, String script, List<ParamSpec> params) {
        ScriptExecutionRequest scriptRequestSpec = new ScriptExecutionRequest();
        scriptRequestSpec.setRunspaceId(runspaceId);
        scriptRequestSpec.setScript(script);
        scriptRequestSpec.setName(name);
        if (params != null) {
            this.getScriptTransformationsIfNeeded(params);
            scriptRequestSpec.setScriptParameters(ScriptParser.buildScriptParameters(params));
        }
        scriptRequestSpec.setOutputObjectsFormat(SCRIPT_OBJECT_FORMAT);
        return scriptRequestSpec;
    }

    private ScriptExecutionRequest createPersistentScriptRequestSpec(String runspaceId, ScriptContent content) {
        return this.createPersistentScriptRequestSpec(runspaceId, content.name, content.body, content.params);
    }

    private RunspaceScriptExecutionRequest createNonPersistentScriptRequestSpec(ScriptContent scriptContent) {
        return this.createNonPersistentScriptRequestSpec(scriptContent.body, scriptContent.params);
    }

    private RunspaceScriptExecutionRequest createNonPersistentScriptRequestSpec(String script, List<ParamSpec> params) {
        RunspaceScriptExecutionRequest scriptRequestSpec = new RunspaceScriptExecutionRequest();
        scriptRequestSpec.setScript(script);
        if (params != null) {
            this.getScriptTransformationsIfNeeded(params);
            scriptRequestSpec.setScriptParameters(ScriptParser.buildScriptParameters(params));
        }
        scriptRequestSpec.setOutputObjectsFormat(SCRIPT_OBJECT_FORMAT);
        return scriptRequestSpec;
    }

    private boolean isPowerActionsFeatureEnabled() {
        return this._featureStateService.isEnabled(Feature.h5uiPowerActions);
    }

    private class ScriptExecutionStreamRecordByDateComparator
    implements Comparator<StreamRecord> {
        private ScriptExecutionStreamRecordByDateComparator() {
        }

        @Override
        public int compare(StreamRecord record1, StreamRecord record2) {
            if (record1 == null) {
                return -1;
            }
            if (record2 == null) {
                return 1;
            }
            return record1.getTime().compareTo(record2.getTime());
        }
    }
}

