/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.poweractions.filter;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.common.api.filters.QueryFilterBuilder;
import com.vmware.vise.common.api.filters.annotations.QueryFilter;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vsphere.client.h5.poweractions.utils.PowerActionsUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScriptLibraryFilterBuilder
implements QueryFilterBuilder {
    private static final String LIBRARY_MODEL = "com.vmware.content.LibraryModel";
    private static final String LIBRARY_SERVER_GUID_PROP = "com.vmware.content.LibraryModel/serverGuid";
    private static final String LIBRARY_ITEM_LIBRARY_ID_PROPERTY = "com.vmware.content.library.ItemModel/libraryId";
    private static final String IS_NON_ROOT_RP_PROPERTY = "isNonRootRP";
    private static final String IS_ROOT_FOLDER_PROPERTY = "isRootFolder";
    private static final String IS_SYSTEM_FOLDER_PROPERTY = "isSystemFolder";
    private static final Log _logger = LogFactory.getLog(ScriptLibraryFilterBuilder.class);
    private final ObjectReferenceService _objectReferenceService;
    private final QueryService _queryService;

    public ScriptLibraryFilterBuilder(QueryServiceFactory queryServiceFactory, ObjectReferenceService objectReferenceService) {
        this._objectReferenceService = objectReferenceService;
        this._queryService = queryServiceFactory.getQueryService();
    }

    @QueryFilter(value="powerActionsLibraryFilter")
    public Filter powerActionsLibraryFilter(String rootFolderId) {
        Validate.notNull((Object)rootFolderId);
        ManagedObjectReference rootFolderRef = this.getMorRef(rootFolderId);
        if (rootFolderRef == null) {
            return null;
        }
        PropertyPredicate contentLibraryPredicate = new PropertyPredicate(LIBRARY_SERVER_GUID_PROP, PropertyPredicate.ComparisonOperator.EQUAL, (Object)rootFolderRef.getServerGuid());
        List<PropertyPredicate> predicateList = Arrays.asList(contentLibraryPredicate);
        return new Filter(predicateList);
    }

    @QueryFilter(value="powerActionsLibraryItemFilter")
    public Filter powerActionsLibraryItemFilter(String rootFolderId) {
        Validate.notNull((Object)rootFolderId);
        ManagedObjectReference rootFolderRef = this.getMorRef(rootFolderId);
        if (rootFolderRef == null) {
            return null;
        }
        ResultSet libraryResult = this._queryService.select(new String[]{"@modelKey"}).from(new String[]{LIBRARY_MODEL}).where(new PropertyPredicate[]{new PropertyPredicate(LIBRARY_SERVER_GUID_PROP, PropertyPredicate.ComparisonOperator.EQUAL, (Object)rootFolderRef.getServerGuid())}).fetch();
        ArrayList<String> libraryIds = new ArrayList<String>();
        for (ResourceItem item : libraryResult.getItems()) {
            URI libraryUri = (URI)item.get("@modelKey");
            String libraryId = PowerActionsUtil.getVapiUriObjectId(libraryUri.toString());
            libraryIds.add(libraryId);
        }
        PropertyPredicate contentLibraryItemPredicate = new PropertyPredicate(LIBRARY_ITEM_LIBRARY_ID_PROPERTY, PropertyPredicate.ComparisonOperator.IN, libraryIds);
        List<PropertyPredicate> predicateList = Arrays.asList(contentLibraryItemPredicate);
        return new Filter(predicateList);
    }

    @QueryFilter(value="powerActionsFolderFilter")
    public Filter powerActionsFolderFilter(String rootFolderId) {
        Validate.notNull((Object)rootFolderId);
        ManagedObjectReference rootFolderRef = this.getMorRef(rootFolderId);
        if (rootFolderRef == null) {
            return null;
        }
        PropertyPredicate serverGuidPredicate = new PropertyPredicate("@instanceUuid", PropertyPredicate.ComparisonOperator.EQUAL, (Object)rootFolderRef.getServerGuid());
        PropertyPredicate rootFolderPredicate = new PropertyPredicate(IS_ROOT_FOLDER_PROPERTY, PropertyPredicate.ComparisonOperator.EQUAL, (Object)false);
        PropertyPredicate isSystemFolderPredicate = new PropertyPredicate(IS_SYSTEM_FOLDER_PROPERTY, PropertyPredicate.ComparisonOperator.EQUAL, (Object)false);
        List<PropertyPredicate> criteria = Arrays.asList(serverGuidPredicate, rootFolderPredicate, isSystemFolderPredicate);
        return new Filter(criteria, LogicalOperator.AND);
    }

    @QueryFilter(value="powerActionsResourcePoolFilter")
    public Filter powerActionsResourcePoolFilter(String rootFolderId) {
        Validate.notNull((Object)rootFolderId);
        ManagedObjectReference rootFolderRef = this.getMorRef(rootFolderId);
        if (rootFolderRef == null) {
            return null;
        }
        PropertyPredicate serverGuidPredicate = new PropertyPredicate("@instanceUuid", PropertyPredicate.ComparisonOperator.EQUAL, (Object)rootFolderRef.getServerGuid());
        PropertyPredicate rootFolderPredicate = new PropertyPredicate(IS_NON_ROOT_RP_PROPERTY, PropertyPredicate.ComparisonOperator.EQUAL, (Object)true);
        List<PropertyPredicate> criteria = Arrays.asList(serverGuidPredicate, rootFolderPredicate);
        return new Filter(criteria, LogicalOperator.AND);
    }

    private ManagedObjectReference getMorRef(String objectId) {
        Object objectRef = this._objectReferenceService.getReference(objectId, true);
        if (objectRef == null) {
            _logger.warn((Object)"No valid object ref found for filter");
            return null;
        }
        return (ManagedObjectReference)objectRef;
    }
}

