/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.poweractions.utils;

import com.vmware.ses.model.VCLoginScriptExecutionRequest;
import com.vmware.sso.tokenmgmt.SsoDomainHelper;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.std.errors.InternalServerError;
import com.vmware.vcenter.apigw.api.sso.SsoDomain;
import com.vmware.vcenter.apigw.api.sso.SsoService;
import com.vmware.vcenter.apigw.api.sso.TokenProperties;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vise.usersession.ServerInfo;
import com.vmware.vise.usersession.UserSession;
import com.vmware.vise.usersession.UserSessionService;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.lookup.LookupService;
import com.vmware.vise.vim.lookup.LookupUtil;
import com.vmware.vise.vim.security.sso.SsoConstants;
import com.vmware.vsphere.client.h5.poweractions.utils.ScriptParser;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PowerActionsUtil {
    private static final Log _logger = LogFactory.getLog(PowerActionsUtil.class);
    private static final String RESOURCE_BUNDLE_NAME = "h5poweractionsservice";
    private static final ClassLoader CLASS_LOADER = PowerActionsUtil.class.getClassLoader();
    private static final String PS_EXEC_HOST_SERVICE_TYPE = "psexecutionhost";
    private static final String PS_EXEC_HOST_PRODUCT_ID = "com.vmware.psexecutionhost";
    private static final String VM_PCLI_TYPE = "VMware.VimAutomation.ViCore.Types.V1.Inventory.VirtualMachine";
    private static final String OPAQUE_NETWORK_PCLI_TYPE = "VMware.VimAutomation.ViCore.Types.V1.Network.OpaqueNetwork";
    private static final String URI_PARTS_SEPARATOR = ":";
    private static final String TEMPLATE_ID = "-by-id-server-instance-uuid";
    private static final String DATE_TEMPLATE_ID = "date-by-string";
    private static final String VM_PREFIX = "vm";
    private static final String NETWORK_PREFIX = "network";
    private static final String CODE_FIELD_NAME = "code";

    public static String getLocalizedString(String localizationKey) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)localizationKey, (ClassLoader)CLASS_LOADER);
    }

    public static String getLocalizedString(String localizationKey, String ... attributes) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)localizationKey, (String[])attributes, (ClassLoader)CLASS_LOADER);
    }

    public static ServiceRegistration.Endpoint getPowerCliExecutionHostEndpoint(LookupService lookupService) {
        if (lookupService == null) {
            _logger.warn((Object)PowerActionsUtil.getLocalizedString("executionHost.error.lookupService"));
            return null;
        }
        ServiceRegistration.Filter filter = new ServiceRegistration.Filter();
        filter.serviceType = new ServiceRegistration.ServiceType(PS_EXEC_HOST_PRODUCT_ID, PS_EXEC_HOST_SERVICE_TYPE);
        filter.searchAllSsoDomains = true;
        ServiceRegistration.Info[] searchResult = lookupService.getServiceRegistrationInfos(filter);
        if (searchResult.length > 0) {
            ServiceRegistration.Info psExecutionHostInfo = searchResult[0];
            return LookupUtil.getEndpoint((ServiceRegistration.Info)psExecutionHostInfo, (String)PS_EXEC_HOST_PRODUCT_ID);
        }
        return null;
    }

    public static SamlToken getUserBearerToken(SsoService ssoService, UserSession userSession) throws Exception {
        SsoDomain localDomain = SsoDomainHelper.getLocal();
        SamlToken userSamlToken = ssoService.buildToken(localDomain, userSession.samlTokenXml);
        TokenProperties tokenProps = new TokenProperties(SsoConstants.DEFAULT_SSO_TOKEN_LIFETIME_SECS, userSamlToken.isDelegable(), userSamlToken.isRenewable());
        SamlToken bearerToken = ssoService.acquireBearerTokenFromToken(localDomain, localDomain, userSamlToken, tokenProps).getToken();
        return bearerToken;
    }

    public static String getVapiUriObjectId(String objectUri) {
        String[] urlParts = PowerActionsUtil.getVapiUriParts(objectUri);
        if (urlParts == null || urlParts.length < 4) {
            return null;
        }
        return urlParts[3];
    }

    public static String getVapiUriNodeId(String objectUri) {
        String[] urlParts = PowerActionsUtil.getVapiUriParts(objectUri);
        if (urlParts == null || urlParts.length != 5) {
            return null;
        }
        return urlParts[4];
    }

    private static String[] getVapiUriParts(String objectUri) {
        if (objectUri == null || objectUri.isEmpty()) {
            return null;
        }
        return objectUri.split(URI_PARTS_SEPARATOR);
    }

    public static VCLoginScriptExecutionRequest populateServerConnectionInfo(VCLoginScriptExecutionRequest loginSpec, UserSessionService userSessionService) {
        ServerInfo[] serverInfos;
        if (loginSpec == null) {
            return null;
        }
        UserSession userSession = userSessionService.getUserSession();
        if (userSession != null && (serverInfos = userSession.serversInfo) != null) {
            loginSpec.setAllLinked(Boolean.valueOf(serverInfos.length > 1));
            for (ServerInfo info : serverInfos) {
                if (info.sessionCookie == null || info.serviceGuid == null) continue;
                loginSpec.setServer(info.name);
                break;
            }
        }
        return loginSpec;
    }

    public static String getArgumentScriptTemplateIdByType(String powerCliObjectType) {
        String prefix = "";
        if (StringUtils.isEmpty((CharSequence)powerCliObjectType)) {
            return prefix;
        }
        if (ScriptParser.isDateParameter(powerCliObjectType)) {
            return DATE_TEMPLATE_ID;
        }
        if (VM_PCLI_TYPE.equals(powerCliObjectType)) {
            prefix = VM_PREFIX;
        } else if (OPAQUE_NETWORK_PCLI_TYPE.equals(powerCliObjectType)) {
            prefix = NETWORK_PREFIX;
        } else {
            int lastDotIndex = powerCliObjectType.lastIndexOf(46);
            if (lastDotIndex == -1) {
                return prefix;
            }
            prefix = powerCliObjectType.substring(lastDotIndex + 1).toLowerCase();
        }
        return prefix + TEMPLATE_ID;
    }

    public static String getLocalizedErrorMessageByCode(InternalServerError error) {
        String errorKey;
        String errorMessage;
        if (error == null || error.getData() == null || error.getData()._getDataValue() == null) {
            return "";
        }
        DataValue errorCodeValue = error.getData()._getDataValue().getField(CODE_FIELD_NAME);
        if (errorCodeValue != null && !(errorMessage = PowerActionsUtil.getLocalizedString(errorKey = String.format("executionHost.error.code.%s", errorCodeValue.toString()))).equals(errorKey)) {
            return errorMessage;
        }
        return error.getMessage();
    }

    public static String getLibraryItemContentVersion(String contentVersionUri) {
        return PowerActionsUtil.getVapiUriObjectId(contentVersionUri);
    }
}

