/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vcha;

import com.google.common.base.Preconditions;
import com.vmware.vapi.bindings.Structure;
import com.vmware.vapi.bindings.client.InvocationConfig;
import com.vmware.vapi.std.errors.UnverifiedPeer;
import com.vmware.vcenter.vcha.CertificateInfo;
import com.vmware.vcenter.vcha.Cluster;
import com.vmware.vcenter.vcha.ClusterTypes;
import com.vmware.vcenter.vcha.CredentialsSpec;
import com.vmware.vcenter.vcha.VcCredentials;
import com.vmware.vcenter.vcha.cluster.Active;
import com.vmware.vcenter.vcha.cluster.ActiveTypes;
import com.vmware.vcenter.vcha.cluster.Mode;
import com.vmware.vcenter.vcha.cluster.Passive;
import com.vmware.vcenter.vcha.cluster.PassiveTypes;
import com.vmware.vcenter.vcha.cluster.Witness;
import com.vmware.vcenter.vcha.cluster.WitnessTypes;
import com.vmware.vim.binding.vim.Task;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.core.model.mutation.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.vapi.VapiConnectionManager;
import com.vmware.vise.vim.vapi.util.VapiUtil;
import com.vmware.vsphere.client.h5.vcha.model.CheckSpec;
import com.vmware.vsphere.client.h5.vcha.model.DeploySpec;
import com.vmware.vsphere.client.h5.vcha.model.FailoverSpec;
import com.vmware.vsphere.client.h5.vcha.model.ModeSpec;
import com.vmware.vsphere.client.h5.vcha.model.RedeploySpec;
import com.vmware.vsphere.client.h5.vcha.model.UndeploySpec;
import com.vmware.vsphere.client.h5.vcha.model.ValidateActiveNodeSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VchaMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(VchaMutationProvider.class);
    private final VapiConnectionManager _apiGwBasedConnectionManager;

    public VchaMutationProvider(VapiConnectionManager apiGwBasedConnectionManager) {
        this._apiGwBasedConnectionManager = (VapiConnectionManager)Preconditions.checkNotNull((Object)apiGwBasedConnectionManager, (Object)"apiGwBasedConnectionManager is found null");
    }

    public OperationResult apply(ManagedObjectReference vcRef, ModeSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = vcRef;
        try {
            InvocationConfig invConfig = VapiUtil.newInvocationConfig((String)vcRef.getServerGuid());
            Mode mode = (Mode)this._apiGwBasedConnectionManager.createServiceStub(Mode.class);
            String taskUid = mode.set_Task(spec.mode, invConfig);
            this.fillupOperationResultWithTask(taskUid, result);
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed while calling vcha Mode.set() ", (Throwable)ex);
            result.error = ex;
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference vcRef, FailoverSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = vcRef;
        try {
            InvocationConfig invConfig = VapiUtil.newInvocationConfig((String)vcRef.getServerGuid());
            Cluster cluster = (Cluster)this._apiGwBasedConnectionManager.createServiceStub(Cluster.class);
            String taskUid = cluster.failover_Task(spec.planned, invConfig);
            this.fillupOperationResultWithTask(taskUid, result);
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed while calling vcha Cluster.failover() ", (Throwable)ex);
            result.error = ex;
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference vcRef, UndeploySpec spec) {
        OperationResult result = new OperationResult();
        result.entity = vcRef;
        try {
            InvocationConfig invConfig = VapiUtil.newInvocationConfig((String)vcRef.getServerGuid());
            Cluster cluster = (Cluster)this._apiGwBasedConnectionManager.createServiceStub(Cluster.class);
            ClusterTypes.UndeploySpec removeVchaSpec = new ClusterTypes.UndeploySpec();
            removeVchaSpec.setVcSpec(spec.credentialsSpec);
            removeVchaSpec.setForceDelete(Boolean.valueOf(spec.forceDeleteVms));
            String taskUid = cluster.undeploy_Task(removeVchaSpec, invConfig);
            this.fillupOperationResultWithTask(taskUid, result);
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed while calling vcha Cluster.undeploy() ", (Throwable)ex);
            result.error = ex;
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference vcRef, DeploySpec spec) {
        OperationResult result = new OperationResult();
        result.entity = vcRef;
        try {
            InvocationConfig invConfig = VapiUtil.newInvocationConfig((String)vcRef.getServerGuid());
            Cluster cluster = (Cluster)this._apiGwBasedConnectionManager.createServiceStub(Cluster.class);
            String taskUid = cluster.deploy_Task(spec.deploySpec, invConfig);
            this.fillupOperationResultWithTask(taskUid, result);
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed while calling vcha Cluster.deploy() ", (Throwable)ex);
            result.error = ex;
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference vcRef, RedeploySpec redeploySpec) {
        OperationResult result = new OperationResult();
        result.entity = vcRef;
        try {
            InvocationConfig invConfig = VapiUtil.newInvocationConfig((String)vcRef.getServerGuid());
            String taskUid = "";
            if (redeploySpec.nodeRole.equals((Object)ClusterTypes.NodeRole.PASSIVE)) {
                Passive passive = (Passive)this._apiGwBasedConnectionManager.createServiceStub(Passive.class);
                taskUid = passive.redeploy_Task(redeploySpec.passiveRedeploySpec, invConfig);
            } else if (redeploySpec.nodeRole.equals((Object)ClusterTypes.NodeRole.WITNESS)) {
                Witness witness = (Witness)this._apiGwBasedConnectionManager.createServiceStub(Witness.class);
                taskUid = witness.redeploy_Task(redeploySpec.witnessRedeploySpec, invConfig);
            } else {
                throw new IllegalArgumentException("Illegal nodeRole argument. Only PASSIVE or WITNESS nodes can be redeployed.");
            }
            this.fillupOperationResultWithTask(taskUid, result);
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed while calling vcha redeploy node() ", (Throwable)ex);
            result.error = ex;
        }
        return result;
    }

    public ValidationResult validate(ManagedObjectReference vcRef, CredentialsSpec spec) {
        ValidationResult result = new ValidationResult();
        result.entity = vcRef;
        try {
            InvocationConfig invConfig = VapiUtil.newInvocationConfig((String)vcRef.getServerGuid());
            VcCredentials vcCredentials = (VcCredentials)this._apiGwBasedConnectionManager.createServiceStub(VcCredentials.class);
            vcCredentials.validate(spec, invConfig);
        }
        catch (UnverifiedPeer ex) {
            if (ex.getData()._hasTypeNameOf(CertificateInfo.class)) {
                CertificateInfo info = (CertificateInfo)ex.getData()._convertTo(CertificateInfo.class);
                ex.setData((Structure)info);
            }
            _logger.warn((Object)"UnverifiedPeer exception caught while validating VC's credentials spec");
            result.error = ex;
        }
        catch (Exception ex) {
            _logger.error((Object)"Error while calling vcha VcCredentials.validate()", (Throwable)ex);
            result.error = ex;
        }
        return result;
    }

    public ValidationResult validate(ManagedObjectReference vcRef, CheckSpec checkSpec) {
        ValidationResult result;
        block4: {
            result = new ValidationResult();
            result.entity = vcRef;
            try {
                InvocationConfig invConfig = VapiUtil.newInvocationConfig((String)vcRef.getServerGuid());
                if (checkSpec.nodeRole.equals((Object)ClusterTypes.NodeRole.PASSIVE)) {
                    Passive passive = (Passive)this._apiGwBasedConnectionManager.createServiceStub(Passive.class);
                    PassiveTypes.CheckResult checkResult = passive.check(checkSpec.passiveCheckSpec, invConfig);
                    result.result = checkResult;
                    break block4;
                }
                if (checkSpec.nodeRole.equals((Object)ClusterTypes.NodeRole.WITNESS)) {
                    Witness witness = (Witness)this._apiGwBasedConnectionManager.createServiceStub(Witness.class);
                    WitnessTypes.CheckResult checkResult = witness.check(checkSpec.witnessCheckSpec, invConfig);
                    result.result = checkResult;
                    break block4;
                }
                throw new IllegalArgumentException("Invalid node role. PASSIVE and WITNESS are the only types for check");
            }
            catch (Exception ex) {
                _logger.error((Object)"Error while calling vcha check");
                result.error = ex;
            }
        }
        return result;
    }

    public ValidationResult validate(ManagedObjectReference vcRef, ValidateActiveNodeSpec spec) {
        ValidationResult result = new ValidationResult();
        result.entity = vcRef;
        try {
            InvocationConfig invConfig = VapiUtil.newInvocationConfig((String)vcRef.getServerGuid());
            Active active = (Active)this._apiGwBasedConnectionManager.createServiceStub(Active.class);
            ActiveTypes.Info activeInfo = active.get(spec.credentialsSpec, Boolean.valueOf(spec.partialInfoRequired), invConfig);
            result.result = activeInfo;
        }
        catch (UnverifiedPeer ex) {
            if (ex.getData()._hasTypeNameOf(CertificateInfo.class)) {
                CertificateInfo info = (CertificateInfo)ex.getData()._convertTo(CertificateInfo.class);
                ex.setData((Structure)info);
            }
            _logger.warn((Object)"UnverifiedPeer exception caught while validating or getting active node");
            result.error = ex;
        }
        catch (Exception ex) {
            _logger.error((Object)"Error while calling vcha active.get", (Throwable)ex);
            result.error = ex;
        }
        return result;
    }

    private void fillupOperationResultWithTask(String taskUid, OperationResult result) {
        ManagedObjectReference task = this.getTaskRef(taskUid);
        result.task = task;
        result.taskUid = ManagedObjectUtil.morefToString((ManagedObjectReference)task);
    }

    private ManagedObjectReference getTaskRef(String taskUid) {
        String[] taskUidParts = taskUid.split(":");
        String vmodl1TaskClassName = Task.class.getSimpleName();
        ManagedObjectReference task = new ManagedObjectReference(vmodl1TaskClassName, taskUidParts[0], taskUidParts[1]);
        return task;
    }
}

