/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vcha;

import com.google.common.base.Preconditions;
import com.vmware.vapi.bindings.client.AsyncCallback;
import com.vmware.vapi.bindings.client.AsyncCallbackFuture;
import com.vmware.vapi.bindings.client.InvocationConfig;
import com.vmware.vcenter.vcha.Capabilities;
import com.vmware.vcenter.vcha.CapabilitiesTypes;
import com.vmware.vcenter.vcha.Cluster;
import com.vmware.vcenter.vcha.CredentialsSpec;
import com.vmware.vcenter.vcha.License;
import com.vmware.vcenter.vcha.LicenseTypes;
import com.vmware.vcenter.vcha.Operations;
import com.vmware.vcenter.vcha.cluster.Active;
import com.vmware.vcenter.vcha.cluster.DeploymentType;
import com.vmware.vcenter.vcha.cluster.Mode;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.exception.CompositeException;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.vapi.VapiConnectionManager;
import com.vmware.vise.vim.vapi.util.VapiUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VchaPropertyProviderAdapter
implements PropertyProviderAdapter {
    private static final Log _logger = LogFactory.getLog(VchaPropertyProviderAdapter.class);
    private static final String VCHA_MODE_PROP = "vchaMode";
    private static final String VCHA_CLUSTER_CONFIG_PROP = "vchaClusterConfig";
    private static final String VCHA_CAPABILITIES_PROP = "vchaCapability";
    private static final String VCHA_DEPLOYMENT_PROP = "vchaDeployment";
    private static final String VCHA_CLUSTER_PLACEMENT_INFO_PROP = "vchaClusterPlacementInfo";
    private static final String VCHA_OPERATIONS_PROP = "vchaOperations";
    private static final String IS_VCHA_AVAILABLE_PROP = "isVchaAvailable";
    private static final String VCHA_ACTIVE_INFO_PROP = "vchaActiveInfo";
    private static final int VCHA_CAPABILITY_CACHE_DURATION = 900000;
    private static final String VCHA_CAPABILITY_SESSION_DATA_PREFIX = "vchaCapabilityCache";
    private final VapiConnectionManager _apiGwBasedConnectionManager;
    private final DataServiceExtensionRegistry _extensionRegistry;

    public VchaPropertyProviderAdapter(VapiConnectionManager apiGwBasedConnectionManager, DataServiceExtensionRegistry dataServiceExtensionRegistry) {
        this._apiGwBasedConnectionManager = (VapiConnectionManager)Preconditions.checkNotNull((Object)apiGwBasedConnectionManager, (Object)"apiGwBasedConnectionManager is found null");
        this._extensionRegistry = (DataServiceExtensionRegistry)Preconditions.checkNotNull((Object)dataServiceExtensionRegistry, (Object)"dataServiceExtensionRegistry is found null");
    }

    public void init() {
        this._extensionRegistry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
    }

    public void tearDown() {
        this._extensionRegistry.unregisterDataAdapter((PropertyProviderAdapter)this);
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        Validate.notNull((Object)propertyRequest);
        Object[] vcObjects = propertyRequest.objects;
        PropertySpec[] properties = propertyRequest.properties;
        if (vcObjects == null || vcObjects.length == 0 || properties == null || properties.length == 0) {
            return null;
        }
        if (vcObjects.length > 1) {
            throw new IllegalArgumentException("Call this property provider with only one ManagedObjectRef at a time. Properties for multiple objects at one time are not supported!");
        }
        ManagedObjectReference vcMoRef = (ManagedObjectReference)vcObjects[0];
        ArrayList<PropertyValue> cachedPropValues = this.getCachedProperties(vcMoRef, properties);
        if (cachedPropValues != null) {
            ResultSet result = this.createResultSet(vcMoRef, cachedPropValues, null);
            return result;
        }
        HashMap<String, AsyncCallbackFuture> futuresByPropNames = new HashMap<String, AsyncCallbackFuture>();
        ArrayList<Exception> faults = new ArrayList<Exception>();
        this.getProperties(vcMoRef.getServerGuid(), properties, futuresByPropNames, faults);
        ArrayList<PropertyValue> allPropValues = this.generatePropertyValues(vcMoRef, futuresByPropNames, faults);
        ResultSet result = this.createResultSet(vcMoRef, allPropValues, faults);
        return result;
    }

    private ArrayList<PropertyValue> getCachedProperties(ManagedObjectReference vcMoRef, PropertySpec[] properties) {
        boolean freshValuesToBeFetched = this.checkIfBackendNeedsToBeQueried(properties);
        if (freshValuesToBeFetched) {
            return null;
        }
        CapabilitiesTypes.Info cachedVchaCapability = this.getCachedVchaCapability(vcMoRef);
        if (cachedVchaCapability == null) {
            return null;
        }
        ArrayList<PropertyValue> propValues = new ArrayList<PropertyValue>();
        for (PropertySpec propertySpec : properties) {
            for (String prop : propertySpec.propertyNames) {
                PropertyValue propertyValue = new PropertyValue();
                propertyValue.resourceObject = vcMoRef;
                propertyValue.propertyName = prop;
                if (VCHA_CAPABILITIES_PROP.equals(prop)) {
                    propertyValue.value = cachedVchaCapability;
                }
                propValues.add(propertyValue);
            }
        }
        return propValues;
    }

    private boolean checkIfBackendNeedsToBeQueried(PropertySpec[] properties) {
        for (PropertySpec propertySpec : properties) {
            for (String property : propertySpec.propertyNames) {
                if (!VCHA_CAPABILITIES_PROP.equals(property)) {
                    return true;
                }
                Object fetchCached = this.getValueFromParamSpec(propertySpec, VCHA_CAPABILITIES_PROP);
                if (fetchCached == null || ((Boolean)fetchCached).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    private Object getValueFromParamSpec(PropertySpec propertySpec, String propertyName) {
        if (propertySpec.parameters != null && propertyName != null) {
            for (ParameterSpec paramSpec : propertySpec.parameters) {
                if (!propertyName.equals(paramSpec.propertyName)) continue;
                return paramSpec.parameter;
            }
        }
        return null;
    }

    private CapabilitiesTypes.Info getCachedVchaCapability(ManagedObjectReference vcMoRef) {
        String cacheKey = VCHA_CAPABILITY_SESSION_DATA_PREFIX + vcMoRef.getServerGuid();
        return (CapabilitiesTypes.Info)SessionUtil.getData((String)cacheKey);
    }

    private void saveVchaCapability(ManagedObjectReference vcMoRef, CapabilitiesTypes.Info capabilityInfo) {
        String cacheKey = VCHA_CAPABILITY_SESSION_DATA_PREFIX + vcMoRef.getServerGuid();
        SessionUtil.setExpirableData((String)cacheKey, (Object)capabilityInfo, (int)900000);
    }

    private boolean calculateIsVchaAvailable(LicenseTypes.Info info) {
        return info != null && info.getIsAvailable();
    }

    private ArrayList<PropertyValue> generatePropertyValues(ManagedObjectReference vcMoRef, Map<String, AsyncCallbackFuture> futuresByPropNames, ArrayList<Exception> faults) {
        ArrayList<PropertyValue> allPropValues = new ArrayList<PropertyValue>(futuresByPropNames.size());
        for (Map.Entry<String, AsyncCallbackFuture> asyncFutureByPropNames : futuresByPropNames.entrySet()) {
            try {
                LicenseTypes.Info info;
                PropertyValue propertyValue = new PropertyValue();
                propertyValue.resourceObject = vcMoRef;
                propertyValue.propertyName = asyncFutureByPropNames.getKey();
                if (IS_VCHA_AVAILABLE_PROP.equals(propertyValue.propertyName)) {
                    info = (LicenseTypes.Info)asyncFutureByPropNames.getValue().get();
                    propertyValue.value = this.calculateIsVchaAvailable(info);
                } else if (VCHA_CAPABILITIES_PROP.equals(propertyValue.propertyName)) {
                    info = (CapabilitiesTypes.Info)asyncFutureByPropNames.getValue().get();
                    propertyValue.value = info;
                    this.saveVchaCapability(vcMoRef, (CapabilitiesTypes.Info)info);
                } else {
                    propertyValue.value = asyncFutureByPropNames.getValue().get();
                }
                allPropValues.add(propertyValue);
            }
            catch (Exception e) {
                _logger.error((Object)("Exception thrown while retrieving vcha properties" + e));
                faults.add((Exception)MixedUtil.getMethodFault((Throwable)e));
            }
        }
        return allPropValues;
    }

    private void getProperties(String vcServerGuid, PropertySpec[] properties, Map<String, AsyncCallbackFuture> futuresByProperty, ArrayList<Exception> faults) {
        for (PropertySpec propertySpec : properties) {
            for (String property : propertySpec.propertyNames) {
                try {
                    AsyncCallbackFuture future = this.getFutureForProperty(property, vcServerGuid, propertySpec);
                    if (future == null) continue;
                    futuresByProperty.put(property, future);
                }
                catch (Exception ex) {
                    _logger.error((Object)String.format("Connection to VCHA vapi service for vcenter '%s' failed.", vcServerGuid), (Throwable)ex);
                    faults.add((Exception)MixedUtil.getMethodFault((Throwable)ex));
                }
            }
        }
    }

    private AsyncCallbackFuture getFutureForProperty(String property, String vcServerGuid, PropertySpec propertySpec) {
        InvocationConfig invConfig = VapiUtil.newInvocationConfig((String)vcServerGuid);
        switch (property) {
            case "vchaMode": {
                AsyncCallbackFuture futureClusterMode = new AsyncCallbackFuture();
                ((Mode)this._apiGwBasedConnectionManager.createServiceStub(Mode.class)).get((AsyncCallback)futureClusterMode, invConfig);
                return futureClusterMode;
            }
            case "vchaClusterConfig": {
                AsyncCallbackFuture futureInfo = new AsyncCallbackFuture();
                ((Cluster)this._apiGwBasedConnectionManager.createServiceStub(Cluster.class)).get(null, Boolean.valueOf(true), (AsyncCallback)futureInfo, invConfig);
                return futureInfo;
            }
            case "vchaClusterPlacementInfo": {
                AsyncCallbackFuture futurePlacementInfo = new AsyncCallbackFuture();
                CredentialsSpec credentialSpec = (CredentialsSpec)this.getValueFromParamSpec(propertySpec, VCHA_CLUSTER_PLACEMENT_INFO_PROP);
                ((Cluster)this._apiGwBasedConnectionManager.createServiceStub(Cluster.class)).get(credentialSpec, Boolean.valueOf(false), (AsyncCallback)futurePlacementInfo, invConfig);
                return futurePlacementInfo;
            }
            case "vchaCapability": {
                AsyncCallbackFuture futureCapability = new AsyncCallbackFuture();
                ((Capabilities)this._apiGwBasedConnectionManager.createServiceStub(Capabilities.class)).get((AsyncCallback)futureCapability, invConfig);
                return futureCapability;
            }
            case "isVchaAvailable": {
                AsyncCallbackFuture futureLicense = new AsyncCallbackFuture();
                ((License)this._apiGwBasedConnectionManager.createServiceStub(License.class)).get((AsyncCallback)futureLicense, invConfig);
                return futureLicense;
            }
            case "vchaDeployment": {
                AsyncCallbackFuture futureDeploymentType = new AsyncCallbackFuture();
                ((DeploymentType)this._apiGwBasedConnectionManager.createServiceStub(DeploymentType.class)).get((AsyncCallback)futureDeploymentType, invConfig);
                return futureDeploymentType;
            }
            case "vchaOperations": {
                AsyncCallbackFuture futureOperations = new AsyncCallbackFuture();
                ((Operations)this._apiGwBasedConnectionManager.createServiceStub(Operations.class)).get((AsyncCallback)futureOperations, invConfig);
                return futureOperations;
            }
            case "vchaActiveInfo": {
                AsyncCallbackFuture futureActiveInfo = new AsyncCallbackFuture();
                CredentialsSpec credentialSpec1 = (CredentialsSpec)this.getValueFromParamSpec(propertySpec, VCHA_ACTIVE_INFO_PROP);
                ((Active)this._apiGwBasedConnectionManager.createServiceStub(Active.class)).get(credentialSpec1, Boolean.valueOf(false), (AsyncCallback)futureActiveInfo, invConfig);
                return futureActiveInfo;
            }
        }
        return null;
    }

    private ResultSet createResultSet(ManagedObjectReference vcMoRef, ArrayList<PropertyValue> propertyValues, ArrayList<Exception> faults) {
        ResultItem resultItem = new ResultItem();
        resultItem.resourceObject = vcMoRef;
        resultItem.properties = propertyValues.toArray(new PropertyValue[0]);
        ResultSet result = new ResultSet();
        result.items = new ResultItem[]{resultItem};
        if (faults != null && !faults.isEmpty()) {
            result.error = faults.size() == 1 ? faults.get(0) : new CompositeException(faults);
        }
        return result;
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo ti = new TypeInfo();
        ti.type = Folder.class.getSimpleName();
        ti.properties = new String[]{VCHA_MODE_PROP, VCHA_CLUSTER_CONFIG_PROP, VCHA_CAPABILITIES_PROP, VCHA_DEPLOYMENT_PROP, VCHA_CLUSTER_PLACEMENT_INFO_PROP, VCHA_OPERATIONS_PROP, IS_VCHA_AVAILABLE_PROP, VCHA_ACTIVE_INFO_PROP};
        return new TypeInfo[]{ti};
    }
}

