/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vm.impl;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.security.AuthorizationUtil;
import java.util.ArrayList;
import java.util.List;

public class CustomizationSpecsHelper {
    private static final String PROP_GRANTED_PRIV = "grantedPrivileges";
    private static final String CUSTOMIZE_PRIV = "VirtualMachine.Provisioning.Customize";
    private static final String READ_SPEC_PRIV = "VirtualMachine.Provisioning.ReadCustSpecs";
    private static final String MODIFY_SPEC_PRIV = "VirtualMachine.Provisioning.ModifyCustSpecs";
    private QueryServiceFactory _queryServiceFactory;

    public CustomizationSpecsHelper(QueryServiceFactory queryServiceFactory) {
        this._queryServiceFactory = queryServiceFactory;
    }

    public boolean isCustomizeSpecPrivilegeGrantedOnVm(ManagedObjectReference vmRef) {
        String[] vmGrantedPrivs = (String[])this.fetchPropertiesForMor(vmRef, PROP_GRANTED_PRIV).get(0);
        return AuthorizationUtil.isPrivilegeGranted((String[])new String[]{CUSTOMIZE_PRIV}, (String[])vmGrantedPrivs);
    }

    public List<Boolean> areCustSpecsPrivilegesGrantedOnVcenter(ManagedObjectReference vcRef) {
        String[] vcGrantedPrivs = (String[])this.fetchPropertiesForMor(vcRef, PROP_GRANTED_PRIV).get(0);
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        result.add(AuthorizationUtil.isPrivilegeGranted((String[])new String[]{READ_SPEC_PRIV}, (String[])vcGrantedPrivs));
        result.add(AuthorizationUtil.isPrivilegeGranted((String[])new String[]{MODIFY_SPEC_PRIV}, (String[])vcGrantedPrivs));
        return result;
    }

    public List<Object> fetchVmProperties(ManagedObjectReference vmRef, String ... properties) {
        return this.fetchPropertiesForMor(vmRef, properties);
    }

    private List<Object> fetchPropertiesForMor(ManagedObjectReference mor, String ... properties) {
        QueryService queryService = this._queryServiceFactory.getQueryService();
        ResultSet propertiesResult = queryService.select(properties).from(new String[]{mor.getType()}).where("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)mor).fetch();
        return ((ResourceItem)propertiesResult.getItems().get(0)).getPropertyValues();
    }
}

