/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vm.impl;

import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.CustomizationSpecInfo;
import com.vmware.vim.binding.vim.CustomizationSpecManager;
import com.vmware.vim.binding.vim.fault.MissingLinuxCustResources;
import com.vmware.vim.binding.vim.fault.MissingWindowsCustResources;
import com.vmware.vim.binding.vim.fault.UncustomizableGuest;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.core.model.exception.CompositeException;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.h5.vm.data.CustomizeGosSpecData;
import com.vmware.vsphere.client.h5.vm.impl.CustomizationSpecsHelper;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmCustomizationSpecsPropertyProviderAdapter
implements PropertyProviderAdapter {
    private static final Log _logger = LogFactory.getLog(VmCustomizationSpecsPropertyProviderAdapter.class);
    private static final String CUSTOMIZE_GOS_SPEC_DATA = "customizeGosSpecData";
    private static final String PROP_GUEST_ID = "VirtualMachine/config/guestId";
    private static final String PROP_GUEST_FULL_NAME = "VirtualMachine/config/guestFullName";
    private static final String PROP_PENDING_CUSOMITZATION = "VirtualMachine/config/tools/pendingCustomization";
    private static final String WIN_OS_PREFIX = "win";
    private static final String GOS_TYPE_WINDOWS = "Windows";
    private static final String GOS_TYPE_LINUX = "Linux";
    private CustomizationSpecsHelper _customizationSpecsHelper;

    public VmCustomizationSpecsPropertyProviderAdapter(DataServiceExtensionRegistry registry, QueryServiceFactory queryServiceFactory) {
        Validate.notNull((Object)registry);
        registry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
        this._customizationSpecsHelper = new CustomizationSpecsHelper(queryServiceFactory);
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo ti = new TypeInfo();
        ti.type = "*";
        ti.properties = new String[]{CUSTOMIZE_GOS_SPEC_DATA};
        return new TypeInfo[]{ti};
    }

    public ResultSet getProperties(PropertyRequestSpec propRequestSpec) {
        Validate.notNull((Object)propRequestSpec);
        Object[] objects = propRequestSpec.objects;
        PropertySpec[] properties = propRequestSpec.properties;
        if (objects == null || objects.length == 0 || properties == null || properties.length == 0) {
            return null;
        }
        ResultSet result = new ResultSet();
        ArrayList<ResultItem> resultItems = new ArrayList<ResultItem>();
        ArrayList<MethodFault> faults = new ArrayList<MethodFault>();
        for (Object obj : objects) {
            try {
                PropertySpec propSpec = this.getPropertyRequested(CUSTOMIZE_GOS_SPEC_DATA, properties);
                if (propSpec == null) continue;
                CustomizeGosSpecData customizationSpecData = null;
                if (obj instanceof ManagedObjectReference) {
                    ManagedObjectReference vmRef = (ManagedObjectReference)obj;
                    ManagedObjectReference vcRef = (ManagedObjectReference)propSpec.parameters[0].parameter;
                    customizationSpecData = this.getCustomizeGosSpecData(vmRef, vcRef);
                }
                if (obj instanceof URI) {
                    ManagedObjectReference vcRef = null;
                    String gosId = null;
                    for (ParameterSpec property : propSpec.parameters) {
                        if (property.parameter instanceof ManagedObjectReference) {
                            vcRef = (ManagedObjectReference)property.parameter;
                        }
                        if (!(property.parameter instanceof String)) continue;
                        gosId = (String)property.parameter;
                    }
                    customizationSpecData = this.getCustomizeGosSpecData(vcRef, gosId);
                }
                ResultItem ri = this.createResultItem(obj, customizationSpecData, CUSTOMIZE_GOS_SPEC_DATA);
                resultItems.add(ri);
            }
            catch (Exception e) {
                faults.add(MixedUtil.getMethodFault((Throwable)e));
            }
        }
        if (!faults.isEmpty()) {
            result.error = new CompositeException(faults);
        }
        result.items = resultItems.toArray(new ResultItem[0]);
        return result;
    }

    private PropertySpec getPropertyRequested(String property, PropertySpec[] properties) {
        for (PropertySpec pSpec : properties) {
            for (String p : pSpec.propertyNames) {
                if (!property.equals(p)) continue;
                return pSpec;
            }
        }
        return null;
    }

    private CustomizeGosSpecData getCustomizeGosSpecData(ManagedObjectReference vmRef, ManagedObjectReference vcRef) throws Exception {
        CustomizeGosSpecData data = new CustomizeGosSpecData();
        data.vmCustomizePrivGranted = this._customizationSpecsHelper.isCustomizeSpecPrivilegeGrantedOnVm(vmRef);
        if (!data.vmCustomizePrivGranted) {
            _logger.info((Object)("Customize spec privileges are not granted on VM: " + vmRef));
            return data;
        }
        List<Boolean> areCustSpecsPrivilegesGrantedOnVcenter = this._customizationSpecsHelper.areCustSpecsPrivilegesGrantedOnVcenter(vcRef);
        data.vcReadSpecPrivGranted = areCustSpecsPrivilegesGrantedOnVcenter.get(0);
        if (!data.vcReadSpecPrivGranted) {
            _logger.info((Object)("Read customization specifications privilege is not granted on VC: " + vcRef));
            return data;
        }
        data.vcModifySpecPrivGranted = areCustSpecsPrivilegesGrantedOnVcenter.get(1);
        List<Object> vmProperties = this._customizationSpecsHelper.fetchVmProperties(vmRef, PROP_GUEST_ID, PROP_GUEST_FULL_NAME, PROP_PENDING_CUSOMITZATION);
        String guestId = (String)vmProperties.get(0);
        String guestFullName = (String)vmProperties.get(1);
        boolean pendingCustomization = StringUtils.isNotEmpty((CharSequence)((String)vmProperties.get(2)));
        data.guestId = guestId;
        data.guestFullName = guestFullName;
        data.pendingCustomization = pendingCustomization;
        if (pendingCustomization) {
            return data;
        }
        this.retrieveGuestOsData(vcRef, guestId, data);
        return data;
    }

    private CustomizeGosSpecData getCustomizeGosSpecData(ManagedObjectReference vcRef, String guestId) throws Exception {
        CustomizeGosSpecData data = new CustomizeGosSpecData();
        data.vmCustomizePrivGranted = true;
        List<Boolean> areCustSpecsPrivilegesGrantedOnVcenter = this._customizationSpecsHelper.areCustSpecsPrivilegesGrantedOnVcenter(vcRef);
        data.vcReadSpecPrivGranted = areCustSpecsPrivilegesGrantedOnVcenter.get(0);
        if (!data.vcReadSpecPrivGranted) {
            _logger.info((Object)("Read customization specifications privilege is not granted on VC: " + vcRef));
            return data;
        }
        data.vcModifySpecPrivGranted = areCustSpecsPrivilegesGrantedOnVcenter.get(1);
        this.retrieveGuestOsData(vcRef, guestId, data);
        return data;
    }

    private void retrieveGuestOsData(ManagedObjectReference vcRef, String guestId, CustomizeGosSpecData data) throws Exception {
        CustomizationSpecInfo[] filteredSpecs = null;
        VcService service = VimSessionUtil.getService((String)vcRef.getServerGuid());
        CustomizationSpecManager manager = (CustomizationSpecManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)service.getServiceInstanceContent().customizationSpecManager);
        try {
            manager.checkResources(guestId);
            CustomizationSpecInfo[] specs = manager.getInfo();
            if (specs != null) {
                String sourceVmGuestOsType;
                data.guestType = sourceVmGuestOsType = guestId.startsWith(WIN_OS_PREFIX) ? GOS_TYPE_WINDOWS : GOS_TYPE_LINUX;
                filteredSpecs = this.filterSpecs(specs, sourceVmGuestOsType);
            }
            data.compatibility = CustomizeGosSpecData.Compatibility.CUSTOMIZATION_RESOURCES_VALID;
        }
        catch (MissingWindowsCustResources e) {
            _logger.debug((Object)e.getMessage(), (Throwable)e);
            data.compatibility = CustomizeGosSpecData.Compatibility.MISSING_WINDOWS_CUSTOMIZATION;
        }
        catch (MissingLinuxCustResources e) {
            _logger.debug((Object)e.getMessage(), (Throwable)e);
            data.compatibility = CustomizeGosSpecData.Compatibility.MISSING_LINUX_CUSTOMIZATION;
        }
        catch (UncustomizableGuest e) {
            _logger.debug((Object)e.getMessage(), (Throwable)e);
            data.compatibility = CustomizeGosSpecData.Compatibility.UNCUSTOMIZABLE_GUEST;
        }
        data.relevantSpecs = filteredSpecs;
    }

    private CustomizationSpecInfo[] filterSpecs(CustomizationSpecInfo[] specs, String typeToFilterBy) {
        ArrayList<CustomizationSpecInfo> list = new ArrayList<CustomizationSpecInfo>();
        for (CustomizationSpecInfo spec : specs) {
            if (!typeToFilterBy.equals(spec.type)) continue;
            list.add(spec);
        }
        return list.toArray(new CustomizationSpecInfo[0]);
    }

    private ResultItem createResultItem(Object obj, Object objValue, String propertyName) {
        PropertyValue pv = new PropertyValue();
        pv.resourceObject = obj;
        pv.propertyName = propertyName;
        pv.value = objValue;
        ResultItem ri = new ResultItem();
        ri.resourceObject = obj;
        ri.properties = new PropertyValue[]{pv};
        return ri;
    }
}

