/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vm.impl;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.vm.QuestionInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.type;

public class VmIssuePropertyProvider
implements PropertyProviderBean {
    private final QueryServiceFactory _queryServiceFactory;
    private static final String VM_QUESTION_PROP_NAME = "runtime/question";
    private static final String VM_QUESTION_FIRST_MESSAGE_ID_PROP_NAME = "vmQuestionId";

    public VmIssuePropertyProvider(QueryServiceFactory queryServiceFactory) {
        this._queryServiceFactory = queryServiceFactory;
    }

    @type(value="VirtualMachine")
    public int getOtherVmsCountWithSameQuestion(ManagedObjectReference vmRef) {
        QueryService queryService = this._queryServiceFactory.getQueryService();
        ResultSet vmQuestionResult = queryService.select(new String[]{VM_QUESTION_PROP_NAME}).from(new String[]{vmRef.getType()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)vmRef)}).fetch();
        QuestionInfo vmQuestion = (QuestionInfo)((ResourceItem)vmQuestionResult.getItems().get(0)).getPropertyValues().get(0);
        if (vmQuestion == null) {
            return 0;
        }
        String firstMessageId = vmQuestion.getMessage()[0].getId();
        ResultSet otherVmsResult = queryService.select(new String[]{"@modelKey"}).from(new String[]{vmRef.getType()}).where(new PropertyPredicate[]{new PropertyPredicate("@instanceUuid", PropertyPredicate.ComparisonOperator.EQUAL, (Object)vmRef.getServerGuid()), new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.NOT_EQUAL, (Object)vmRef), new PropertyPredicate(VM_QUESTION_FIRST_MESSAGE_ID_PROP_NAME, PropertyPredicate.ComparisonOperator.EQUAL, (Object)firstMessageId)}).fetch();
        int result = otherVmsResult.getItems() == null ? 0 : otherVmsResult.getItems().size();
        return result;
    }
}

