/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vm.impl;

import com.vmware.vim.binding.pbm.profile.IofilterInfo;
import com.vmware.vim.binding.pbm.profile.Profile;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vsphere.client.h5.vm.model.VmStoragePageData;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public class VmStoragePagePropertyProvider
implements PropertyProviderBean {
    private DataService _dataService;
    private QuerySpecBuilder _querySpecBuilder;
    private static final String PROFILE_CONTENT_PROPERTY = "profileContent";
    private static final String IOFILTER_INFO_PROPERTY = "iofilterInfo";
    private static final String PROFILES_QUERY_SPEC_NAME = ".profilesSpec";

    public VmStoragePagePropertyProvider(DataService dataService, QuerySpecBuilder querySpecBuilder) {
        this._dataService = dataService;
        this._querySpecBuilder = querySpecBuilder;
    }

    @type(value="Folder")
    public VmStoragePageData getVmStoragePageData(ManagedObjectReference vcRef) {
        VmStoragePageData data = new VmStoragePageData();
        Constraint constraint = this._querySpecBuilder.createConstraintForRelationship((Object)vcRef, "pbmProfiles", "PbmRequirementStorageProfile");
        QuerySpec profilesSpec = this._querySpecBuilder.buildQuerySpec(constraint, new String[]{PROFILE_CONTENT_PROPERTY, IOFILTER_INFO_PROPERTY});
        profilesSpec.name = this.getClass().getSimpleName() + PROFILES_QUERY_SPEC_NAME;
        RequestSpec rs = new RequestSpec();
        rs.querySpec = new QuerySpec[]{profilesSpec};
        Response response = this._dataService.getData(rs);
        if (response == null || response.resultSet == null) {
            return data;
        }
        this.retrieveProfilesData(response, data);
        return data;
    }

    private void retrieveProfilesData(Response response, VmStoragePageData data) {
        data.profileStoragePageData = new HashMap();
        ResultSet resultSet = this.findSpec(PROFILES_QUERY_SPEC_NAME, response);
        if (resultSet == null) {
            return;
        }
        if (resultSet.error != null) {
            data.profileError = resultSet.error.getMessage();
            return;
        }
        if (!ArrayUtils.isEmpty((Object[])resultSet.items)) {
            for (ResultItem resultItem : resultSet.items) {
                Map<String, Object> properties = this.retrieveProperties(new String[]{PROFILE_CONTENT_PROPERTY, IOFILTER_INFO_PROPERTY}, resultItem.properties);
                if (properties == null) continue;
                VmStoragePageData.ProfileStoragePageData profileData = new VmStoragePageData.ProfileStoragePageData();
                profileData.profileContent = (Profile)properties.get(PROFILE_CONTENT_PROPERTY);
                profileData.iofilterInfo = (IofilterInfo[])properties.get(IOFILTER_INFO_PROPERTY);
                data.profileStoragePageData.put(((URI)resultItem.resourceObject).toString(), profileData);
            }
        }
    }

    private ResultSet findSpec(String queryName, Response response) {
        for (ResultSet rs : response.resultSet) {
            if (rs.queryName == null || !rs.queryName.endsWith(queryName)) continue;
            return rs;
        }
        return null;
    }

    private Map<String, Object> retrieveProperties(String[] properties, PropertyValue[] resultProperties) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (ArrayUtils.isEmpty((Object[])resultProperties)) {
            return null;
        }
        for (PropertyValue resultProperty : resultProperties) {
            for (String property : properties) {
                if (!resultProperty.propertyName.equals(property)) continue;
                result.put(property, resultProperty.value);
            }
        }
        return result;
    }
}

