/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vm.impl;

import com.vmware.vim.binding.vim.vm.VirtualHardware;
import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vim.vm.device.VirtualTPM;
import com.vmware.vim.binding.vmodl.Binary;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.util.security.CertificateInfo;
import com.vmware.vsphere.client.commonservice.util.CertificateExtendedUtil;
import com.vmware.vsphere.client.commonservice.util.CertificateSigningRequestInfo;
import com.vmware.vsphere.client.commonservice.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmTpmProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(VmTpmProvider.class);
    public static final String CONFIG_HARDWARE_PROP = "config.hardware";
    private QueryExecutor _queryExecutor;

    public void setQueryExecutor(QueryExecutor queryExecutor) {
        this._queryExecutor = queryExecutor;
    }

    @type(value="VirtualMachine")
    public boolean getTpmEnabled(ManagedObjectReference vmRef) throws Exception {
        return this.getVirtualTpmDevice(vmRef) != null;
    }

    @type(value="VirtualMachine")
    public CertificatesCSRsInfo getTpmCertificates(ManagedObjectReference vmRef) throws Exception {
        VirtualTPM device = this.getVirtualTpmDevice(vmRef);
        ArrayList<CertificateInfo> certInfos = new ArrayList<CertificateInfo>();
        ArrayList<CertificateSigningRequestInfo> csrInfos = new ArrayList<CertificateSigningRequestInfo>();
        if (device != null) {
            Binary[] certs;
            Binary[] csrs = device.endorsementKeyCertificateSigningRequest;
            if (csrs != null && csrs.length > 0) {
                int index = 0;
                for (Binary csr : csrs) {
                    try {
                        CertificateSigningRequestInfo csrInfo = CertificateExtendedUtil.getCertificateSigningRequestInfo((byte[])csr.asArray());
                        csrInfos.add(csrInfo);
                    }
                    catch (Exception e) {
                        _logger.error((Object)("Error parsing vTPM CSR for : " + vmRef + ", at index: " + index + ", endorsementKeyCertificateSigningRequest data = " + Arrays.toString(csr.asArray())), (Throwable)e);
                    }
                    ++index;
                }
            }
            if ((certs = device.endorsementKeyCertificate) != null && certs.length > 0) {
                int index = 0;
                for (Binary cert : certs) {
                    try {
                        CertificateInfo certInfo = CertificateExtendedUtil.getCertificateInfo((byte[])cert.asArray());
                        certInfos.add(certInfo);
                    }
                    catch (Exception e) {
                        _logger.error((Object)("Error parsing vTPM certificate for : " + vmRef + ", at index: " + index + ", endorsementKeyCertificate data = " + Arrays.toString(cert.asArray())), (Throwable)e);
                    }
                    ++index;
                }
            }
        }
        return new CertificatesCSRsInfo(certInfos, csrInfos);
    }

    private VirtualTPM getVirtualTpmDevice(ManagedObjectReference vmRef) throws Exception {
        VirtualDevice[] devices;
        PropertyValue[] pvs = this._queryExecutor.getProperties((Object)vmRef, new String[]{CONFIG_HARDWARE_PROP});
        VirtualHardware hardwareResult = (VirtualHardware)Util.getProperty((PropertyValue[])pvs, (String)CONFIG_HARDWARE_PROP);
        if (hardwareResult == null) {
            _logger.error((Object)("null returned for config.hardware on VM " + vmRef));
            return null;
        }
        for (VirtualDevice device : devices = hardwareResult.getDevice()) {
            if (!(device instanceof VirtualTPM)) continue;
            return (VirtualTPM)device;
        }
        return null;
    }

    public class CertificatesCSRsInfo {
        public List<CertificateInfo> certificateInfos;
        public List<CertificateSigningRequestInfo> csrInfos;

        CertificatesCSRsInfo(List<CertificateInfo> certificateInfos, List<CertificateSigningRequestInfo> csrInfos) {
            this.certificateInfos = certificateInfos;
            this.csrInfos = csrInfos;
        }
    }
}

