/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vm.service;

import com.google.common.collect.Sets;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.h5.vm.model.storagelocator.AggregatedClusterData;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AggregatedClusterDataService {
    private static final Log logger = LogFactory.getLog(AggregatedClusterDataService.class);
    private static final String CLUSTER_PROP = "cluster";
    private static final String IS_VSAN_PMEM_ENABLED_PROP = "vsanPMemEnabled";
    private final QueryService queryService;

    public AggregatedClusterDataService(QueryServiceFactory queryServiceFactory) {
        this.queryService = queryServiceFactory.getQueryService();
    }

    public AggregatedClusterData queryAggregatedClusterData(ManagedObjectReference[] contextObjects) {
        AggregatedClusterData clusterData = new AggregatedClusterData();
        if (contextObjects == null || contextObjects.length == 0) {
            return clusterData;
        }
        try {
            ManagedObjectReference[] clusterRefs = this.getClusterRefs(contextObjects);
            this.populateClusterData(clusterData, clusterRefs);
        }
        catch (Exception e) {
            logger.warn((Object)String.format("Cannot compute '%s'.", AggregatedClusterData.class.getSimpleName()), (Throwable)e);
        }
        return clusterData;
    }

    private ManagedObjectReference[] getClusterRefs(ManagedObjectReference[] contextObjects) {
        ManagedObjectReference[] clusterRefs = contextObjects;
        if (!ManagedObjectUtil.isOfType((ManagedObjectReference)contextObjects[0], ClusterComputeResource.class)) {
            ResultSet resultSet = this.queryService.select(new String[]{CLUSTER_PROP}).from(new String[]{contextObjects[0].getType()}).where("@modelKey", PropertyPredicate.ComparisonOperator.IN, Arrays.asList(contextObjects)).fetch();
            clusterRefs = (ManagedObjectReference[])resultSet.getItems().stream().map(rsItem -> (ManagedObjectReference)rsItem.get(CLUSTER_PROP)).toArray(ManagedObjectReference[]::new);
        }
        return clusterRefs;
    }

    private void populateClusterData(AggregatedClusterData clusterData, ManagedObjectReference[] clusterRefs) {
        if (Arrays.stream(clusterRefs).noneMatch(Objects::isNull)) {
            if (Sets.newHashSet((Object[])clusterRefs).size() == 1) {
                clusterData.commonParentCluster = clusterRefs[0];
            }
            ResultSet resultSet = this.queryService.select(new String[]{IS_VSAN_PMEM_ENABLED_PROP}).from(new String[]{ClusterComputeResource.class.getSimpleName()}).where("@modelKey", PropertyPredicate.ComparisonOperator.IN, Arrays.asList(clusterRefs)).fetch();
            clusterData.isVsanPmemEnabled = resultSet.getItems().stream().allMatch(rsItem -> (Boolean)rsItem.get(IS_VSAN_PMEM_ENABLED_PROP));
        }
    }
}

