/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vm.service;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.cis.data.query.util.QueryBindingServiceFactory;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.h5.vm.model.storagelocator.VsanDatastoreAdditionalData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class VmStorageLocatorService {
    private final QueryBindingService _queryBindingService;

    public VmStorageLocatorService(QueryBindingServiceFactory queryBindingServiceFactory) {
        this._queryBindingService = queryBindingServiceFactory.getQueryBindingService();
    }

    public Set<ManagedObjectReference> calculateRemoteVsanDatastores(ManagedObjectReference clusterComputeResource, Collection<Object> vsanDatastoresIds) {
        ArrayList<ManagedObjectReference> dsRefs = new ArrayList<ManagedObjectReference>();
        for (Object vsanDatastore : vsanDatastoresIds) {
            dsRefs.add(ManagedObjectUtil.stringToMoref((String)vsanDatastore.toString()));
        }
        Collection result = this._queryBindingService.prepare(VsanDatastoreAdditionalData.class).fetch(dsRefs);
        HashSet<ManagedObjectReference> remoteVsanDatastores = new HashSet<ManagedObjectReference>();
        block1: for (VsanDatastoreAdditionalData vsanDatastoreAdditionalData : result) {
            for (ManagedObjectReference clusterRef : vsanDatastoreAdditionalData.clusters) {
                if (clusterRef == null) continue;
                if (clusterRef.equals((Object)clusterComputeResource)) continue block1;
                remoteVsanDatastores.add((ManagedObjectReference)vsanDatastoreAdditionalData.provider);
                continue block1;
            }
        }
        return remoteVsanDatastores;
    }
}

