/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vm.service.migration;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.cis.data.query.util.QueryBindingServiceFactory;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.h5.vm.data.MigrateOrMoveValidationSpec;
import com.vmware.vsphere.client.h5.vm.model.MigrateOrMoveValidationData;
import com.vmware.vsphere.client.h5.vm.model.VmHostResourcePoolData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class MigrateOrMoveValidationService
implements MutationProvider {
    private static final String PROP_ANCESTOR_RP = "ancestorRp";
    private static final String PROP_RESOURCE_POOL = "resourcePool";
    public final QueryServiceFactory _queryServiceFactory;
    public final QueryBindingServiceFactory _queryBindingServiceFactory;
    private QueryBindingService _queryBindingService;
    private QueryService _queryService;

    public MigrateOrMoveValidationService(QueryServiceFactory queryServiceFactory, QueryBindingServiceFactory queryBindingServiceFactory) {
        this._queryServiceFactory = queryServiceFactory;
        this._queryBindingServiceFactory = queryBindingServiceFactory;
    }

    public ValidationResult validate(MigrateOrMoveValidationSpec moveSpec) {
        this._queryBindingService = this._queryBindingServiceFactory.getQueryBindingService();
        this._queryService = this._queryServiceFactory.getQueryService();
        ValidationResult result = new ValidationResult();
        MigrateOrMoveValidationData data = new MigrateOrMoveValidationData();
        data.migrateTarget = moveSpec.target;
        data.moveTarget = moveSpec.target;
        result.result = data;
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)moveSpec.target, HostSystem.class)) {
            result.result = this.migrateToHost(moveSpec);
            return result;
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)moveSpec.target, ClusterComputeResource.class)) {
            result.result = this.moveOrMigrateToCluster(moveSpec);
            return result;
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)moveSpec.target, ResourcePool.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)moveSpec.target, VirtualApp.class)) {
            result.result = this.migrateToResourcePool(moveSpec);
            return result;
        }
        return result;
    }

    private MigrateOrMoveValidationData moveOrMigrateToCluster(MigrateOrMoveValidationSpec moveSpec) {
        ManagedObjectReference targetResPool;
        MigrateOrMoveValidationData data = new MigrateOrMoveValidationData();
        data.migrateTarget = moveSpec.target;
        ResultSet vmAncestorRps = this._queryService.select(new String[]{"@modelKey", PROP_ANCESTOR_RP}).from(new String[]{VirtualMachine.class.getSimpleName()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.IN, Arrays.asList(moveSpec.entities))}).fetch();
        ResultSet targetRp = this._queryService.select(new String[]{"@modelKey", PROP_RESOURCE_POOL}).from(new String[]{moveSpec.target.getType()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)moveSpec.target)}).fetch();
        List items = vmAncestorRps.getItems();
        data.moveTarget = targetResPool = (ManagedObjectReference)((ResourceItem)targetRp.getItems().get(0)).get(PROP_RESOURCE_POOL);
        for (ResourceItem item : items) {
            ManagedObjectReference vmRef = (ManagedObjectReference)item.get("@modelKey");
            ManagedObjectReference[] vmRps = (ManagedObjectReference[])item.get(PROP_ANCESTOR_RP);
            if (this.findServerObjectRef(targetResPool, vmRps)) {
                data.moveVms.add(vmRef);
                continue;
            }
            data.migrateVms.add(vmRef);
        }
        return data;
    }

    private MigrateOrMoveValidationData migrateToResourcePool(MigrateOrMoveValidationSpec moveSpec) {
        MigrateOrMoveValidationData data = new MigrateOrMoveValidationData();
        data.migrateTarget = moveSpec.target;
        data.moveTarget = moveSpec.target;
        ResultSet vmAncestorRps = this._queryService.select(new String[]{"@modelKey", PROP_ANCESTOR_RP}).from(new String[]{VirtualMachine.class.getSimpleName()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.IN, Arrays.asList(moveSpec.entities))}).fetch();
        ResultSet targetRp = this._queryService.select(new String[]{"@modelKey", PROP_ANCESTOR_RP}).from(new String[]{moveSpec.target.getType()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)moveSpec.target)}).fetch();
        List items = vmAncestorRps.getItems();
        ManagedObjectReference[] targetResPools = (ManagedObjectReference[])((ResourceItem)targetRp.getItems().get(0)).get(PROP_ANCESTOR_RP);
        for (ResourceItem item : items) {
            boolean move = false;
            ManagedObjectReference vmRef = (ManagedObjectReference)item.get("@modelKey");
            ManagedObjectReference[] vmRps = (ManagedObjectReference[])item.get(PROP_ANCESTOR_RP);
            for (ManagedObjectReference targetResPool : targetResPools) {
                if (!this.findServerObjectRef(targetResPool, vmRps)) continue;
                move = true;
                data.moveVms.add(vmRef);
                break;
            }
            if (move) continue;
            data.migrateVms.add(vmRef);
        }
        return data;
    }

    private MigrateOrMoveValidationData migrateToHost(MigrateOrMoveValidationSpec moveSpec) {
        MigrateOrMoveValidationData data = new MigrateOrMoveValidationData();
        data.migrateTarget = moveSpec.target;
        ArrayList<ManagedObjectReference> list = new ArrayList<ManagedObjectReference>(Arrays.asList(moveSpec.entities));
        Collection hostInfo = this._queryBindingService.prepare(VmHostResourcePoolData.class).fetch(list);
        for (VmHostResourcePoolData vmData : hostInfo) {
            if (vmData.host.equals((Object)moveSpec.target)) {
                data.moveVms.add(vmData.vmRef);
                data.moveTarget = vmData.resourcePool;
                continue;
            }
            data.migrateVms.add(vmData.vmRef);
        }
        return data;
    }

    private boolean findServerObjectRef(ManagedObjectReference needle, ManagedObjectReference[] stack) {
        for (ManagedObjectReference ref : stack) {
            if (!ref.equals((Object)needle)) continue;
            return true;
        }
        return false;
    }
}

