/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vm.service.migration;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.cis.data.model.NestedQueryBinding;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.cis.data.model.Relationship;
import com.vmware.cis.data.query.util.QueryBindingServiceFactory;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.h5.vm.model.migration.ComputeResourceTreePageSpec;
import com.vmware.vsphere.client.h5.vm.model.migration.ComputeResourceValidationData;
import com.vmware.vsphere.client.h5.vm.util.VmPrivilegeUtil;
import com.vmware.vsphere.client.h5.vm.util.VmStringUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class VmMigrationComputeResourceValidationService
implements MutationProvider {
    private final QueryServiceFactory _queryServiceFactory;
    private final QueryBindingServiceFactory _queryBindingServiceFactory;
    private final VmPrivilegeUtil _vmPrivilegeUtil;
    private static final String TYPE_RESOURCE_POOL = "pool";
    private static final String TYPE_VAPP = "vapp";
    private static final String TYPE_HOST = "host";
    private static final String VALIDATION_ERROR_DOMAIN = "MigrationValidator.error.";
    private static final String TYPE_CLUSTER = "cluster";
    private static final String ENTER_MAINTENANCE_MODE_TASK = "EnterMaintenanceMode_Task";
    private static final String EXIT_MAINTENANCE_MODE_TASK = "ExitMaintenanceMode_Task";

    public VmMigrationComputeResourceValidationService(QueryServiceFactory queryServiceFactory, QueryBindingServiceFactory queryBindingServiceFactory, VmPrivilegeUtil vmPrivilegeUtil) {
        this._queryServiceFactory = queryServiceFactory;
        this._queryBindingServiceFactory = queryBindingServiceFactory;
        this._vmPrivilegeUtil = vmPrivilegeUtil;
    }

    public ValidationResult validate(ManagedObjectReference moRef, ComputeResourceTreePageSpec spec) {
        return this.validate(spec);
    }

    public ValidationResult validate(ComputeResourceTreePageSpec spec) {
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)spec.computeResource, HostSystem.class)) {
            return this.runHostCheck(spec);
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)spec.computeResource, ClusterComputeResource.class)) {
            return this.runClusterCheck(spec);
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)spec.computeResource, ResourcePool.class)) {
            return this.runResourcePoolCheck(spec);
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)spec.computeResource, VirtualApp.class)) {
            return this.runVappCheck(spec);
        }
        return new ValidationResult();
    }

    private ComputeResourceValidationData fetchAdditionalHostData(ComputeResourceTreePageSpec spec, HostCheckExtendedData hostData) {
        ComputeResourceValidationData data = new ComputeResourceValidationData();
        data.resourcePoolRef = hostData.resourcePool;
        if (spec.fetchClusterName) {
            QueryService qs = this._queryServiceFactory.getQueryService();
            ResultSet rs = qs.select(new String[]{"hostClusterName"}).from(new String[]{HostSystem.class.getSimpleName()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)spec.computeResource)}).fetch();
            data.clusterName = rs.getItems().size() > 0 ? ((ResourceItem)rs.getItems().get(0)).get("hostClusterName") : "";
        }
        return data;
    }

    private ValidationResult runHostCheck(ComputeResourceTreePageSpec spec) {
        QueryBindingService qbs = this._queryBindingServiceFactory.getQueryBindingService();
        HostCheckExtendedData data = (HostCheckExtendedData)qbs.prepare(HostCheckExtendedData.class).fetch((Object)spec.computeResource);
        ValidationResult result = this.checkAtLeastOneHostAvailable(new HostCheckExtendedData[]{data}, TYPE_HOST, spec.isXvcMigration);
        if (result.error != null) {
            return result;
        }
        Collection vmCheckData = qbs.prepare(VmCheckData.class).fetch(Arrays.asList(spec.vms));
        if (data != null) {
            boolean checkRpPermissions;
            boolean bl = checkRpPermissions = !VmMigrationComputeResourceValidationService.shouldKeepResourcePool(vmCheckData, data);
            if (checkRpPermissions) {
                result = this.checkPermissionAssignToPool(data.resourcePool, TYPE_HOST);
            }
            result.result = this.fetchAdditionalHostData(spec, data);
        }
        return result;
    }

    private ComputeResourceValidationData fetchAdditionalClusterData(ComputeResourceTreePageSpec spec, ClusterCheckData clusterCheckData) {
        ComputeResourceValidationData data = new ComputeResourceValidationData();
        data.resourcePoolRef = clusterCheckData.resourcePool;
        if (spec.isHotMigration) {
            return data;
        }
        if (clusterCheckData.drsEnabled && clusterCheckData.hostsData.length == 1) {
            data.hostName = clusterCheckData.hostsData[0].name;
        }
        if (spec.fetchClusterName) {
            QueryService qs = this._queryServiceFactory.getQueryService();
            ResultSet rs = qs.select(new String[]{"name"}).from(new String[]{ClusterComputeResource.class.getSimpleName()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)spec.computeResource)}).fetch();
            data.clusterName = rs.getItems().size() > 0 ? ((ResourceItem)rs.getItems().get(0)).get("name") : "";
        }
        return data;
    }

    private ValidationResult runClusterCheck(ComputeResourceTreePageSpec spec) {
        ValidationResult result = new ValidationResult();
        QueryBindingService qbs = this._queryBindingServiceFactory.getQueryBindingService();
        ClusterCheckData data = (ClusterCheckData)qbs.prepare(ClusterCheckData.class).fetch((Object)spec.computeResource);
        result = this.checkPermissionAssignToPool(data.resourcePool, TYPE_CLUSTER);
        if (result.error != null) {
            return result;
        }
        if (!data.drsEnabled) {
            result.error = new Exception(VmStringUtil.getString("MigrationWizard.resourceTreePage.error.non_drs_cluster"));
            return result;
        }
        result = this.checkAtLeastOneHostAvailable(data.hostsData, TYPE_CLUSTER, spec.isXvcMigration);
        if (result.error != null) {
            return result;
        }
        if (spec.runXdrsCheck.booleanValue()) {
            result = VmMigrationComputeResourceValidationService.checkInvalidXdrsMigration(spec.isHotMigration, spec.isBatchMigration, data.drsEnabled);
            if (result.error != null) {
                return result;
            }
        }
        result.result = this.fetchAdditionalClusterData(spec, data);
        return result;
    }

    private ValidationResult runResourcePoolCheck(ComputeResourceTreePageSpec spec) {
        ValidationResult result;
        boolean doCheckForAvailableHosts;
        QueryBindingService qbs = this._queryBindingServiceFactory.getQueryBindingService();
        ResourcePoolCheckData data = (ResourcePoolCheckData)qbs.prepare(ResourcePoolCheckData.class).fetch((Object)spec.computeResource);
        boolean isInCluster = ManagedObjectUtil.isOfType((ManagedObjectReference)data.getOwnerRef(), ClusterComputeResource.class);
        boolean bl = doCheckForAvailableHosts = !isInCluster || this._vmPrivilegeUtil.hasPrivileges(data.ownerRef, "System.Read");
        if (doCheckForAvailableHosts) {
            result = this.checkAtLeastOneHostAvailable(data.hostsData, TYPE_RESOURCE_POOL, spec.isXvcMigration);
            if (result.error != null) {
                return result;
            }
        }
        if (spec.runXdrsCheck.booleanValue()) {
            result = VmMigrationComputeResourceValidationService.checkInvalidXdrsMigration(spec.isHotMigration, spec.isBatchMigration, data.isInDrsEnabledCluster);
            if (result.error != null) {
                return result;
            }
        }
        result = this.checkPermissionAssignToPool(spec.computeResource, TYPE_RESOURCE_POOL);
        if (result.error != null) {
            return result;
        }
        result.result = this.fetchAdditionalResourcePoolData(spec, data);
        return result;
    }

    private ComputeResourceValidationData fetchAdditionalResourcePoolData(ComputeResourceTreePageSpec spec, IRpCheckData validationData) {
        ComputeResourceValidationData data = new ComputeResourceValidationData();
        data.resourcePoolRef = spec.computeResource;
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)validationData.getOwnerRef(), ClusterComputeResource.class)) {
            data.clusterName = validationData.getOwnerName();
            data.clusterRef = validationData.getOwnerRef();
        } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)validationData.getOwnerRef(), ComputeResource.class)) {
            QueryService qs = this._queryServiceFactory.getQueryService();
            ResultSet rs = qs.select(new String[]{TYPE_HOST}).from(new String[]{ComputeResource.class.getSimpleName()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)validationData.getOwnerRef())}).fetch();
            data.hostName = validationData.getOwnerName();
            ManagedObjectReference[] hosts = rs.getItems().size() > 0 ? ((ResourceItem)rs.getItems().get(0)).get(TYPE_HOST) : new ManagedObjectReference[]{};
            data.hostRef = hosts.length > 0 ? hosts[0] : null;
        }
        return data;
    }

    private ComputeResourceValidationData fetchAdditionalVAppData(ComputeResourceTreePageSpec spec, VAppCheckData data) {
        return this.fetchAdditionalResourcePoolData(spec, data);
    }

    private static ValidationResult checkInvalidXdrsMigration(boolean isHotMigration, boolean isBatchMigration, boolean isInDrsEnabledCluster) {
        ValidationResult result = new ValidationResult();
        if (isInDrsEnabledCluster && isHotMigration && isBatchMigration) {
            result.error = new Exception(VmStringUtil.getString("MigrationValidator.error.batch_xvmotion_host_required"));
            return result;
        }
        return result;
    }

    private ValidationResult runVappCheck(ComputeResourceTreePageSpec spec) {
        QueryBindingService qbs = this._queryBindingServiceFactory.getQueryBindingService();
        VAppCheckData data = (VAppCheckData)qbs.prepare(VAppCheckData.class).fetch((Object)spec.computeResource);
        ValidationResult result = this.checkAtLeastOneHostAvailable(data.hostsData, TYPE_VAPP, spec.isXvcMigration);
        if (result.error != null) {
            return result;
        }
        if (spec.runXdrsCheck.booleanValue()) {
            result = VmMigrationComputeResourceValidationService.checkInvalidXdrsMigration(spec.isHotMigration, spec.isBatchMigration, data.isInDrsEnabledCluster);
            if (result.error != null) {
                return result;
            }
        }
        result = this.checkPermissionAssignToPool(spec.computeResource, TYPE_VAPP);
        if (result.error != null) {
            return result;
        }
        result.result = this.fetchAdditionalVAppData(spec, data);
        return result;
    }

    private ValidationResult checkAtLeastOneHostAvailable(HostCheckData[] hostsData, String type2, boolean isXvcMigration) {
        ValidationResult result = new ValidationResult();
        if (ArrayUtils.isEmpty((Object[])hostsData)) {
            result.error = new Exception(VmStringUtil.getString(VALIDATION_ERROR_DOMAIN + type2 + ".emptyCluster"));
            return result;
        }
        for (HostCheckData singleHostData : (HostCheckData[])ArrayUtils.nullToEmpty((Object[])hostsData, HostCheckData[].class)) {
            result = VmMigrationComputeResourceValidationService.checkSingleHostAvailable(singleHostData, type2, isXvcMigration);
            if (result.error != null) continue;
            return result;
        }
        if (hostsData.length > 1 || TYPE_CLUSTER.equals(type2)) {
            result.error = new Exception(VmStringUtil.getString(VALIDATION_ERROR_DOMAIN + type2 + ".noValidHostsFound"));
            return result;
        }
        return result;
    }

    private static boolean shouldKeepResourcePool(Collection<VmCheckData> sourceVmData, HostCheckExtendedData targetHostData) {
        if (targetHostData == null || targetHostData.computeResource == null || sourceVmData.isEmpty()) {
            return false;
        }
        for (VmCheckData vmData : sourceVmData) {
            if (vmData.cluster != null && vmData.cluster.equals((Object)targetHostData.computeResource)) continue;
            return false;
        }
        return true;
    }

    private static ValidationResult checkSingleHostAvailable(HostCheckData singleHostData, String type2, boolean isXvcMigration) {
        boolean isHostXcvCapable;
        boolean isHostInTransition;
        boolean isReadPermissionOnHost;
        ValidationResult result = new ValidationResult();
        boolean bl = isReadPermissionOnHost = singleHostData.connectionState != null;
        if (!isReadPermissionOnHost) {
            return result;
        }
        boolean isHostConnected = HostSystem.ConnectionState.connected.equals((Object)singleHostData.connectionState);
        if (!isHostConnected) {
            result.error = new Exception(VmStringUtil.getString(VALIDATION_ERROR_DOMAIN + type2 + ".hostNotConnected"));
            return result;
        }
        boolean isHostInMaintenanceMode = singleHostData.inMaintenanceMode;
        if (isHostInMaintenanceMode) {
            result.error = new Exception(VmStringUtil.getString(VALIDATION_ERROR_DOMAIN + type2 + ".hostInMaintenance"));
            return result;
        }
        List<String> disabledMethods = Arrays.asList(singleHostData.disabledMethods);
        boolean bl2 = isHostInTransition = disabledMethods.contains(ENTER_MAINTENANCE_MODE_TASK) && disabledMethods.contains(EXIT_MAINTENANCE_MODE_TASK);
        if (isHostInTransition) {
            result.error = new Exception(VmStringUtil.getString(VALIDATION_ERROR_DOMAIN + type2 + ".hostInTransition"));
            return result;
        }
        if (isXvcMigration && !(isHostXcvCapable = VmMigrationComputeResourceValidationService.isEsx6OrLater(singleHostData))) {
            result.error = new Exception(VmStringUtil.getString(VALIDATION_ERROR_DOMAIN + type2 + ".hostNotXvcCapable"));
            return result;
        }
        return result;
    }

    private static boolean isEsx6OrLater(HostCheckData singleHostData) {
        String version = singleHostData.version;
        if (version == null) {
            return false;
        }
        if ("e.x.p".equals(version)) {
            return true;
        }
        String[] digits = version.split("\\.");
        return digits.length > 0 && Integer.parseInt(digits[0]) > 5;
    }

    private ValidationResult checkPermissionAssignToPool(ManagedObjectReference resourcePool, String type2) {
        ValidationResult result = new ValidationResult();
        try {
            boolean hasPrivileges = this._vmPrivilegeUtil.hasPrivileges(resourcePool, "Resource.AssignVMToPool");
            if (!hasPrivileges) {
                result.error = new Exception(VmStringUtil.getString(VALIDATION_ERROR_DOMAIN + type2 + ".noPermissionOnRP"));
            }
        }
        catch (Exception ex) {
            result.error = ex;
        }
        return result;
    }

    static interface IRpCheckData {
        public boolean getIsInDrsEnabledCluster();

        public ManagedObjectReference getOwnerRef();

        public String getOwnerName();

        public HostCheckData[] getHostCheckData();
    }

    @QueryBinding(value="VirtualApp")
    static class VAppCheckData
    implements IRpCheckData {
        @Relationship(value={"VirtualApp/owner"})
        @Property(value="AnyComputeResource/configurationEx/drsConfig/enabled")
        public boolean isInDrsEnabledCluster;
        @Relationship(value={"VirtualApp/owner"})
        @Property(value="AnyComputeResource/name")
        public String ownerName;
        @Property(value="VirtualApp/owner")
        public ManagedObjectReference ownerRef;
        @Relationship(value={"VirtualApp/allHosts"})
        @NestedQueryBinding
        public HostCheckData[] hostsData;

        VAppCheckData() {
        }

        @Override
        public boolean getIsInDrsEnabledCluster() {
            return this.isInDrsEnabledCluster;
        }

        @Override
        public String getOwnerName() {
            return this.ownerName;
        }

        @Override
        public ManagedObjectReference getOwnerRef() {
            return this.ownerRef;
        }

        @Override
        public HostCheckData[] getHostCheckData() {
            return this.hostsData;
        }
    }

    @QueryBinding(value="ResourcePool")
    static class ResourcePoolCheckData
    implements IRpCheckData {
        @Relationship(value={"ResourcePool/owner"})
        @Property(value="AnyComputeResource/configurationEx/drsConfig/enabled")
        public boolean isInDrsEnabledCluster;
        @Relationship(value={"ResourcePool/owner"})
        @Property(value="AnyComputeResource/name")
        public String ownerName;
        @Property(value="ResourcePool/owner")
        public ManagedObjectReference ownerRef;
        @Relationship(value={"ResourcePool/allHosts"})
        @NestedQueryBinding
        public HostCheckData[] hostsData;

        ResourcePoolCheckData() {
        }

        @Override
        public boolean getIsInDrsEnabledCluster() {
            return this.isInDrsEnabledCluster;
        }

        @Override
        public String getOwnerName() {
            return this.ownerName;
        }

        @Override
        public ManagedObjectReference getOwnerRef() {
            return this.ownerRef;
        }

        @Override
        public HostCheckData[] getHostCheckData() {
            return this.hostsData;
        }
    }

    @QueryBinding(value="ClusterComputeResource")
    static class ClusterCheckData {
        @Property(value="ClusterComputeResource/configurationEx/drsConfig/enabled")
        public boolean drsEnabled;
        @Property(value="ClusterComputeResource/resourcePool")
        public ManagedObjectReference resourcePool;
        @Relationship(value={"ClusterComputeResource/host"})
        @NestedQueryBinding
        public HostCheckData[] hostsData;

        ClusterCheckData() {
        }
    }

    @QueryBinding(value="VirtualMachine")
    public static class VmCheckData {
        @Property(value="VirtualMachine/cluster")
        public ManagedObjectReference cluster;
    }

    @QueryBinding(value="HostSystem")
    static class HostCheckExtendedData
    extends HostCheckData {
        @Relationship(value={"HostSystem/parent"})
        @Property(value="AnyComputeResource/resourcePool")
        public ManagedObjectReference resourcePool;
        @Property(value="HostSystem/parent")
        public ManagedObjectReference computeResource;

        HostCheckExtendedData() {
        }
    }

    @QueryBinding(value="HostSystem")
    static class HostCheckData {
        @Property(value="HostSystem/config/product/version")
        public String version;
        @Property(value="HostSystem/disabledMethod")
        public String[] disabledMethods;
        @Property(value="HostSystem/runtime/connectionState")
        public HostSystem.ConnectionState connectionState;
        @Property(value="HostSystem/runtime/inMaintenanceMode")
        public boolean inMaintenanceMode;
        @Property(value="HostSystem/name")
        public String name;

        HostCheckData() {
        }
    }
}

