/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vm.service.migration;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.vm.FaultToleranceConfigInfo;
import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vim.vm.device.VirtualEthernetCard;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vsphere.client.h5.vm.model.migration.VmMigrationFlowValidationData;
import com.vmware.vsphere.client.h5.vm.model.migration.VmMigrationFlowValidationSpec;
import com.vmware.vsphere.client.h5.vm.util.VmStringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;

public class VmMigrationValidationService
implements MutationProvider {
    private static final String PROP_VM_NAME = "name";
    private static final String PROP_VM_POWERSTATE = "powerState";
    private static final String PROP_VM_HOST = "host";
    private static final String PROP_VM_FTSTATE = "runtime/faultToleranceState";
    private static final String PROP_VM_FTINFO = "config/ftInfo";
    private static final String PROP_VM_DEVICES = "config/hardware/device";
    private static final String PROP_VM_MANAGED_BY_INFO = "managedByInfo";
    private static final String PROP_VM_VSAN_FAULT_DOMAIN_NAME = "vsanFaultDomainName";
    private QueryServiceFactory _queryServiceFactory;
    private ObjectReferenceService _objectReferenceService;

    public VmMigrationValidationService(QueryServiceFactory queryServiceFactory, ObjectReferenceService objectReferenceService) {
        this._queryServiceFactory = queryServiceFactory;
        this._objectReferenceService = objectReferenceService;
    }

    public ValidationResult validate(VmMigrationFlowValidationSpec spec) {
        ValidationResult validation = new ValidationResult();
        validation.result = new VmMigrationFlowValidationData();
        ArrayList<String> vmPropertiesList = new ArrayList<String>(Arrays.asList(PROP_VM_NAME, PROP_VM_POWERSTATE, PROP_VM_HOST, PROP_VM_FTSTATE, PROP_VM_FTINFO, PROP_VM_DEVICES, PROP_VM_MANAGED_BY_INFO));
        if (spec.vms.length == 1) {
            vmPropertiesList.add(PROP_VM_VSAN_FAULT_DOMAIN_NAME);
        }
        Map<String, Map<String, Object>> vmProperties = this.getVmProperties(spec.vms, vmPropertiesList.toArray(new String[vmPropertiesList.size()]));
        validation.result = this.validateMigration(spec.vms, vmProperties);
        return validation;
    }

    private VmMigrationFlowValidationData validateMigration(String[] vms, Map<String, Map<String, Object>> vmProperties) {
        VmMigrationFlowValidationData result = new VmMigrationFlowValidationData();
        result.hasNetworkAdapter = this.hasNetworkAdapter(vmProperties);
        this.stripVmDevicesProperties(vmProperties);
        if (vms.length == 1) {
            result.availableVms = vms;
            result.vmProperties = vmProperties;
        } else {
            ArrayList<String> ftVms = new ArrayList<String>();
            ArrayList<String> normalVms = new ArrayList<String>();
            for (String vm : vms) {
                if (this.isFtVm(vmProperties.get(vm))) {
                    ftVms.add(vm);
                    continue;
                }
                normalVms.add(vm);
            }
            ArrayList<String> errors = new ArrayList<String>();
            ArrayList<String> warnings = new ArrayList<String>();
            if (!this.checkVmPowerState(normalVms, vmProperties)) {
                errors.add(VmStringUtil.getString("VmMigrationValidationService.ErrorVmsSamePowerState"));
            }
            if (!ftVms.isEmpty() && ftVms.size() == vms.length) {
                errors.add(VmStringUtil.getString("VmMigrationValidationService.ErrorAllFTVms"));
            } else if (!ftVms.isEmpty()) {
                warnings.add(VmStringUtil.getString("VmMigrationValidationService.WarningFTVms"));
            }
            if (errors.isEmpty()) {
                result.availableVms = normalVms.toArray(new String[normalVms.size()]);
                result.vmProperties = vmProperties;
                for (String ftVm : ftVms) {
                    result.vmProperties.remove(ftVm);
                }
            }
            result.errors = errors.toArray(new String[errors.size()]);
            result.warnings = warnings.toArray(new String[warnings.size()]);
        }
        return result;
    }

    private boolean hasNetworkAdapter(Map<String, Map<String, Object>> vmProperties) {
        for (Map.Entry<String, Map<String, Object>> entry : vmProperties.entrySet()) {
            Map<String, Object> singleVmProperties = entry.getValue();
            Object[] devices = (VirtualDevice[])singleVmProperties.get(PROP_VM_DEVICES);
            for (VirtualDevice device : (VirtualDevice[])ArrayUtils.nullToEmpty((Object[])devices, VirtualDevice[].class)) {
                if (!(device instanceof VirtualEthernetCard)) continue;
                return true;
            }
        }
        return false;
    }

    private void stripVmDevicesProperties(Map<String, Map<String, Object>> vmProperties) {
        for (Map.Entry<String, Map<String, Object>> entry : vmProperties.entrySet()) {
            entry.getValue().remove(PROP_VM_DEVICES);
        }
    }

    private boolean checkVmPowerState(List<String> vms, Map<String, Map<String, Object>> vmProperties) {
        if (CollectionUtils.isEmpty(vms)) {
            return true;
        }
        VirtualMachine.PowerState firstVmState = (VirtualMachine.PowerState)vmProperties.get(vms.get(0)).get(PROP_VM_POWERSTATE);
        for (int index = 1; index < vms.size(); ++index) {
            VirtualMachine.PowerState currentVmState = (VirtualMachine.PowerState)vmProperties.get(vms.get(index)).get(PROP_VM_POWERSTATE);
            if (firstVmState == currentVmState) continue;
            return false;
        }
        return true;
    }

    private boolean isFtVm(Map<String, Object> vmProperties) {
        VirtualMachine.FaultToleranceState ftState = (VirtualMachine.FaultToleranceState)vmProperties.get(PROP_VM_FTSTATE);
        FaultToleranceConfigInfo ftInfo = (FaultToleranceConfigInfo)vmProperties.get(PROP_VM_FTINFO);
        return ftState != null && ftState != VirtualMachine.FaultToleranceState.notConfigured && ftInfo != null && ftInfo.role > 0;
    }

    private ManagedObjectReference[] toRef(String[] vmIds) {
        if (ArrayUtils.isEmpty((Object[])vmIds)) {
            return new ManagedObjectReference[0];
        }
        ManagedObjectReference[] result = new ManagedObjectReference[vmIds.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.toRef(vmIds[i]);
        }
        return result;
    }

    private ManagedObjectReference toRef(String vmId) {
        return (ManagedObjectReference)this._objectReferenceService.getReference(vmId, true);
    }

    private Map<String, Map<String, Object>> getVmProperties(String[] vmIds, String[] properties) {
        List<ManagedObjectReference> vms = Arrays.asList(this.toRef(vmIds));
        QueryService queryService = this._queryServiceFactory.getQueryService();
        ResultSet dsResult = queryService.select(properties).from(new String[]{"VirtualMachine"}).where("@modelKey", PropertyPredicate.ComparisonOperator.IN, vms).fetch();
        Map<String, Map<String, Object>> result = this.toPropertyMap(dsResult, properties);
        return result;
    }

    private Map<String, Map<String, Object>> toPropertyMap(ResultSet dsResult, String[] requestedProperties) {
        List resourceItems;
        List list = resourceItems = dsResult != null ? dsResult.getItems() : null;
        if (resourceItems == null || resourceItems.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Map<String, Object>> vmPropertyMap = new HashMap<String, Map<String, Object>>(resourceItems.size());
        for (ResourceItem item : resourceItems) {
            String vmId = this._objectReferenceService.getUid(item.getKey());
            if (!vmPropertyMap.containsKey(vmId)) {
                vmPropertyMap.put(vmId, new HashMap(requestedProperties.length));
            }
            Map propertyValues = (Map)vmPropertyMap.get(vmId);
            for (String property : requestedProperties) {
                propertyValues.put(property, item.get(property));
            }
        }
        return vmPropertyMap;
    }
}

