/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vm.util;

import com.vmware.vim.binding.pbm.profile.ProfileManager;
import com.vmware.vim.binding.vim.encryption.CryptoManagerKmip;
import com.vmware.vim.binding.vim.encryption.KeyProviderId;
import com.vmware.vim.binding.vim.encryption.KmipClusterInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.spbm.LocationLookupException;
import com.vmware.vsphere.client.spbm.PbmService;
import com.vmware.vsphere.client.spbm.PbmServiceFactory;
import com.vmware.vsphere.client.spbm.impl.PbmServiceUnableToConnectException;
import com.vmware.vsphere.client.spbm.util.PbmSessionUtil;

public class VmCryptoUtil {
    public static CryptoManagerKmip getCryptoManager(ManagedObjectReference moRef) throws Exception {
        String serverGuid = moRef.getServerGuid();
        VcService service = VimSessionUtil.getService((String)serverGuid);
        if (service == null) {
            throw new MethodFault("error.notRootFolder");
        }
        ManagedObjectReference cryptoManagerMOR = service.getServiceInstanceContent().cryptoManager;
        if (cryptoManagerMOR == null) {
            return null;
        }
        CryptoManagerKmip cryptoManagerKmip = (CryptoManagerKmip)ManagedObjectUtil.getManagedObject((ManagedObjectReference)cryptoManagerMOR);
        return cryptoManagerKmip;
    }

    public static boolean isTrustedKeyProvider(KeyProviderId keyProviderId, CryptoManagerKmip cryptoManager) {
        return KmipClusterInfo.KmsManagementType.trustAuthority.toString().equals(VmCryptoUtil.getKeyProviderManagementType(keyProviderId, cryptoManager));
    }

    public static String getKeyProviderManagementType(KeyProviderId keyProviderId, CryptoManagerKmip cryptoManager) {
        KmipClusterInfo[] keyProviders = cryptoManager.listKmsClusters(Boolean.valueOf(false), Integer.valueOf(-1), Integer.valueOf(-1));
        if (keyProviders == null) {
            return null;
        }
        for (KmipClusterInfo clusterInfo : keyProviders) {
            if (!clusterInfo.clusterId.id.equals(keyProviderId.id)) continue;
            return clusterInfo.managementType;
        }
        return null;
    }

    public static ProfileManager getProfileManager(ManagedObjectReference moRef, PbmServiceFactory pbmServiceFactory) throws LocationLookupException, PbmServiceUnableToConnectException {
        PbmService pbmService = PbmSessionUtil.getService((String)moRef.getServerGuid(), (PbmServiceFactory)pbmServiceFactory);
        return pbmService.getProfileManager();
    }
}

