/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.alarms.impl;

import com.vmware.opsmgmt.client.alarms.util.AlarmUtil;
import com.vmware.vim.binding.vim.alarm.AlarmState;
import com.vmware.vim.binding.vim.cdc.AlarmChange;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.vim.commons.messaging.AlarmChangeProcessor;
import com.vmware.vise.vim.commons.messaging.PartialUpdate;
import com.vmware.vise.vim.commons.messaging.PartialUpdateItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AlarmChangeProcessorImpl
implements AlarmChangeProcessor<AlarmState> {
    private static final Log _logger = LogFactory.getLog(AlarmChangeProcessorImpl.class);
    private static final Integer hasExpressionBitMask = 1;
    private static final String ALARM_PROPS_QUERY_NAME = "AlarmChangeProcessorImpl.alarmProps";
    private static final String ENTITY_NAMES_QUERY_NAME = "AlarmChangeProcessorImpl.entityNames";
    private final DataService dataService;
    private final QuerySpecBuilder querySpecBuilder;

    public AlarmChangeProcessorImpl(DataService dataService, QuerySpecBuilder querySpecBuilder) {
        this.dataService = dataService;
        this.querySpecBuilder = querySpecBuilder;
    }

    public PartialUpdate<AlarmState> process(Collection<AlarmChange> changes, String performanceLoggingPrefix) {
        PartialUpdate result = PartialUpdate.empty();
        List updates = result.getUpdates();
        HashMap<ManagedObjectReference, String> entityNames = new HashMap<ManagedObjectReference, String>();
        HashMap<ManagedObjectReference, MutablePair<String, Boolean>> alarmPropertiesMap = new HashMap<ManagedObjectReference, MutablePair<String, Boolean>>();
        result.setDestination("/topic/alarms");
        for (AlarmChange change : changes) {
            PartialUpdateItem<AlarmState> update = this.createAlarmUpdate(change, entityNames, alarmPropertiesMap);
            if (update == null) continue;
            updates.add(update);
        }
        ArrayList<QuerySpec> querySpecs = new ArrayList<QuerySpec>();
        if (!entityNames.isEmpty()) {
            QuerySpec entityNamesQuerySpec = this.querySpecBuilder.buildQuerySpec(entityNames.keySet().toArray(), new String[]{"name"});
            entityNamesQuerySpec.name = ENTITY_NAMES_QUERY_NAME;
            querySpecs.add(entityNamesQuerySpec);
        }
        if (!alarmPropertiesMap.isEmpty()) {
            QuerySpec alarmsPropsQuerySpec = this.querySpecBuilder.buildQuerySpec(alarmPropertiesMap.keySet().toArray(), new String[]{"info.name", "info.expression"});
            alarmsPropsQuerySpec.name = ALARM_PROPS_QUERY_NAME;
            querySpecs.add(alarmsPropsQuerySpec);
        }
        if (querySpecs.isEmpty()) {
            return result;
        }
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = querySpecs.toArray(new QuerySpec[0]);
        ResultSet[] resultSets = this.dataService.getData((RequestSpec)requestSpec).resultSet;
        if (resultSets == null) {
            ArrayList<String> queryNames = new ArrayList<String>();
            for (QuerySpec querySpec : querySpecs) {
                queryNames.add(querySpec.name);
            }
            _logger.error((Object)(performanceLoggingPrefix + "DataService didn't return any result for: " + Arrays.toString(queryNames.toArray())));
            return result;
        }
        for (ResultSet resultSet : resultSets) {
            if (resultSet.error != null) {
                _logger.error((Object)(performanceLoggingPrefix + "DataService threw an error for: " + resultSet.queryName));
                continue;
            }
            ResultItem[] items = resultSet.items;
            if (items == null || items.length == 0) {
                _logger.error((Object)(performanceLoggingPrefix + "DataService returned empty result for: " + resultSet.queryName));
                continue;
            }
            for (ResultItem item : items) {
                ManagedObjectReference resourceObject = (ManagedObjectReference)item.resourceObject;
                for (PropertyValue propertyValue : item.properties) {
                    if (ENTITY_NAMES_QUERY_NAME.equals(resultSet.queryName)) {
                        entityNames.put(resourceObject, (String)propertyValue.value);
                        continue;
                    }
                    if (!ALARM_PROPS_QUERY_NAME.equals(resultSet.queryName)) continue;
                    MutablePair alarmProps = (MutablePair)alarmPropertiesMap.get(resourceObject);
                    if (alarmProps == null) {
                        alarmProps = new MutablePair();
                        alarmPropertiesMap.put(resourceObject, (MutablePair<String, Boolean>)alarmProps);
                    }
                    if ("info.name".equals(propertyValue.propertyName)) {
                        alarmProps.setLeft((Object)((String)propertyValue.value));
                        continue;
                    }
                    if (!"info.expression".equals(propertyValue.propertyName)) continue;
                    alarmProps.setRight((Object)(propertyValue.value != null ? 1 : 0));
                }
            }
        }
        HashSet<Integer> updatesToDelete = null;
        for (int i = 0; i < updates.size(); ++i) {
            PartialUpdateItem pui = (PartialUpdateItem)updates.get(i);
            if (pui.isDelta) continue;
            Map metadata = pui.metadata;
            if (!metadata.containsKey("alarmName")) {
                MutablePair alarmProps = (MutablePair)alarmPropertiesMap.get(((AlarmState)pui.data).alarm);
                if (alarmProps == null) {
                    if (updatesToDelete == null) {
                        updatesToDelete = new HashSet<Integer>();
                    }
                    updatesToDelete.add(i);
                    continue;
                }
                metadata.put("alarmName", alarmProps.left);
                if (((Boolean)alarmProps.right).booleanValue()) {
                    metadata.put("hasExpression", true);
                }
            }
            if (metadata.containsKey("entityName")) continue;
            String entityName = (String)entityNames.get(((AlarmState)pui.data).entity);
            if (entityName == null) {
                if (updatesToDelete == null) {
                    updatesToDelete = new HashSet();
                }
                updatesToDelete.add(i);
                continue;
            }
            metadata.put("entityName", entityName);
        }
        if (updatesToDelete != null) {
            _logger.error((Object)"Some of the alarm metadata is not populated. Filtering these alarms...");
            ArrayList<PartialUpdateItem> filteredUpdates = new ArrayList<PartialUpdateItem>();
            for (int i = 0; i < updates.size(); ++i) {
                if (updatesToDelete.contains(i)) continue;
                filteredUpdates.add((PartialUpdateItem)updates.get(i));
            }
            result.updates = filteredUpdates;
        }
        return result;
    }

    private PartialUpdateItem<AlarmState> createAlarmUpdate(AlarmChange change, Map<ManagedObjectReference, String> entityNames, Map<ManagedObjectReference, MutablePair<String, Boolean>> alarmPropertiesMap) {
        PartialUpdateItem update = null;
        String updateKind = change.getKind();
        AlarmState alarmState = AlarmChangeProcessorImpl.toAlarmState(change);
        if (AlarmChange.Kind.cleared.name().equals(updateKind)) {
            update = PartialUpdateItem.deltaOf(null, (Object)alarmState.key);
            if (alarmState.alarm != null) {
                AlarmUtil.assignMetadata(update, "objUpdateGuid", alarmState.alarm.getServerGuid());
            }
        } else if (AlarmChange.Kind.triggered.name().equals(updateKind)) {
            update = PartialUpdateItem.of((Object)alarmState, (Object)change.getAlarm());
            AlarmUtil.assignMetadata(update, "objUpdateGuid", alarmState.entity.getServerGuid());
            if (change.entityName != null && change.alarmName != null) {
                AlarmUtil.assignMetadata(update, "entityName", change.entityName);
                AlarmUtil.assignMetadata(update, "alarmName", change.alarmName);
                AlarmUtil.assignMetadata(update, "hasExpression", (change.flags & hasExpressionBitMask) != 0);
            } else {
                entityNames.put(change.entity, null);
                alarmPropertiesMap.put(change.alarm, null);
            }
        } else if (AlarmChange.Kind.retriggered.name().equals(updateKind) || AlarmChange.Kind.acknowledged.name().equals(updateKind)) {
            update = PartialUpdateItem.deltaOf((Object)alarmState, (Object)alarmState.alarm);
            AlarmUtil.assignMetadata(update, "objUpdateGuid", alarmState.entity.getServerGuid());
        } else {
            _logger.warn((Object)("Unknown alarm update kind " + updateKind));
        }
        return update;
    }

    private static AlarmState toAlarmState(AlarmChange alarmChange) {
        AlarmState result = new AlarmState();
        result.key = AlarmChangeProcessorImpl.getAlarmStateKey(alarmChange);
        result.entity = alarmChange.getEntity();
        result.alarm = alarmChange.getAlarm();
        result.overallStatus = alarmChange.getOverallStatus();
        result.time = alarmChange.getTime();
        result.eventKey = alarmChange.getEventKey();
        result.acknowledged = AlarmChange.Kind.acknowledged.name().equals(alarmChange.getKind());
        result.acknowledgedByUser = alarmChange.getAcknowledgedByUser();
        result.acknowledgedTime = alarmChange.getAcknowledgedTime();
        return result;
    }

    private static String getAlarmStateKey(AlarmChange alarmChange) {
        if (alarmChange.getAlarm() == null) {
            return null;
        }
        ManagedObjectReference alarm = alarmChange.getAlarm();
        ManagedObjectReference entity = alarmChange.getEntity();
        return alarm.getValue() + "." + entity.getValue();
    }
}

