/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.alarms.impl;

import com.vmware.opsmgmt.client.alarms.util.AlarmInfoRetriever;
import com.vmware.opsmgmt.client.alarms.util.AlarmStateRetriever;
import com.vmware.opsmgmt.client.alarms.util.EntityNameRetriever;
import com.vmware.opsmgmt.client.alarms.util.IssueInfoBuilder;
import com.vmware.opsmgmt.client.alarms.util.LabelAndIconRetriever;
import com.vmware.opsmgmt.client.alarms.util.Util;
import com.vmware.vim.binding.vim.alarm.AlarmInfo;
import com.vmware.vim.binding.vim.alarm.AlarmState;
import com.vmware.vim.binding.vmodl.DynamicProperty;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.monitor.IssueInfo;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.issue.impl.IssueAdapterBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@type(value="Issue,AlarmIssue")
public class AlarmIssueAdapter
extends IssueAdapterBase {
    private static final Log _logger = LogFactory.getLog(AlarmIssueAdapter.class);
    private static final IssueAdapterBase.IssueData[] _EMPTY_ISSUE_DATA = new IssueAdapterBase.IssueData[0];
    private static final int ALARM_INFO_INDEX = 1;
    private DataService _dataService;
    private final AlarmStateRetriever _alarmStateRetriever;
    private final AlarmInfoRetriever _alarmInfoRetriever;
    private final IssueInfoBuilder _issueInfoBuilder;
    private final EntityNameRetriever _entityNameRetriever;

    public AlarmIssueAdapter(DataService dataService, QuerySpecBuilder querySpecBuilder, ThreadPoolExecutor executor) {
        super("AlarmIssue", executor);
        this._dataService = dataService;
        this._alarmStateRetriever = new AlarmStateRetriever(dataService, querySpecBuilder);
        this._alarmInfoRetriever = new AlarmInfoRetriever(dataService);
        this._entityNameRetriever = new EntityNameRetriever(dataService);
        this._issueInfoBuilder = new IssueInfoBuilder();
    }

    protected IssueAdapterBase.IssueData[] getIssues(QuerySpec querySpec, IssueAdapterBase.RequestContext context) {
        PropertyConstraint propConstraint;
        if (querySpec.resourceSpec.constraint instanceof PropertyConstraint && AlarmIssueAdapter.isForEntity(propConstraint = (PropertyConstraint)querySpec.resourceSpec.constraint)) {
            return this.getIssuesForEntity(querySpec, context);
        }
        return this.getAllIssues(querySpec, context);
    }

    protected ResultSet processResultSet(ResultSet result, QuerySpec querySpec, IssueAdapterBase.RequestContext context) {
        if (context.context != null) {
            result.totalMatchedObjectCount = (Integer)context.context;
        }
        return result;
    }

    private IssueAdapterBase.IssueData[] getIssuesForEntity(QuerySpec querySpec, IssueAdapterBase.RequestContext context) {
        Object entity = this.extractEntityFromQuerySpec(querySpec);
        if (!(entity instanceof ManagedObjectReference)) {
            return _EMPTY_ISSUE_DATA;
        }
        ManagedObjectReference mor = (ManagedObjectReference)entity;
        ArrayList<Object> objects = new ArrayList<Object>(1);
        objects.add(entity);
        DynamicProperty[] preFetchedData = null;
        if (VcServiceUtil.is685VcOrLaterByServerGuid((String)mor.getServerGuid(), (boolean)true) && "Issue".equals(AlarmIssueAdapter.getTargetType(querySpec))) {
            Integer count = AlarmIssueAdapter.getMaxResultCount(querySpec);
            String propName = count == 4 ? "entityAlarmsTop4" : "entityAlarms";
            try {
                preFetchedData = (DynamicProperty[])QueryUtil.getProperty((DataService)this._dataService, (Object)mor, (String)propName);
            }
            catch (Exception e) {
                _logger.warn((Object)"Failed to pre-fetch issue data.", (Throwable)e);
            }
        }
        return this.getAllIssuesInternal(context, objects, AlarmIssueAdapter.getTargetType(querySpec), AlarmIssueAdapter.getMaxResultCount(querySpec), AlarmIssueAdapter.getPropertySpecs(querySpec), querySpec.name, AlarmIssueAdapter.getOffset(querySpec), preFetchedData);
    }

    private IssueAdapterBase.IssueData[] getAllIssues(QuerySpec querySpec, IssueAdapterBase.RequestContext context) {
        Object[] vcGroups = AlarmIssueAdapter.getStartupLinkedVcGroup();
        if (ArrayUtils.isEmpty((Object[])vcGroups)) {
            return _EMPTY_ISSUE_DATA;
        }
        ArrayList<Object> objects = new ArrayList<Object>();
        for (Object vcGroup : vcGroups) {
            for (VcService vc : vcGroup.getVcServices()) {
                objects.add(ManagedObjectUtil.getRootFolder((String)vc.getServiceGuid()));
            }
        }
        if (objects.isEmpty()) {
            return _EMPTY_ISSUE_DATA;
        }
        return this.getAllIssuesInternal(context, objects, AlarmIssueAdapter.getTargetType(querySpec), AlarmIssueAdapter.getMaxResultCount(querySpec), AlarmIssueAdapter.getPropertySpecs(querySpec), querySpec.name, AlarmIssueAdapter.getOffset(querySpec), null);
    }

    private IssueAdapterBase.IssueData[] getAllIssuesInternal(IssueAdapterBase.RequestContext context, List<Object> objects, String issueType, Integer maxResultCount, PropertySpec[] propertySpecs, String queryName, Integer offset, DynamicProperty[] preFetchedData) {
        boolean isPerformanceLoggerInfoEnabled = _performanceLogger.isInfoEnabled();
        long startTime = 0L;
        if (isPerformanceLoggerInfoEnabled) {
            startTime = System.currentTimeMillis();
        }
        AlarmStateRetriever.Result result = this._alarmStateRetriever.retrieve(true, objects, issueType, maxResultCount, offset, preFetchedData);
        if (isPerformanceLoggerInfoEnabled) {
            long stopTime = System.currentTimeMillis();
            _performanceLogger.info((Object)String.format("%s: AlarmsStates retrieved in %d milliseconds.", queryName, stopTime - startTime));
        }
        AlarmState[] triggeredAlarms = result.alarms;
        context.context = result.totalAlarms;
        return this.convertToAlarmIssues(triggeredAlarms, propertySpecs, queryName, preFetchedData);
    }

    private IssueAdapterBase.IssueData[] convertToAlarmIssues(AlarmState[] triggeredAlarms, PropertySpec[] propertySpecs, String queryName, DynamicProperty[] data) {
        long stopTime;
        Map<ManagedObjectReference, AlarmInfo> alarmInfos;
        boolean isPerformanceLoggerInfoEnabled = _performanceLogger.isInfoEnabled();
        long startTime = 0L;
        if (ArrayUtils.isEmpty((Object[])triggeredAlarms)) {
            return new IssueAdapterBase.IssueData[0];
        }
        LabelAndIconRetriever labelIconRetriever = new LabelAndIconRetriever(this._dataService);
        labelIconRetriever.retrieve(triggeredAlarms, propertySpecs);
        if (isPerformanceLoggerInfoEnabled) {
            startTime = System.currentTimeMillis();
        }
        Map<ManagedObjectReference, AlarmInfo> map = alarmInfos = data != null ? this.extractAlarmInfos((AlarmInfo[])data[1].getVal()) : this._alarmInfoRetriever.retrieve(triggeredAlarms);
        if (isPerformanceLoggerInfoEnabled) {
            stopTime = System.currentTimeMillis();
            _performanceLogger.info((Object)String.format("%s: AlarmInfos retrieved in %d ms.", queryName, stopTime - startTime));
            startTime = stopTime;
        }
        Map<ManagedObjectReference, String> entityNames = this._entityNameRetriever.retrieve(triggeredAlarms, alarmInfos, data);
        if (isPerformanceLoggerInfoEnabled) {
            stopTime = System.currentTimeMillis();
            _performanceLogger.info((Object)String.format("%s: EntityNames retrieved in %d ms.", queryName, stopTime - startTime));
        }
        ArrayList<IssueAdapterBase.IssueData> issues = new ArrayList<IssueAdapterBase.IssueData>();
        for (AlarmState alarm : triggeredAlarms) {
            IssueInfo alarmIssueInfo;
            if (alarm == null || (alarmIssueInfo = this._issueInfoBuilder.build(alarm, alarmInfos, entityNames, labelIconRetriever.getIconIds(), labelIconRetriever.getLabelIds())) == null) continue;
            IssueAdapterBase.IssueData issue = new IssueAdapterBase.IssueData();
            issue.key = Util.buildAlarmKey(alarm);
            issue.issueInfo = alarmIssueInfo;
            issues.add(issue);
        }
        return issues.toArray(new IssueAdapterBase.IssueData[0]);
    }

    private Map<ManagedObjectReference, AlarmInfo> extractAlarmInfos(AlarmInfo[] data) {
        HashMap<ManagedObjectReference, AlarmInfo> result = new HashMap<ManagedObjectReference, AlarmInfo>();
        for (AlarmInfo alarmInfo : data) {
            result.put(alarmInfo.alarm, alarmInfo);
        }
        return result;
    }

    private static boolean isForEntity(PropertyConstraint propConstraint) {
        return Comparator.EQUALS.equals((Object)propConstraint.comparator) && "info.entity".equals(propConstraint.propertyName);
    }

    private static String getTargetType(QuerySpec querySpec) {
        return querySpec.resourceSpec.constraint.targetType;
    }

    private static Integer getMaxResultCount(QuerySpec querySpec) {
        return querySpec.resultSpec.maxResultCount;
    }

    private static Integer getOffset(QuerySpec querySpec) {
        return querySpec.resultSpec.offset;
    }

    private static PropertySpec[] getPropertySpecs(QuerySpec querySpec) {
        return querySpec.resourceSpec.propertySpecs;
    }

    private static LinkedVcGroup[] getStartupLinkedVcGroup() {
        LinkedVcGroupRegistry registry = VimSessionUtil.getLinkedVcGroupRegistry();
        return registry.getUtils().getStartupLinkedVcGroups();
    }
}

