/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.alarms.util;

import com.vmware.vim.binding.vim.ManagedEntity;
import com.vmware.vim.binding.vim.alarm.AlarmState;
import java.util.Calendar;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class AlarmStateComparator
implements Comparator<AlarmState> {
    private static final int NOT_NULL = -2;
    private static final Map<ManagedEntity.Status, Integer> _statusMap = new HashMap<ManagedEntity.Status, Integer>();

    @Override
    public int compare(AlarmState o1, AlarmState o2) {
        int result = this.compareNulls(o1, o2);
        if (result != -2) {
            return result;
        }
        result = this.compareAcknowledged(o1, o2);
        if (result != 0) {
            return result;
        }
        result = this.compareStatus(o1, o2);
        if (result != 0) {
            return result;
        }
        result = this.compareTime(o1, o2);
        return result;
    }

    private int compareNulls(Object o1, Object o2) {
        if (o1 == null) {
            if (o2 == null) {
                return 0;
            }
            return 1;
        }
        if (o2 == null) {
            return -1;
        }
        return -2;
    }

    private int compareAcknowledged(AlarmState o1, AlarmState o2) {
        Boolean acknowledged1 = o1.acknowledged != null ? o1.acknowledged : false;
        Boolean acknowledged2 = o2.acknowledged != null ? o2.acknowledged : false;
        return acknowledged1.compareTo(acknowledged2);
    }

    private int compareStatus(AlarmState o1, AlarmState o2) {
        ManagedEntity.Status overallStatus1 = o1.overallStatus != null ? o1.overallStatus : ManagedEntity.Status.gray;
        ManagedEntity.Status overallStatus2 = o2.overallStatus != null ? o2.overallStatus : ManagedEntity.Status.gray;
        Integer status1 = _statusMap.get(overallStatus1);
        Integer status2 = _statusMap.get(overallStatus2);
        return status1.compareTo(status2);
    }

    private int compareTime(AlarmState o1, AlarmState o2) {
        Calendar time2;
        Calendar time1;
        if (o1.time != null) {
            time1 = o1.time;
        } else {
            time1 = Calendar.getInstance();
            time1.clear();
        }
        if (o2.time != null) {
            time2 = o2.time;
        } else {
            time2 = Calendar.getInstance();
            time2.clear();
        }
        return time1.compareTo(time2) * -1;
    }

    static {
        _statusMap.put(ManagedEntity.Status.gray, 3);
        _statusMap.put(ManagedEntity.Status.green, 2);
        _statusMap.put(ManagedEntity.Status.yellow, 1);
        _statusMap.put(ManagedEntity.Status.red, 0);
    }
}

