/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.alarms.util;

import com.vmware.vim.binding.vim.alarm.AlarmState;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AlarmStateFilter {
    private static final Log _logger = LogFactory.getLog(AlarmStateFilter.class);
    private static final String ALARM_ISSUE_TYPE = "AlarmIssue";
    private static final String GENERIC_ISSUE_TYPE = "Issue";

    public List<AlarmState> filterByIssueType(List<AlarmState> alarms, String requestedIssueType) {
        if (alarms == null || alarms.isEmpty()) {
            return alarms;
        }
        if (ALARM_ISSUE_TYPE.equals(requestedIssueType)) {
            return alarms;
        }
        if (GENERIC_ISSUE_TYPE.equals(requestedIssueType)) {
            return this.filterAlarms(alarms, false);
        }
        _logger.warn((Object)String.format("Unexpected target type: %s", requestedIssueType));
        return alarms;
    }

    private List<AlarmState> filterAlarms(List<AlarmState> alarms, boolean acknowledged) {
        int keptAlarmsCount = 0;
        for (int i = 0; i < alarms.size(); ++i) {
            AlarmState alarm = alarms.get(i);
            if (alarm.acknowledged != acknowledged) continue;
            if (keptAlarmsCount != i) {
                alarms.set(keptAlarmsCount, alarm);
            }
            ++keptAlarmsCount;
        }
        if (keptAlarmsCount != alarms.size()) {
            return alarms.subList(0, keptAlarmsCount);
        }
        return alarms;
    }
}

