/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.alarms.util;

import com.vmware.opsmgmt.client.alarms.TriggeredAlarmDetails;
import com.vmware.opsmgmt.client.alarms.util.Util;
import com.vmware.vim.binding.vim.AboutInfo;
import com.vmware.vim.binding.vim.ManagedEntity;
import com.vmware.vim.binding.vim.alarm.AlarmInfo;
import com.vmware.vim.binding.vim.alarm.AlarmState;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.monitor.IssueInfo;
import com.vmware.vise.core.model.monitor.IssueStatus;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IssueInfoBuilder {
    private static final Log _logger = LogFactory.getLog(IssueInfoBuilder.class);
    private static final String ISSUE_INFO_BUILDER_SYNC_OBJECT_KEY = "com.vmware.opsmgmt.client.alarms.util.IssueInfoBuilder";
    private static final String DB_HEALTH_ALARM_SYSTEM_NAME = "alarm.DBHealthAlarm";
    private static final String SERVER_GUID_TO_OS_TYPE_MAP = "serverGuidToOsTypeMap";
    private static final String OS_TYPE_LINUX = "linux";

    public IssueInfo build(AlarmState alarm, Map<ManagedObjectReference, AlarmInfo> alarmDefinitions, Map<ManagedObjectReference, String> entityNames, Map<ManagedObjectReference, String> iconIds, Map<ManagedObjectReference, String> labelIds) {
        boolean hasLabelsRequested;
        boolean hasIconsRequested = iconIds != null && !iconIds.isEmpty();
        boolean bl = hasLabelsRequested = labelIds != null && !labelIds.isEmpty();
        if (!alarmDefinitions.containsKey(alarm.alarm)) {
            _logger.warn((Object)("AlarmInfo is not available for the following alarm: " + alarm.key));
            return null;
        }
        IssueInfo alarmIssueInfo = new IssueInfo();
        alarmIssueInfo.typeDisplayName = Util.getLocalizedString("alarmIssue.displayName");
        alarmIssueInfo.timestamp = alarm.time.getTime();
        alarmIssueInfo.entity = alarm.entity;
        alarmIssueInfo.entityName = entityNames.get(alarm.entity);
        alarmIssueInfo.description = this.getAlarmDescription(alarm.alarm, alarmDefinitions);
        alarmIssueInfo.status = this.convertAlarmStatus(alarm.overallStatus);
        TriggeredAlarmDetails alarmIssueDetails = new TriggeredAlarmDetails();
        alarmIssueDetails.alarmState = alarm;
        alarmIssueDetails.alarmInfo = alarmDefinitions.get(alarm.alarm);
        alarmIssueDetails.definedInEntityName = entityNames.get(alarmIssueDetails.alarmInfo.entity);
        if (hasIconsRequested) {
            alarmIssueDetails.entityIconId = iconIds.get(alarm.entity);
        }
        if (hasLabelsRequested) {
            alarmIssueDetails.entityLablesIds = labelIds.get(alarm.entity);
        }
        alarmIssueDetails.showVAMILink = this.isDBHealthAlarm(alarmIssueDetails.alarmInfo) && this.vcIsVCSA(alarm.entity.getServerGuid());
        alarmIssueInfo.details = alarmIssueDetails;
        return alarmIssueInfo;
    }

    private IssueStatus convertAlarmStatus(ManagedEntity.Status alarmStatus) {
        switch (alarmStatus) {
            case yellow: {
                return IssueStatus.WARNING;
            }
            case red: {
                return IssueStatus.ERROR;
            }
            case green: {
                return IssueStatus.INFO;
            }
            case gray: {
                return IssueStatus.INFO;
            }
        }
        return IssueStatus.INFO;
    }

    private String getAlarmDescription(ManagedObjectReference alarm, Map<ManagedObjectReference, AlarmInfo> alarmDefinitions) {
        AlarmInfo alarmInfo = alarmDefinitions.get(alarm);
        if (alarmInfo != null) {
            return alarmInfo.name;
        }
        _logger.warn((Object)String.format("Could not retrieve alarm definition for a triggered alarm - %s", alarm.toString()));
        return "";
    }

    private boolean isDBHealthAlarm(AlarmInfo alarmInfo) {
        return StringUtils.isNotEmpty((String)alarmInfo.systemName) && alarmInfo.systemName.equals(DB_HEALTH_ALARM_SYSTEM_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean vcIsVCSA(String serverGuid) {
        Object syncObject;
        boolean isVCSA = false;
        VcService service = VimSessionUtil.getService((String)serverGuid);
        if (service == null) {
            return false;
        }
        HttpSession httpSession = SessionUtil.getHttpSession();
        if (httpSession == null) {
            return false;
        }
        Object object = syncObject = SessionUtil.getSyncObject((String)ISSUE_INFO_BUILDER_SYNC_OBJECT_KEY, (HttpSession)httpSession);
        synchronized (object) {
            HashMap<String, Boolean> sessionData = (HashMap<String, Boolean>)SessionUtil.getData((String)SERVER_GUID_TO_OS_TYPE_MAP);
            if (sessionData == null) {
                sessionData = new HashMap<String, Boolean>();
                SessionUtil.setData((String)SERVER_GUID_TO_OS_TYPE_MAP, sessionData);
            }
            if (sessionData.containsKey(serverGuid)) {
                return (Boolean)sessionData.get(serverGuid);
            }
            if (VcServiceUtil.isVc61OrLater((String)serverGuid)) {
                try {
                    AboutInfo aboutInfo = service.getServiceInstanceContent().about;
                    isVCSA = StringUtils.isNotEmpty((String)aboutInfo.osType) && aboutInfo.osType.contains(OS_TYPE_LINUX);
                }
                catch (Exception e) {
                    _logger.error((Object)"Failed to retrieve service about info.", (Throwable)e);
                }
            }
            sessionData.put(serverGuid, isVCSA);
        }
        return isVCSA;
    }
}

