/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.alarms.util;

import com.vmware.vim.binding.vim.alarm.AlarmState;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.util.QueryUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LabelAndIconRetriever {
    private static final String ENTITY_ICON_ID_PROP = "entityIconId";
    private static final String MO_ICON_ID_PROP = "primaryIconId";
    private static final String ENTITY_LABELS_IDS_PROPS = "entityLabelIds";
    private static final String MO_LABELS_IDS_PROPS = "labelIds";
    private static final Log _logger = LogFactory.getLog(LabelAndIconRetriever.class);
    private DataService _dataService;
    private Map<ManagedObjectReference, String> _labelIds;
    private Map<ManagedObjectReference, String> _iconIds;

    public LabelAndIconRetriever(DataService dataService) {
        this._dataService = dataService;
        this._iconIds = new HashMap<ManagedObjectReference, String>();
        this._labelIds = new HashMap<ManagedObjectReference, String>();
    }

    public Map<ManagedObjectReference, String> getLabelIds() {
        return this._labelIds;
    }

    public Map<ManagedObjectReference, String> getIconIds() {
        return this._iconIds;
    }

    public void retrieve(AlarmState[] triggeredAlarms, PropertySpec[] propertySpecs) {
        this._iconIds = new HashMap<ManagedObjectReference, String>();
        this._labelIds = new HashMap<ManagedObjectReference, String>();
        if (ArrayUtils.isEmpty((Object[])propertySpecs)) {
            return;
        }
        PropertySpec spec = propertySpecs[0];
        if (spec == null || ArrayUtils.isEmpty((Object[])spec.propertyNames)) {
            return;
        }
        ArrayList<String> requestedProperties = new ArrayList<String>();
        for (String prop : spec.propertyNames) {
            if (ENTITY_ICON_ID_PROP.equals(prop)) {
                requestedProperties.add(MO_ICON_ID_PROP);
                continue;
            }
            if (!ENTITY_LABELS_IDS_PROPS.equals(prop)) continue;
            requestedProperties.add(MO_LABELS_IDS_PROPS);
        }
        if (requestedProperties.isEmpty()) {
            return;
        }
        try {
            PropertyValue[] returnedProperties;
            Object[] entitiesObjects = this.getEntities(triggeredAlarms);
            for (PropertyValue propertyValue : returnedProperties = QueryUtil.getProperties((DataService)this._dataService, (Object[])entitiesObjects, (String[])requestedProperties.toArray(new String[requestedProperties.size()]))) {
                if (propertyValue.propertyName.equals(MO_ICON_ID_PROP)) {
                    if (propertyValue.resourceObject == null || propertyValue.value == null) continue;
                    this._iconIds.put((ManagedObjectReference)propertyValue.resourceObject, propertyValue.value.toString());
                    continue;
                }
                if (!propertyValue.propertyName.equals(MO_LABELS_IDS_PROPS) || propertyValue.resourceObject == null || propertyValue.value == null) continue;
                this._labelIds.put((ManagedObjectReference)propertyValue.resourceObject, propertyValue.value.toString());
            }
        }
        catch (Exception e) {
            _logger.error((Object)("Error retrieving properties: " + requestedProperties), (Throwable)e);
        }
    }

    private ManagedObjectReference[] getEntities(AlarmState[] triggeredAlarms) {
        HashSet<ManagedObjectReference> entities = new HashSet<ManagedObjectReference>();
        for (AlarmState state : triggeredAlarms) {
            entities.add(state.entity);
        }
        return entities.toArray(new ManagedObjectReference[entities.size()]);
    }
}

