/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.commons.util;

import com.vmware.opsmgmt.client.commons.util.ManagedObjectTypes;
import com.vmware.vim.binding.vim.event.Event;
import com.vmware.vim.binding.vim.event.EventDescription;
import com.vmware.vim.binding.vim.event.ExtendedEvent;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import org.apache.commons.lang3.StringUtils;

public class EventMessageFormatter {
    private Event _event;
    private EventDescription.EventDetail _eventDetail;
    private ManagedObjectReference _context;

    public EventMessageFormatter(Event event, EventDescription.EventDetail eventDetail, ManagedObjectReference context) {
        this._event = event;
        this._eventDetail = eventDetail;
        this._context = context;
    }

    public String getFullMessage() {
        String result = "";
        result = this._event instanceof ExtendedEvent ? this.getFullFormattedMessage() : (this._eventDetail == null ? this.getFullFormattedMessage() : this.getContextSensitiveMessage());
        return result;
    }

    private String getFullFormattedMessage() {
        if (this._event.fullFormattedMessage != null) {
            return this._event.fullFormattedMessage;
        }
        return "";
    }

    private String getContextSensitiveMessage() {
        String result = "";
        if (this._context == null) {
            result = this._eventDetail.fullFormat;
        } else {
            switch (ManagedObjectTypes.getValueOf(this._context.getType())) {
                case VIRTUAL_MACHINE: {
                    if (this._event.vm == null || this._event.vm.vm == null || !this._event.vm.vm.getServerGuid().equals(this._context.getServerGuid())) break;
                    result = this._eventDetail.formatOnVm;
                    break;
                }
                case HOST: {
                    if (this._event.host == null || this._event.host.host == null || !this._event.host.host.getServerGuid().equals(this._context.getServerGuid())) break;
                    result = this._eventDetail.formatOnHost;
                    break;
                }
                case COMPUTE_RESOURCE: {
                    if (this._event.computeResource == null || this._event.computeResource.computeResource == null || this._event.computeResource.computeResource.getServerGuid() != this._context.getServerGuid()) break;
                    result = this.getFormatOnComputeResource();
                    break;
                }
                case DATACENTER: {
                    if (this._event.datacenter == null || this._event.datacenter.datacenter == null || this._event.datacenter.datacenter.getServerGuid() != this._context.getServerGuid()) break;
                    result = this.getFormatOnDatacenter();
                    break;
                }
                case DATASTORE: {
                    if (this._event.ds == null || this._event.ds.datastore == null || this._event.ds.datastore.getServerGuid() != this._context.getServerGuid()) break;
                    result = this.getFormatOnDatacenter();
                }
            }
            if (StringUtils.isEmpty((CharSequence)result)) {
                result = this._eventDetail.fullFormat;
            }
        }
        return result;
    }

    private String getFormatOnComputeResource() {
        String result = this._eventDetail.formatOnComputeResource;
        if (StringUtils.isEmpty((CharSequence)result) && StringUtils.isEmpty((CharSequence)(result = this._eventDetail.formatOnHost))) {
            result = this._eventDetail.formatOnVm;
        }
        return result;
    }

    private String getFormatOnDatacenter() {
        String result = this._eventDetail.formatOnDatacenter;
        if (StringUtils.isEmpty((CharSequence)result)) {
            result = this.getFormatOnComputeResource();
        }
        return result;
    }
}

