/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.actions;

import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.security.AuthorizationUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HostIssueActionResolverPropertyProvider {
    private static final String RUNTIME_DAS_HOST_STATE_PROPERTY = "runtime/dasHostState";
    private static final String CLUSTER_PROPERTY = "cluster";
    private static final String EDIT_CLUSTER_PRIVILEGE = "Host.Inventory.EditCluster";
    private static final String CONFIG_CONNECTION_PRIVILEGE = "Host.Config.Connection";
    private final QueryService queryService;

    public HostIssueActionResolverPropertyProvider(QueryServiceFactory queryServiceFactory) {
        this.queryService = queryServiceFactory.getQueryService();
    }

    @PropertyProvider(value="HostSystem/isSuppressNoRedundantManagementNetworkIssueAllow")
    public List<Boolean> getIsSuppressNoRedundantManagementNetworkIssueAllow(Collection<ManagedObjectReference> hostRefs) {
        ResultSet resultSet = this.queryService.select(new String[]{"@modelKey", "grantedPrivileges", RUNTIME_DAS_HOST_STATE_PROPERTY, CLUSTER_PROPERTY}).from(new String[]{HostSystem.class.getSimpleName()}).where(LogicalOperator.AND, this.buildIdentityFilter(hostRefs)).fetch();
        Set<ManagedObjectReference> allHosts = this.getApplicableHosts(resultSet.getItems());
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        for (ManagedObjectReference hostRef : hostRefs) {
            result.add(allHosts.contains(hostRef));
        }
        return result;
    }

    private Set<ManagedObjectReference> getApplicableHosts(List<ResourceItem> resourceItems) {
        HashSet<ManagedObjectReference> allHosts = new HashSet<ManagedObjectReference>();
        if (resourceItems.isEmpty()) {
            return allHosts;
        }
        Map<ManagedObjectReference, List<ManagedObjectReference>> data = this.getClustersForApplicableHosts(resourceItems);
        List<ManagedObjectReference> clusters = this.getClustersWithEditClusterPrivileges(data.keySet());
        for (ManagedObjectReference clusterRef : clusters) {
            List<ManagedObjectReference> hosts = data.get(clusterRef);
            allHosts.addAll(hosts);
        }
        return allHosts;
    }

    private List<ManagedObjectReference> getClustersWithEditClusterPrivileges(Collection<ManagedObjectReference> clusters) {
        ArrayList<ManagedObjectReference> clustersWithRequiredPrivilege = new ArrayList<ManagedObjectReference>();
        if (clusters.isEmpty()) {
            return clustersWithRequiredPrivilege;
        }
        ResultSet resultSet = this.queryService.select(new String[]{"@modelKey", "grantedPrivileges"}).from(new String[]{ClusterComputeResource.class.getSimpleName()}).where(LogicalOperator.AND, this.buildIdentityFilter(clusters)).fetch();
        if (!resultSet.getItems().isEmpty()) {
            for (ResourceItem resourceItem : resultSet.getItems()) {
                String[] grantedPriv = (String[])resourceItem.get("grantedPrivileges");
                ManagedObjectReference clusterRef = (ManagedObjectReference)resourceItem.get("@modelKey");
                if (!AuthorizationUtil.isPrivilegeGranted((String[])new String[]{EDIT_CLUSTER_PRIVILEGE}, (String[])grantedPriv)) continue;
                clustersWithRequiredPrivilege.add(clusterRef);
            }
        }
        return clustersWithRequiredPrivilege;
    }

    private List<PropertyPredicate> buildIdentityFilter(Collection<ManagedObjectReference> objects) {
        ArrayList<PropertyPredicate> filter = new ArrayList<PropertyPredicate>();
        filter.add(new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.IN, objects));
        return filter;
    }

    private Map<ManagedObjectReference, List<ManagedObjectReference>> getClustersForApplicableHosts(List<ResourceItem> resourceItems) {
        HashMap<ManagedObjectReference, List<ManagedObjectReference>> result = new HashMap<ManagedObjectReference, List<ManagedObjectReference>>();
        for (ResourceItem resourceItem : resourceItems) {
            ManagedObjectReference hostRef = (ManagedObjectReference)resourceItem.get("@modelKey");
            ManagedObjectReference clusterRef = (ManagedObjectReference)resourceItem.get(CLUSTER_PROPERTY);
            Object hostDasState = resourceItem.get(RUNTIME_DAS_HOST_STATE_PROPERTY);
            String[] grantedPriv = (String[])resourceItem.get("grantedPrivileges");
            if (hostDasState == null || clusterRef == null || !AuthorizationUtil.isPrivilegeGranted((String[])new String[]{CONFIG_CONNECTION_PRIVILEGE}, (String[])grantedPriv)) continue;
            ArrayList<ManagedObjectReference> hosts = (ArrayList<ManagedObjectReference>)result.get(clusterRef);
            if (hosts == null) {
                hosts = new ArrayList<ManagedObjectReference>();
                result.put(clusterRef, hosts);
            }
            hosts.add(hostRef);
        }
        return result;
    }
}

