/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.config.impl;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.host.BIOSInfo;
import com.vmware.vim.binding.vim.host.BmcInfo;
import com.vmware.vim.binding.vim.host.BootDeviceInfo;
import com.vmware.vim.binding.vim.host.BootDeviceSystem;
import com.vmware.vim.binding.vim.host.ConfigManager;
import com.vmware.vim.binding.vim.host.HealthStatusSystem;
import com.vmware.vim.binding.vim.host.SystemIdentificationInfo;
import com.vmware.vim.binding.vim.host.SystemInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import com.vmware.vsphere.client.h5.host.config.HostSystemOverviewDetailsItem;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.impl.HostHardwareHealthUtil;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.model.ChassisData;
import com.vmware.vsphere.client.h5.host.model.HostSystemOverviewDetailsData;
import com.vmware.vsphere.client.h5.host.util.HostStringUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostSystemOverviewDetailsPropertyProvider
implements PropertyProviderBean {
    public static final TimeZone UTC_TIMEZONE = TimeZone.getTimeZone("GMT");
    private final QueryBindingService _queryBindingService;
    private static final Log _logger = LogFactory.getLog(HostSystemOverviewDetailsPropertyProvider.class);

    public HostSystemOverviewDetailsPropertyProvider(QueryBindingService queryBindingService) {
        this._queryBindingService = queryBindingService;
    }

    @PropertyProvider(value="HostSystem/hostSystemOverviewDetails")
    public HostSystemOverviewDetailsItem getHostSystemOverviewDetails(ManagedObjectReference hostMor) throws Exception {
        if (hostMor == null) {
            return null;
        }
        HostSystemOverviewDetailsItem hostSystemData = new HostSystemOverviewDetailsItem();
        HostSystemOverviewDetailsData HostSystemOverviewDetailsData2 = (HostSystemOverviewDetailsData)((Object)this._queryBindingService.prepare(HostSystemOverviewDetailsData.class).fetch((Object)hostMor));
        BIOSInfo biosInfo = null;
        BmcInfo bmcInfo = null;
        SystemInfo systemInfo = null;
        BootDeviceInfo bootDeviceInfo = null;
        ManagedObjectReference healthStatusSystem = null;
        if (HostSystemOverviewDetailsData2 != null) {
            biosInfo = HostSystemOverviewDetailsData2.biosInfo;
            systemInfo = HostSystemOverviewDetailsData2.systemInfo;
            healthStatusSystem = HostSystemOverviewDetailsData2.healthStatusSystem;
            bmcInfo = HostSystemOverviewDetailsPropertyProvider.getBmcInfo(healthStatusSystem);
            bootDeviceInfo = this.getBootDeviceInfo(hostMor);
            hostSystemData.biosManufacturer = biosInfo != null && biosInfo.vendor != null ? HostSystemOverviewDetailsPropertyProvider.getItemLabel(biosInfo.vendor) : HostStringUtil.getString("host.hardware.firmware.na.label", new String[0]);
            hostSystemData.biosVersion = biosInfo != null ? HostSystemOverviewDetailsPropertyProvider.getItemLabel(biosInfo.biosVersion) : HostStringUtil.getString("host.hardware.firmware.na.label", new String[0]);
            if (biosInfo != null && biosInfo.releaseDate != null) {
                Calendar cal = biosInfo.releaseDate;
                cal.setTimeZone(UTC_TIMEZONE);
                hostSystemData.releaseDate = HostSystemOverviewDetailsPropertyProvider.getItemLabel(LocalizationUtil.formatLocalizedDate((Date)cal.getTime()));
            } else {
                hostSystemData.releaseDate = HostStringUtil.getString("host.hardware.firmware.na.label", new String[0]);
            }
            if (bmcInfo != null) {
                String[] stringArray;
                hostSystemData.bmcFirmwareVersion = HostSystemOverviewDetailsPropertyProvider.getItemLabel(bmcInfo.bmcVersion);
                hostSystemData.bmcManufacturer = HostSystemOverviewDetailsPropertyProvider.getItemLabel(bmcInfo.manufacturer);
                hostSystemData.ipmiVersion = HostSystemOverviewDetailsPropertyProvider.getItemLabel(bmcInfo.ipmiVersion);
                hostSystemData.ipv4Address = HostSystemOverviewDetailsPropertyProvider.getItemLabel(bmcInfo.ipv4Address);
                hostSystemData.ipv4Gateway = HostSystemOverviewDetailsPropertyProvider.getItemLabel(bmcInfo.ipv4Gateway);
                hostSystemData.ipv4Subnet = HostSystemOverviewDetailsPropertyProvider.getItemLabel(bmcInfo.ipv4Subnet);
                hostSystemData.macAddress = HostSystemOverviewDetailsPropertyProvider.getItemLabel(bmcInfo.macAddress);
                if (ArrayUtils.isNotEmpty((Object[])bmcInfo.ipv6Addresses)) {
                    stringArray = bmcInfo.ipv6Addresses;
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = HostStringUtil.getString("host.hardware.firmware.na.label", new String[0]);
                }
                hostSystemData.ipv6Addresses = stringArray;
            } else {
                hostSystemData.ipv4Subnet = HostStringUtil.getString("host.hardware.firmware.na.label", new String[0]);
                hostSystemData.ipv6Addresses = new String[]{HostStringUtil.getString("host.hardware.firmware.na.label", new String[0])};
                hostSystemData.macAddress = HostStringUtil.getString("host.hardware.firmware.na.label", new String[0]);
                hostSystemData.ipv4Gateway = HostStringUtil.getString("host.hardware.firmware.na.label", new String[0]);
                hostSystemData.ipv4Address = HostStringUtil.getString("host.hardware.firmware.na.label", new String[0]);
                hostSystemData.ipmiVersion = HostStringUtil.getString("host.hardware.firmware.na.label", new String[0]);
                hostSystemData.bmcManufacturer = HostStringUtil.getString("host.hardware.firmware.na.label", new String[0]);
                hostSystemData.bmcFirmwareVersion = HostStringUtil.getString("host.hardware.firmware.na.label", new String[0]);
            }
            hostSystemData.bootDevice = HostSystemOverviewDetailsPropertyProvider.getItemLabel(this.getBootDeviceLabel(bootDeviceInfo));
            if (systemInfo != null) {
                List<ChassisData> chassisData = HostHardwareHealthUtil.createChassisData(systemInfo);
                hostSystemData.chassisData = this.formatChassisData(chassisData);
            } else {
                hostSystemData.chassisData = this.formatChassisData(null);
            }
            if (systemInfo != null && systemInfo.getOtherIdentifyingInfo() != null) {
                String result = "";
                for (SystemIdentificationInfo i : systemInfo.getOtherIdentifyingInfo()) {
                    if (!i.identifierType.key.equalsIgnoreCase(SystemIdentificationInfo.Identifier.AssetTag.name())) continue;
                    result = result + i.identifierValue;
                }
                hostSystemData.assetTag = HostSystemOverviewDetailsPropertyProvider.getItemLabel(result);
            } else {
                hostSystemData.assetTag = HostStringUtil.getString("host.hardware.firmware.na.label", new String[0]);
            }
        }
        return hostSystemData;
    }

    @PropertyProvider(value="HostSystem/isAttested")
    public boolean getIsAttested(ManagedObjectReference hostMor) throws Exception {
        if (hostMor == null) {
            return false;
        }
        return false;
    }

    private BootDeviceInfo getBootDeviceInfo(ManagedObjectReference hostMor) throws Exception {
        BootDeviceInfo bootDeviceInfo = null;
        try {
            BootDeviceSystem bootDeviceSystem;
            HostSystem host = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostMor);
            ConfigManager configManager = host.getConfigManager();
            if (configManager.bootDeviceSystem != null && (bootDeviceSystem = (BootDeviceSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)configManager.bootDeviceSystem)) != null) {
                bootDeviceInfo = bootDeviceSystem.queryBootDevices();
            }
        }
        catch (Exception e) {
            _logger.error((Object)"Boot device info cannot be get", (Throwable)e);
        }
        return bootDeviceInfo;
    }

    private String getBootDeviceLabel(BootDeviceInfo bootDeviceInfo) {
        if (bootDeviceInfo == null || bootDeviceInfo.bootDevices == null || bootDeviceInfo.bootDevices.length == 0) {
            return HostStringUtil.getString("host.hardware.firmware.na.label", new String[0]);
        }
        String result = "";
        for (BootDeviceSystem.BootDevice device : bootDeviceInfo.bootDevices) {
            if (device == null || !device.key.equalsIgnoreCase(bootDeviceInfo.currentBootDeviceKey)) continue;
            result = device.description;
            break;
        }
        return result;
    }

    private static BmcInfo getBmcInfo(ManagedObjectReference healthStatusSystemRef) {
        BmcInfo bmcInfo = null;
        try {
            HealthStatusSystem healthStatusSystem = (HealthStatusSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)healthStatusSystemRef);
            HealthStatusSystem.Runtime runtime = healthStatusSystem.getRuntime();
            bmcInfo = runtime.getBmcInfo();
        }
        catch (Exception e) {
            _logger.error((Object)"Can't get host bmc data data", (Throwable)e);
        }
        return bmcInfo;
    }

    private List<ChassisData> formatChassisData(List<ChassisData> chassisData) {
        ArrayList<ChassisData> formattedChassisData = new ArrayList<ChassisData>();
        if (chassisData == null) {
            ChassisData emptyChassisItem = new ChassisData();
            emptyChassisItem.model = HostStringUtil.getString("host.hardware.firmware.na.label", new String[0]);
            emptyChassisItem.otherInfo = HostStringUtil.getString("host.hardware.firmware.na.label", new String[0]);
            emptyChassisItem.serialNumber = HostStringUtil.getString("host.hardware.firmware.na.label", new String[0]);
            emptyChassisItem.enclosureSerialNumber = HostStringUtil.getString("host.hardware.firmware.na.label", new String[0]);
            emptyChassisItem.tag = HostStringUtil.getString("host.hardware.firmware.na.label", new String[0]);
            formattedChassisData.add(emptyChassisItem);
        } else {
            for (ChassisData chassisItem : chassisData) {
                chassisItem.model = HostSystemOverviewDetailsPropertyProvider.getItemLabel(chassisItem.model);
                chassisItem.otherInfo = HostSystemOverviewDetailsPropertyProvider.getItemLabel(chassisItem.otherInfo);
                chassisItem.serialNumber = HostSystemOverviewDetailsPropertyProvider.getItemLabel(chassisItem.serialNumber);
                chassisItem.enclosureSerialNumber = HostSystemOverviewDetailsPropertyProvider.getItemLabel(chassisItem.enclosureSerialNumber);
                chassisItem.tag = HostSystemOverviewDetailsPropertyProvider.getItemLabel(chassisItem.tag);
                formattedChassisData.add(chassisItem);
            }
        }
        return formattedChassisData;
    }

    private static String getItemLabel(String propertyValue) {
        return StringUtils.isNotEmpty((CharSequence)propertyValue) ? propertyValue : HostStringUtil.getString("host.hardware.firmware.na.label", new String[0]);
    }
}

