/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.config.impl;

import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.host.ConfigManager;
import com.vmware.vim.binding.vim.host.DateTimeSystem;
import com.vmware.vim.binding.vim.host.FirewallSystem;
import com.vmware.vim.binding.vim.host.Service;
import com.vmware.vim.binding.vim.host.ServiceSystem;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.h5.host.config.spec.TimeConfigSpec;
import com.vmware.vsphere.client.h5.host.util.HostStringUtil;
import com.vmware.vsphere.client.h5.host.util.TimeConfigUtil;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TimeConfigMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(TimeConfigMutationProvider.class);
    private static final String NTP_SERVICE_KEY = "ntpd";
    private static final String NTP_RULESET_KEY = "ntp";

    public OperationResult apply(ManagedObjectReference mor, TimeConfigSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = mor;
        if (spec == null) {
            String nullSpecMsg = HostStringUtil.getString("error.nullTimeConfigSpec", new String[0]);
            result.error = new IllegalArgumentException(nullSpecMsg);
            return result;
        }
        try {
            HostSystem host = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)mor);
            if (host == null) {
                return null;
            }
            ConfigManager manager = host.getConfigManager();
            ServiceSystem system = (ServiceSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)manager.getServiceSystem());
            Service ntpService = TimeConfigUtil.getService(system, NTP_SERVICE_KEY);
            FirewallSystem firewall = null;
            if (manager.getFirewallSystem() != null) {
                firewall = (FirewallSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)manager.getFirewallSystem());
            }
            DateTimeSystem dateTimeSystem = null;
            if (manager.getDateTimeSystem() != null) {
                dateTimeSystem = (DateTimeSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)manager.getDateTimeSystem());
            }
            if (spec.serviceId != null && spec.servicePolicy != null) {
                system.updatePolicy(spec.serviceId, spec.servicePolicy.toString());
            }
            if (spec.dateTimeConfig != null) {
                TimeConfigMutationProvider.updateNtpServerListAndTimeZone(spec, dateTimeSystem);
            }
            if (spec.enableNtpClient.booleanValue()) {
                TimeConfigUtil.enableService(true, firewall, ntpService, NTP_RULESET_KEY);
                if (spec.action != null) {
                    TimeConfigUtil.changeServiceState(spec.serviceId, spec.action, system);
                }
            } else {
                TimeConfigMutationProvider.updateDateTime(spec, dateTimeSystem);
                TimeConfigUtil.enableService(false, firewall, ntpService, NTP_RULESET_KEY);
                if (ntpService.running) {
                    TimeConfigUtil.changeServiceState(spec.serviceId, TimeConfigSpec.Action.stop, system);
                }
            }
            dateTimeSystem.refresh();
        }
        catch (Exception ex) {
            _logger.error((Object)"Time configuration failed", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    private static void updateDateTime(TimeConfigSpec spec, DateTimeSystem dateTimeSystem) throws Exception {
        if (spec == null || dateTimeSystem == null || spec.targetTime == null) {
            return;
        }
        Calendar greg = GregorianCalendar.getInstance();
        greg.setTime(spec.targetTime);
        dateTimeSystem.updateDateTime(greg);
    }

    private static void updateNtpServerListAndTimeZone(TimeConfigSpec spec, DateTimeSystem dateTimeSystem) throws Exception {
        if (spec == null || dateTimeSystem == null) {
            return;
        }
        dateTimeSystem.updateConfig(spec.dateTimeConfig);
    }
}

