/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.config.impl;

import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.host.ConfigManager;
import com.vmware.vim.binding.vim.host.DateTimeConfig;
import com.vmware.vim.binding.vim.host.DateTimeInfo;
import com.vmware.vim.binding.vim.host.DateTimeSystem;
import com.vmware.vim.binding.vim.host.NtpConfig;
import com.vmware.vim.binding.vim.host.PtpConfig;
import com.vmware.vim.binding.vim.host.VirtualNicManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.h5.host.config.spec.DeleteDateTimeSystemSpec;
import com.vmware.vsphere.client.h5.host.config.spec.RefreshDateTimeSystemSpec;
import com.vmware.vsphere.client.h5.host.config.spec.TestDateTimeSystemSpec;
import com.vmware.vsphere.client.h5.host.config.spec.TimeKeepingSpec;
import com.vmware.vsphere.client.h5.host.util.HostStringUtil;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TimeKeepingMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(TimeKeepingMutationProvider.class);
    private static final String PTP_NIC_TYPE = "ptp";

    public OperationResult apply(ManagedObjectReference hostRef, TimeKeepingSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = hostRef;
        if (spec == null) {
            String nullSpecMsg = HostStringUtil.getString("error.nullTimeConfigSpec", new String[0]);
            result.error = new IllegalArgumentException(nullSpecMsg);
            return result;
        }
        try {
            HostSystem host = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostRef);
            if (host == null) {
                return null;
            }
            ConfigManager configManager = host.getConfigManager();
            ManagedObjectReference dateTimeSystemMor = configManager.getDateTimeSystem();
            DateTimeSystem dateTimeSystem = (DateTimeSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)dateTimeSystemMor);
            DateTimeConfig config = new DateTimeConfig();
            if (spec.enableManual && spec.targetTime != null) {
                TimeKeepingMutationProvider.updateDateTime(spec, dateTimeSystem);
            }
            if (spec.ntpServers != null) {
                NtpConfig ntpConfig = new NtpConfig();
                ntpConfig.setServer(spec.ntpServers);
                config.setNtpConfig(ntpConfig);
            }
            if (spec.vnic != null && !spec.vnic.equals("--") && configManager.getVirtualNicManager() != null) {
                ManagedObjectReference vnicManagerMor = configManager.getVirtualNicManager();
                VirtualNicManager vNicManager = (VirtualNicManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vnicManagerMor);
                vNicManager.selectVnic(PTP_NIC_TYPE, spec.vnic);
            }
            if (spec.enablePtp) {
                config.setProtocol(DateTimeInfo.Protocol.ptp.toString());
                config.setEnabled(Boolean.valueOf(true));
            }
            if (spec.enableEvents != null) {
                config.setDisableEvents(Boolean.valueOf(spec.enableEvents == false));
            }
            if (spec.enableFallback != null) {
                config.setDisableFallback(Boolean.valueOf(spec.enableFallback == false));
            }
            if (spec.enableNtp) {
                config.setProtocol(DateTimeInfo.Protocol.ntp.toString());
                config.setEnabled(Boolean.valueOf(true));
            }
            if (spec.ptpConfigPtpPort != null && spec.ptpConfigPtpPort.getDeviceType().equals(PtpConfig.DeviceType.pciPassthruNic.name())) {
                PtpConfig ptpConfig = new PtpConfig();
                PtpConfig.PtpPort port = new PtpConfig.PtpPort();
                PtpConfig.PtpPort[] ports = new PtpConfig.PtpPort[]{port};
                port.setIndex(0);
                port.setDevice(spec.ptpConfigPtpPort.device);
                port.setDeviceType(spec.ptpConfigPtpPort.deviceType);
                port.setIpConfig(spec.ptpConfigPtpPort.ipConfig);
                ptpConfig.setPort(ports);
                config.setPtpConfig(ptpConfig);
            }
            dateTimeSystem.updateConfig(config);
            dateTimeSystem.refresh();
        }
        catch (Exception ex) {
            _logger.error((Object)"Setting Time configuration failed", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference hostRef, RefreshDateTimeSystemSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        try {
            DateTimeSystem dateTimeSystem = TimeKeepingMutationProvider.getDateTimeSystem(hostRef);
            dateTimeSystem.refresh();
        }
        catch (Exception e) {
            _logger.error((Object)"Error when calling Refresh DateTimeSystem", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, DeleteDateTimeSystemSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        try {
            String protocolToDelete = "";
            switch (spec.serviceKey) {
                case "ntpd": {
                    protocolToDelete = DateTimeInfo.Protocol.ntp.toString();
                    break;
                }
                case "ptpd": {
                    protocolToDelete = DateTimeInfo.Protocol.ptp.toString();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported service: " + spec.serviceKey);
                }
            }
            DateTimeConfig config = new DateTimeConfig();
            config.setResetToFactoryDefaults(Boolean.valueOf(true));
            config.setProtocol(protocolToDelete);
            DateTimeSystem dateTimeSystem = TimeKeepingMutationProvider.getDateTimeSystem(hostRef);
            dateTimeSystem.updateConfig(config);
            dateTimeSystem.refresh();
        }
        catch (Exception e) {
            _logger.error((Object)"Error when reset to factory default", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, TestDateTimeSystemSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        try {
            DateTimeSystem dateTimeSystem = TimeKeepingMutationProvider.getDateTimeSystem(hostRef);
            DateTimeSystem.ServiceTestResult result = dateTimeSystem.testTimeService();
            opResult.result = result;
        }
        catch (Exception e) {
            _logger.error((Object)"Error when calling testTimeService", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    private static DateTimeSystem getDateTimeSystem(ManagedObjectReference hostRef) {
        try {
            HostSystem host = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostRef);
            if (host == null) {
                return null;
            }
            ConfigManager configManager = host.getConfigManager();
            ManagedObjectReference dateTimeSystemMor = configManager.getDateTimeSystem();
            return (DateTimeSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)dateTimeSystemMor);
        }
        catch (Exception e) {
            _logger.error((Object)"Error when getting DateTimeSystem", (Throwable)e);
            return null;
        }
    }

    private static void updateDateTime(TimeKeepingSpec spec, DateTimeSystem dateTimeSystem) throws Exception {
        if (spec == null || dateTimeSystem == null || spec.targetTime == null) {
            return;
        }
        Calendar greg = GregorianCalendar.getInstance();
        greg.setTime(spec.targetTime);
        dateTimeSystem.updateDateTime(greg);
    }
}

