/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.hardware.ciminfo;

import com.vmware.vim.binding.vim.host.HealthStatusSystem;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.spec.CimMonitorSpec;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.util.CimMonitorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostCimInfoMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(HostCimInfoMutationProvider.class);

    public OperationResult apply(ManagedObjectReference host, CimMonitorSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = host;
        if (spec == null) {
            result.error = CimMonitorUtil.getLocalizedException("invalidSpec");
            return result;
        }
        this.doHealthStatusAction(host, spec);
        return result;
    }

    private void doHealthStatusAction(ManagedObjectReference hostRef, CimMonitorSpec spec) {
        try {
            HealthStatusSystem hss = CimMonitorUtil.getHealthStatusSystem(hostRef);
            if (spec.operationId == CimMonitorSpec.OperationId.REFRESH_DATA) {
                hss.refresh();
            } else if (spec.operationId == CimMonitorSpec.OperationId.RESET_SENSORS) {
                hss.resetSystemHealthInfo();
            } else if (spec.operationId == CimMonitorSpec.OperationId.RESET_EVENTS_LOG) {
                hss.clearSystemEventLog();
            }
        }
        catch (Exception exception) {
            _logger.error((Object)("Failed to perform the action: " + (Object)((Object)spec.operationId)), (Throwable)exception);
        }
    }
}

