/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.hardware.ciminfo.sensors.details;

import com.vmware.vsphere.client.h5.host.hardware.ciminfo.reader.CimMessageReader;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

public class SensorValueParser {
    private static final String SEPARATOR = ":";

    public String parseCapacity(String rawCapacityInBytes) {
        long capacity;
        String parsedValue = NumberUtils.isNumber((String)rawCapacityInBytes) ? ((capacity = Long.parseLong(rawCapacityInBytes)) >= 0x40000000L ? String.valueOf(capacity / 0x40000000L) : (capacity >= 0x100000L ? String.valueOf(capacity / 0x100000L) : rawCapacityInBytes)) : rawCapacityInBytes;
        return parsedValue;
    }

    public String parseClockSpeed(String rawValueInMegahertz) {
        long clockSpeed;
        String parsedValue = NumberUtils.isNumber((String)rawValueInMegahertz) ? ((clockSpeed = Long.parseLong(rawValueInMegahertz)) >= 1000L ? String.valueOf(clockSpeed / 1000L) : rawValueInMegahertz) : rawValueInMegahertz;
        return parsedValue;
    }

    public String parseKeyValue(String keyPrefix, String keyIndex) {
        String result;
        if (StringUtils.isNotEmpty((String)keyPrefix) && StringUtils.isNotEmpty((String)keyIndex)) {
            String fullKey;
            String trimmedKeyIndex = keyIndex.trim();
            if (SensorValueParser.isArray(trimmedKeyIndex)) {
                String strippedKeyIndex = trimmedKeyIndex.substring(1, trimmedKeyIndex.length() - 1);
                String[] indexes = strippedKeyIndex.split(",");
                fullKey = this.parseKeyValue(keyPrefix, indexes);
            } else {
                fullKey = keyPrefix + "_" + keyIndex;
            }
            result = CimMessageReader.getName((String)fullKey);
        } else {
            result = null;
        }
        return result;
    }

    private String parseKeyValue(String keyPrefix, String[] keyIndexes) {
        Object[] parsedValues = new String[keyIndexes.length];
        for (int i = 0; i < keyIndexes.length; ++i) {
            parsedValues[i] = this.parseKeyValue(keyPrefix, keyIndexes[i].trim());
        }
        return StringUtils.join((Object[])parsedValues, (String)", ");
    }

    public String parseHexadecimal(String rawValue) {
        String parsedHex;
        if (NumberUtils.isNumber((String)rawValue)) {
            long hex = Long.parseLong(rawValue);
            parsedHex = String.format("0x%05X", hex);
        } else {
            parsedHex = rawValue;
        }
        return parsedHex;
    }

    public String parseValueWithModifier(String value, String modifier) {
        String result;
        double parsedModifier = SensorValueParser.parseUnitModifier(modifier);
        if (NumberUtils.isNumber((String)value)) {
            double doubleValue = Double.parseDouble(value);
            if (Double.compare(parsedModifier, 1.0) != 0) {
                doubleValue *= Math.pow(10.0, parsedModifier);
            }
            DecimalFormat df = new DecimalFormat("#.#######");
            df.setRoundingMode(RoundingMode.CEILING);
            result = df.format(doubleValue);
        } else {
            result = value;
        }
        return result;
    }

    public String parseMacAddresses(String rawValue) {
        String parsedValue = null;
        if (StringUtils.isNotEmpty((String)rawValue)) {
            String trimmedValue = rawValue.trim();
            if (SensorValueParser.isArray(rawValue)) {
                String strippedKeyIndex = trimmedValue.substring(1, trimmedValue.length() - 1);
                String[] macAddresses = strippedKeyIndex.split(",");
                ArrayList<String> parsedAddresses = new ArrayList<String>();
                for (String macAddress : macAddresses) {
                    String parsedMacAddress = SensorValueParser.parseMacAddress(macAddress);
                    parsedAddresses.add(parsedMacAddress);
                }
                parsedValue = StringUtils.join(parsedAddresses, (String)", ");
            } else {
                parsedValue = SensorValueParser.parseMacAddress(rawValue);
            }
        }
        return parsedValue;
    }

    private static double parseUnitModifier(String value) {
        return NumberUtils.isNumber((String)value) ? Double.parseDouble(value) : 1.0;
    }

    private static boolean isArray(String trimmedKeyIndex) {
        return trimmedKeyIndex.startsWith("[") && trimmedKeyIndex.endsWith("]");
    }

    private static String parseMacAddress(String rawValue) {
        return rawValue.trim().replaceAll("(.{2})", "$1:").substring(0, 17);
    }
}

