/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.model;

import com.vmware.cis.data.api.binding.IdentifiableQueryBinding;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.vim.binding.vim.host.FirewallInfo;
import com.vmware.vim.binding.vim.host.ServiceInfo;
import com.vmware.vsphere.client.h5.host.model.FirewallConnPorts;
import com.vmware.vsphere.client.h5.host.model.FirewallConnection;
import com.vmware.vsphere.client.h5.host.model.FirewallConnectionData;
import com.vmware.vsphere.client.h5.host.model.FirewallConnections;
import com.vmware.vsphere.client.h5.host.util.FirewallInfoConverter;
import java.util.ArrayList;

@QueryBinding(value="HostSystem")
public class FirewallData
extends IdentifiableQueryBinding {
    @Property(value="HostSystem/config/firewall")
    public transient FirewallInfo firewallInfo;
    @Property(value="HostSystem/config/service")
    public transient ServiceInfo serviceInfo;

    public FirewallConnections getConnections() {
        FirewallConnection[] connections = FirewallInfoConverter.toFirewallConnections(this.firewallInfo, this.serviceInfo);
        FirewallConnections connectionsData = new FirewallConnections();
        ArrayList<FirewallConnectionData> outgoingConn = new ArrayList<FirewallConnectionData>();
        ArrayList<FirewallConnectionData> incomingConn = new ArrayList<FirewallConnectionData>();
        for (FirewallConnection conn : connections) {
            if (!conn.enabled) continue;
            if (conn.inboundDirectionInfo.rawTcpPorts.size() != 0 || conn.inboundDirectionInfo.rawUdpPorts.size() != 0) {
                FirewallConnectionData incomingConnData = new FirewallConnectionData();
                FirewallConnPorts incomingDirectionInfo = new FirewallConnPorts();
                incomingDirectionInfo.tcpPorts = conn.inboundDirectionInfo.tcpPorts;
                incomingDirectionInfo.udpPorts = conn.inboundDirectionInfo.udpPorts;
                incomingConnData.directionInfo = incomingDirectionInfo;
                incomingConnData.serviceName = conn.serviceName;
                incomingConnData.ipList = conn.ipList;
                incomingConn.add(incomingConnData);
            }
            if (conn.outboundDirectionInfo.rawTcpPorts.size() == 0 && conn.outboundDirectionInfo.rawUdpPorts.size() == 0) continue;
            FirewallConnectionData outgoingConnData = new FirewallConnectionData();
            FirewallConnPorts outgoingDirectionInfo = new FirewallConnPorts();
            outgoingDirectionInfo.tcpPorts = conn.outboundDirectionInfo.tcpPorts;
            outgoingDirectionInfo.udpPorts = conn.outboundDirectionInfo.udpPorts;
            outgoingConnData.directionInfo = outgoingDirectionInfo;
            outgoingConnData.serviceName = conn.serviceName;
            outgoingConnData.ipList = conn.ipList;
            outgoingConn.add(outgoingConnData);
        }
        connectionsData.outgoing = outgoingConn;
        connectionsData.incoming = incomingConn;
        return connectionsData;
    }
}

