/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.model;

import com.vmware.cis.data.api.binding.IdentifiableQueryBinding;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.cluster.DasFdmHostState;
import com.vmware.vsphere.client.h5.host.util.HostFormatUtil;
import com.vmware.vsphere.client.h5.host.util.HostStringUtil;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;

@QueryBinding(value="HostSystem")
public final class HostConfigurationData
extends IdentifiableQueryBinding {
    @Property(value="HostSystem/summary/config/vmotionEnabled")
    public boolean vmotionEnabled;
    @Property(value="HostSystem/capability/ftSupported")
    public boolean ftSupported;
    @Property(value="HostSystem/capability/smpFtSupported")
    public boolean cptFtSupported;
    @Property(value="HostSystem/runtime/dasHostState")
    public DasFdmHostState dasHostState;
    @Property(value="HostSystem/capability/ftCompatibilityIssues")
    public String[] ftUnsupportedReason;
    @Property(value="HostSystem/capability/smpFtCompatibilityIssues")
    public String[] cptFtUnsupportedReason;
    @Property(value="HostSystem/currentEVCModeLabel")
    public String currentEVCModeLabel;
    @Property(value="HostSystem/supportedEVCModeLabel")
    public Object[] supportedEVCModeLabels;
    @Property(value="HostSystem/currentEVCGraphicsModeLabel")
    public String currentEVCGraphicsModeLabel;
    @Property(value="HostSystem/supportedEVCGraphicsModeLabel")
    public Object[] supportedEVCGraphicsModeLabels;
    @Property(value="HostSystem/connectionState")
    public HostSystem.ConnectionState connectionState;

    public String getVmotion() {
        return this.vmotionEnabled ? "config.vmotion.yes" : "config.vmotion.no";
    }

    public String getUpFtSupported() {
        return this.ftSupported ? "config.ftSupported" : "config.ftUnsupported";
    }

    public String getSmpFtSupported() {
        return this.cptFtSupported ? "config.ftSupported" : "config.ftUnsupported";
    }

    public String getHaStateImage() {
        return HostFormatUtil.getHaStateImage(this.dasHostState);
    }

    public String getHaStateString() {
        return HostFormatUtil.formatHaState(this.dasHostState);
    }

    public String[][] getFtUnsupportedReasonRows() {
        return this.getReasonRows(this.ftUnsupportedReason);
    }

    public String[][] getCptUnsupportedReasonRows() {
        return this.getReasonRows(this.cptFtUnsupportedReason);
    }

    private String[][] getReasonRows(String[] reasons) {
        if (reasons == null) {
            return null;
        }
        String[][] result = new String[reasons.length][2];
        for (int i = 0; i < reasons.length; ++i) {
            String reasonCode = reasons[i];
            result[i][0] = String.format("config.ft.unsupportedReason.%s.label", reasonCode);
            result[i][1] = String.format("config.ft.unsupportedReason.%s.value", reasonCode);
        }
        return result;
    }

    public String getEvcModeText() {
        if (this.connectionState != HostSystem.ConnectionState.connected) {
            return this.connectionState == HostSystem.ConnectionState.disconnected ? HostStringUtil.getString("config.evc.na.disconnected", new String[0]) : HostStringUtil.getString("config.evc.na.notresponding", new String[0]);
        }
        if (StringUtils.isEmpty((CharSequence)this.currentEVCModeLabel)) {
            return HostStringUtil.getString("config.evc.disabled", new String[0]);
        }
        return this.currentEVCModeLabel;
    }

    public boolean getIsEVCAvailable() {
        return this.connectionState == HostSystem.ConnectionState.connected && StringUtils.isNotEmpty((CharSequence)this.currentEVCModeLabel);
    }

    public String[] getSupportedEVCGraphicsModeLabelsFiltered() {
        ArrayList<String> filtered = new ArrayList<String>();
        if (this.supportedEVCGraphicsModeLabels != null) {
            for (Object o : this.supportedEVCGraphicsModeLabels) {
                String s = o.toString();
                if (!StringUtils.isNotEmpty((CharSequence)s)) continue;
                filtered.add(s);
            }
        }
        return filtered.toArray(new String[0]);
    }
}

