/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.model;

import com.vmware.cis.data.model.NestedQueryBinding;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.cis.data.model.Relationship;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vsphere.client.common.model.PropertyValueData;
import com.vmware.vsphere.client.h5.host.model.HostConnectionData;

@QueryBinding(value="Folder")
public class HostDashboardData {
    @NestedQueryBinding
    @Relationship(value={"Folder/host"})
    public HostConnectionData[] hostsConnectionData;

    public PropertyValueData[] getDashboardData() {
        int hostCount = 0;
        int hostConnectedCount = 0;
        int hostDisconnectedCount = 0;
        int hostNotRespondingCount = 0;
        int hostInMaintenanceCount = 0;
        if (this.hostsConnectionData != null) {
            hostCount = this.hostsConnectionData.length;
            for (int i = 0; i < this.hostsConnectionData.length; ++i) {
                if (this.hostsConnectionData[i].connectionState == HostSystem.ConnectionState.connected) {
                    ++hostConnectedCount;
                    if (!this.hostsConnectionData[i].inMaintenanceMode) continue;
                    ++hostInMaintenanceCount;
                    continue;
                }
                if (this.hostsConnectionData[i].connectionState == HostSystem.ConnectionState.disconnected) {
                    ++hostDisconnectedCount;
                    continue;
                }
                ++hostNotRespondingCount;
            }
        }
        return new PropertyValueData[]{PropertyValueData.newInstance((String)"hostCount", (String)("" + hostCount)), PropertyValueData.newInstance((String)"hostConnectedCount", (String)("" + hostConnectedCount)), PropertyValueData.newInstance((String)"hostDisconnectedCount", (String)("" + hostDisconnectedCount)), PropertyValueData.newInstance((String)"hostNotRespondingCount", (String)("" + hostNotRespondingCount)), PropertyValueData.newInstance((String)"hostInMaintenanceCount", (String)("" + hostInMaintenanceCount))};
    }
}

