/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.model;

import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.vim.binding.vcint.DPUInfo;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.host.MemoryTieringType;
import com.vmware.vim.binding.vim.host.PartialMaintenanceModeRuntimeInfo;
import com.vmware.vise.util.annotations.VisibleForTesting;
import com.vmware.vsphere.client.common.model.BaseSummaryData;
import com.vmware.vsphere.client.common.model.ProviderSummaryData;
import com.vmware.vsphere.client.h5.host.util.HostFormatUtil;
import com.vmware.vsphere.client.h5.host.util.HostPropertiesUtil;
import com.vmware.vsphere.client.host.smartnic.DpuUtil;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;

@QueryBinding(value="HostSystem")
public final class HostSummaryData
extends ProviderSummaryData {
    @Property(value="HostSystem/summary/rebootRequired")
    public boolean rebootRequired;
    @Property(value="HostSystem/summary/gateway/gatewayType")
    private String gatewayType;
    @Property(value="HostSystem/config/product/name")
    private String productName;
    @Property(value="HostSystem/config/product/version")
    private String productVersion;
    @Property(value="HostSystem/config/product/build")
    private String productBuild;
    @Property(value="HostSystem/hardware/systemInfo/model")
    public String model;
    @Property(value="HostSystem/summary/hardware/cpuModel")
    public String cpuModel;
    @Property(value="HostSystem/hardware/cpuInfo/numCpuThreads")
    public int logicalCpuCount;
    @Property(value="HostSystem/hardware/memoryTieringType")
    public transient String memoryTieringType;
    @Property(value="HostSystem/vsanFaultDomainName")
    private String vsanFaultDomain;
    @Property(value="HostSystem/summary/config/vmotionEnabled")
    private boolean vmotionEnabled;
    @Property(value="HostSystem/summary/config/faultToleranceEnabled")
    private boolean ftEnabled;
    @Property(value="HostSystem/summary/currentEVCModeKey")
    private String currentEVCMode;
    @Property(value="HostSystem/summary/hardware/numNics")
    public int nicCount;
    @Property(value="HostSystem/allNormalVMOrPrimaryFTVM/length")
    public int vmCount;
    @Property(value="HostSystem/dpuInfos")
    private DPUInfo[] dpuInfos;
    @Property(value="HostSystem/powerState")
    private HostSystem.PowerState powerState;
    @Property(value="HostSystem/connectionState")
    public HostSystem.ConnectionState connectionState;
    @Property(value="HostSystem/runtime/inMaintenanceMode")
    private boolean inMaintenanceMode;
    @Property(value="HostSystem/summary/quickStats/uptime")
    public int uptimeInSeconds;
    @Property(value="HostSystem/isAttested")
    public boolean isAttested;
    @Property(value="HostSystem/runtime/partialMaintenanceMode")
    private PartialMaintenanceModeRuntimeInfo[] partMaintenanceInfos;

    public BaseSummaryData.LabelValue[] getSummaryItems() {
        ArrayList<BaseSummaryData.LabelValue> summaryItemPairs = new ArrayList<BaseSummaryData.LabelValue>();
        summaryItemPairs.add(new BaseSummaryData.LabelValue("summaryView.hypervisor", (Object)this.getHypervisor()));
        summaryItemPairs.add(new BaseSummaryData.LabelValue("summaryView.modelLabel", (Object)this.model));
        summaryItemPairs.add(new BaseSummaryData.LabelValue("summaryView.cpuTypeLabel", (Object)this.cpuModel));
        summaryItemPairs.add(new BaseSummaryData.LabelValue("summaryView.cpuCountLabel", (Object)this.logicalCpuCount));
        DPUInfo dpuInfo = DpuUtil.findManagedDpu((DPUInfo[])this.dpuInfos);
        if (dpuInfo != null) {
            summaryItemPairs.add(new BaseSummaryData.LabelValue("summaryView.dpuCountLabel", (Object)1));
        }
        summaryItemPairs.add(new BaseSummaryData.LabelValue("summaryView.nicCountLabel", (Object)this.nicCount));
        summaryItemPairs.add(new BaseSummaryData.LabelValue("summaryView.vmCountLabel", (Object)this.vmCount));
        if (MemoryTieringType.hardwareTiering.name().equals(this.memoryTieringType) || MemoryTieringType.softwareTiering.name().equals(this.memoryTieringType)) {
            summaryItemPairs.add(new BaseSummaryData.LabelValue("summaryView.memoryTieringType", (Object)this.memoryTieringType));
        }
        boolean isInPartialMaintenanceMode = HostPropertiesUtil.getIsHostInPartMainMode(this.partMaintenanceInfos, this.connectionState);
        summaryItemPairs.add(new BaseSummaryData.LabelValue("summaryView.stateLabel", (Object)HostFormatUtil.formatHostConnectionState(this.connectionState, this.inMaintenanceMode, this.powerState, isInPartialMaintenanceMode)));
        summaryItemPairs.add(new BaseSummaryData.LabelValue("summaryView.uptimeLabel", (Object)HostFormatUtil.formatUptime(this.uptimeInSeconds)));
        if (StringUtils.isNotEmpty((CharSequence)this.vsanFaultDomain)) {
            BaseSummaryData.LabelValue faultDomainItem = new BaseSummaryData.LabelValue("summaryView.faultDomain", (Object)this.vsanFaultDomain);
            summaryItemPairs.add(faultDomainItem);
        }
        return summaryItemPairs.toArray(new BaseSummaryData.LabelValue[0]);
    }

    public BaseSummaryData.Badge[] getBadges() {
        ArrayList<BaseSummaryData.Badge> result = new ArrayList<BaseSummaryData.Badge>();
        if (this.ftEnabled) {
            result.add(new BaseSummaryData.Badge("icon-vSphere-ftEnabled", "summaryView.badge.ft", false));
        }
        if (this.vmotionEnabled) {
            result.add(new BaseSummaryData.Badge("icon-vSphere-vMotionEnabled", "summaryView.badge.vmotion", false));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.currentEVCMode)) {
            result.add(new BaseSummaryData.Badge("icon-vSphere-evcEnabled24", "badge.evcEnabled", false));
        }
        if (this.isAttested) {
            result.add(new BaseSummaryData.Badge("host-ui-icon-hostAttested", "summaryView.badge.hostAttested", false));
        }
        return result.toArray(new BaseSummaryData.Badge[0]);
    }

    public String getHypervisor() {
        if (StringUtils.isNotEmpty((CharSequence)this.gatewayType)) {
            return HostFormatUtil.formatHypervisorType(this.gatewayType);
        }
        return this.productName != null && this.productVersion != null && this.productBuild != null ? String.format("%s, %s, %s", this.productName, this.productVersion, this.productBuild) : "";
    }

    @VisibleForTesting
    void setvSanProperties(String faultDomain) {
        this.vsanFaultDomain = faultDomain;
    }

    @VisibleForTesting
    void setDpuInfos(DPUInfo[] infos) {
        this.dpuInfos = infos;
    }

    @VisibleForTesting
    void setPartMaintenanceInfos(PartialMaintenanceModeRuntimeInfo[] infos) {
        this.partMaintenanceInfos = infos;
    }

    @VisibleForTesting
    void setPowerState(HostSystem.PowerState state) {
        this.powerState = state;
    }
}

