/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.model;

import com.vmware.cis.data.api.binding.IdentifiableQueryBinding;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.vim.binding.vim.host.DateTimeConfig;
import com.vmware.vim.binding.vim.host.DateTimeInfo;
import com.vmware.vim.binding.vim.host.FirewallInfo;
import com.vmware.vim.binding.vim.host.Service;
import com.vmware.vim.binding.vim.host.ServiceInfo;
import com.vmware.vsphere.client.h5.host.util.TimeConfigUtil;
import java.util.GregorianCalendar;
import org.apache.commons.lang.StringUtils;

@QueryBinding(value="HostSystem")
public class TimeConfigData
extends IdentifiableQueryBinding {
    private static final String SERVER_LIST_SEPARATOR = ", ";
    private static final String NTP_SERVICE_KEY = "ntpd";
    private static final String NTP_CLIENT_KEY = "ntpClient";
    @Property(value="HostSystem/config/dateTimeInfo")
    public DateTimeInfo config;
    @Property(value="HostSystem/config/service")
    public transient ServiceInfo services;
    @Property(value="HostSystem/config/firewall")
    public transient FirewallInfo firewallInfo;
    @Property(value="HostSystem/currentTimeOnHost")
    public transient GregorianCalendar currentTime;
    @Property(value="HostSystem/capability/precisionTimeProtocolSupported")
    public boolean isPrecisionTimeProtocolSupported;

    public String getNtpServiceStatus() {
        return TimeConfigUtil.getServiceStatus(this.services, NTP_SERVICE_KEY);
    }

    public String getNtpClientStatus() {
        return TimeConfigUtil.getClientStatus(this.firewallInfo, NTP_CLIENT_KEY);
    }

    public boolean getNtpClientEnabled() {
        return TimeConfigUtil.getClientEnabled(this.firewallInfo, NTP_CLIENT_KEY);
    }

    public boolean getManualTimeSyncEnabled() {
        return this.config.systemClockProtocol == null;
    }

    public String getNtpServers() {
        if (this.config == null || this.config.ntpConfig == null || this.config.ntpConfig.server == null) {
            return "";
        }
        return StringUtils.join((Object[])this.config.ntpConfig.server, (String)SERVER_LIST_SEPARATOR);
    }

    public Long getCurrentTimeInMillis() {
        if (this.currentTime == null) {
            return null;
        }
        return this.currentTime.getTimeInMillis();
    }

    public String getNtpServicePolicy() {
        Service ntpService = TimeConfigUtil.getService(this.services, NTP_SERVICE_KEY);
        return ntpService == null ? "" : ntpService.getPolicy();
    }

    public String getNtpServiceId() {
        Service service = TimeConfigUtil.getService(this.services, NTP_SERVICE_KEY);
        return service == null ? "" : service.getKey();
    }

    public boolean getNtpServiceState() {
        Service service = TimeConfigUtil.getService(this.services, NTP_SERVICE_KEY);
        return service == null ? false : service.isRunning();
    }

    public DateTimeConfig getDateTimeConfig() {
        if (this.config == null) {
            return null;
        }
        DateTimeConfig config = new DateTimeConfig();
        String timeZone = this.config.getTimeZone() == null ? "" : this.config.getTimeZone().getKey();
        config.setTimeZone(timeZone);
        config.setNtpConfig(this.config.getNtpConfig());
        return config;
    }
}

