/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.model;

import com.vmware.cis.data.api.binding.IdentifiableQueryBinding;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.host.ConfigManager;
import com.vmware.vim.binding.vim.host.DateTimeInfo;
import com.vmware.vim.binding.vim.host.FirewallInfo;
import com.vmware.vim.binding.vim.host.Service;
import com.vmware.vim.binding.vim.host.ServiceInfo;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vim.binding.vim.host.VirtualNicManager;
import com.vmware.vim.binding.vim.host.VirtualNicManagerInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.h5.host.config.spec.PtpTimeConfigVnicSpec;
import com.vmware.vsphere.client.h5.host.util.HostStringUtil;
import com.vmware.vsphere.client.h5.host.util.TimeConfigUtil;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.commons.lang.StringUtils;

@QueryBinding(value="HostSystem")
public class TimeKeepingData
extends IdentifiableQueryBinding {
    private static final String SERVER_LIST_SEPARATOR = ", ";
    private static final String NTP_SERVICE_KEY = "ntpd";
    private static final String PTP_SERVICE_KEY = "ptpd";
    @Property(value="HostSystem/config/dateTimeInfo")
    public DateTimeInfo config;
    @Property(value="HostSystem/config/service")
    public transient ServiceInfo services;
    @Property(value="HostSystem/config/firewall")
    public transient FirewallInfo firewallInfo;
    @Property(value="HostSystem/currentTimeOnHost")
    public transient GregorianCalendar currentTime;
    @Property(value="HostSystem/capability/ptpConfigSupported")
    public boolean isPtpConfigSupported;

    public boolean getEnableFallback() {
        return this.config.disableFallback != null && this.config.disableFallback == false;
    }

    public boolean getEnableEvents() {
        return this.config.disableEvents != null && this.config.disableEvents == false;
    }

    public String getNtpServiceStatus() {
        Service ntpService = TimeConfigUtil.getService(this.services, NTP_SERVICE_KEY);
        if (this.config.inFallbackState == null) {
            return TimeConfigUtil.getNtpMonitoringServiceStatus(ntpService, this.config.systemClockProtocol);
        }
        boolean isFallBack = this.config.inFallbackState;
        return isFallBack ? HostStringUtil.getString("timeConfig.ntpServiceStatusFallback", new String[0]) : TimeConfigUtil.getNtpMonitoringServiceStatus(ntpService, this.config.systemClockProtocol);
    }

    public boolean getNtpServiceRunning() {
        Service service = TimeConfigUtil.getService(this.services, NTP_SERVICE_KEY);
        return service == null ? false : service.isRunning();
    }

    public boolean getPtpServiceRunning() {
        Service service = TimeConfigUtil.getService(this.services, PTP_SERVICE_KEY);
        return service == null ? false : service.isRunning();
    }

    public String getPtpServiceStatus() {
        return TimeConfigUtil.getServiceStatus(this.services, PTP_SERVICE_KEY);
    }

    public boolean getPtpClientEnabled() {
        if (this.config == null || this.config.systemClockProtocol == null) {
            return false;
        }
        return this.config.systemClockProtocol.equals(DateTimeInfo.Protocol.ptp.toString());
    }

    public boolean getNtpClientEnabled() {
        if (this.config == null || this.config.systemClockProtocol == null) {
            return false;
        }
        return this.config.systemClockProtocol.equals(DateTimeInfo.Protocol.ntp.toString());
    }

    public boolean getManualTimeSync() {
        return this.config == null || this.config.systemClockProtocol == null;
    }

    public long getLastSyncTime() {
        if (this.config == null || this.config.lastSyncTime == null) {
            return -1L;
        }
        return this.config.lastSyncTime.getTimeInMillis();
    }

    public boolean getServiceSync() {
        if (this.config == null || this.config.serviceSync == null) {
            return false;
        }
        return this.config.serviceSync;
    }

    public String getRemoteNtpServer() {
        if (this.config == null || this.config.remoteNtpServer == null) {
            return null;
        }
        return this.config.remoteNtpServer;
    }

    public String getNtpServers() {
        if (this.config == null || this.config.ntpConfig == null || this.config.ntpConfig.server == null) {
            return "";
        }
        return StringUtils.join((Object[])this.config.ntpConfig.server, (String)SERVER_LIST_SEPARATOR);
    }

    public String getNtpDuration() {
        if (this.config == null || this.config.ntpDuration == null) {
            return "";
        }
        return this.config.ntpDuration;
    }

    public String getPtpDuration() {
        if (this.config == null || this.config.ptpDuration == null) {
            return "";
        }
        return this.config.ptpDuration;
    }

    public Long getCurrentTimeInMillis() {
        if (this.currentTime == null) {
            return null;
        }
        return this.currentTime.getTimeInMillis();
    }

    public String getNtpServiceId() {
        Service service = TimeConfigUtil.getService(this.services, NTP_SERVICE_KEY);
        return service == null ? "" : service.getKey();
    }

    public String getPtpServiceId() {
        Service service = TimeConfigUtil.getService(this.services, PTP_SERVICE_KEY);
        return service == null ? "" : service.getKey();
    }

    public List<PtpTimeConfigVnicSpec> getAllVnicsData() {
        if (this.getPtpNetConfig() != null) {
            VirtualNic[] ptpVnics = this.getPtpNetConfig().getCandidateVnic();
            ArrayList<PtpTimeConfigVnicSpec> ptpVnicsData = new ArrayList<PtpTimeConfigVnicSpec>(ptpVnics.length);
            for (VirtualNic vnic : ptpVnics) {
                PtpTimeConfigVnicSpec ptpVnic = new PtpTimeConfigVnicSpec();
                ptpVnic.vnic = vnic.device;
                ptpVnic.ipAddress = vnic.spec.ip.ipAddress;
                ptpVnic.subnetMask = vnic.spec.ip.subnetMask;
                ptpVnic.vnicKey = vnic.key;
                ptpVnicsData.add(ptpVnic);
            }
            return ptpVnicsData;
        }
        return null;
    }

    public PtpTimeConfigVnicSpec getPtpVnicData() {
        PtpTimeConfigVnicSpec empty = this.emptyData();
        VirtualNicManager.NetConfig ptpNetConfig = this.getPtpNetConfig();
        if (ptpNetConfig == null) {
            return empty;
        }
        String[] selectedVnic = ptpNetConfig.getSelectedVnic();
        if (selectedVnic == null) {
            return empty;
        }
        String ptpVnic = selectedVnic[0];
        if (ptpVnic != null) {
            List<PtpTimeConfigVnicSpec> allVnics = this.getAllVnicsData();
            for (PtpTimeConfigVnicSpec vnicData : allVnics) {
                if (!ptpVnic.equals(vnicData.vnicKey)) continue;
                return vnicData;
            }
        }
        return empty;
    }

    private PtpTimeConfigVnicSpec emptyData() {
        String empty = HostStringUtil.getString("host.hardware.firmware.na.label", new String[0]);
        PtpTimeConfigVnicSpec emptyData = new PtpTimeConfigVnicSpec();
        emptyData.ipAddress = empty;
        emptyData.subnetMask = empty;
        emptyData.vnic = empty;
        return emptyData;
    }

    private VirtualNicManager.NetConfig getPtpNetConfig() {
        try {
            VirtualNicManager.NetConfig[] netConfig;
            ManagedObjectReference hostMor = (ManagedObjectReference)this.provider;
            HostSystem hostSystem = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostMor);
            ConfigManager configManager = hostSystem.getConfigManager();
            ManagedObjectReference vnicMgrMor = configManager.getVirtualNicManager();
            VirtualNicManager vNicManager = (VirtualNicManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vnicMgrMor);
            VirtualNicManagerInfo info = vNicManager.getInfo();
            for (VirtualNicManager.NetConfig config : netConfig = info.netConfig) {
                if (!config.getNicType().equals(VirtualNicManager.NicType.ptp.name())) continue;
                return config;
            }
        }
        catch (Exception ex) {
            return null;
        }
        return null;
    }
}

