/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.moveHost.services;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.vim.binding.vim.ResourceAllocationInfo;
import com.vmware.vim.binding.vim.ResourceConfigSpec;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.h5.host.moveHost.MoveVmsAndRpsConfigSpec;
import com.vmware.vsphere.client.mixed.ManagedEntityMoveSpec;
import com.vmware.vsphere.client.rp.ResourcePoolSpec;
import java.util.List;

public class MoveHostMutationHelperProvider {
    private static final String CLUSTER_ROOT_RESOURCE_POOL = "resourcePool";
    private static final String ROOT_RESOURCE_POOL = "rootRp";
    private static final String CHILD_RESOURCE_POOLS = "resourcePool";
    private static final String TARGET_ENTITY_NAME = "name";
    private QueryService queryService;

    public MoveHostMutationHelperProvider(QueryService queryService) {
        this.queryService = queryService;
    }

    public ManagedEntityMoveSpec createMoveCustomRpSpec(ManagedObjectReference targetEntity, ManagedEntityMoveSpec specToSendToMove, MoveVmsAndRpsConfigSpec moveVmSpec) throws Exception {
        String rpName = moveVmSpec.newRpName;
        ResourcePoolSpec resourcePoolSpec = this.createResourcePoolSpec(targetEntity, rpName);
        specToSendToMove.attributes = new Object[1];
        specToSendToMove.attributes[0] = resourcePoolSpec;
        return specToSendToMove;
    }

    public ResourcePoolSpec createResourcePoolSpec(ManagedObjectReference targetCluster, String rpName) {
        ResourcePoolSpec resourcePoolSpec = new ResourcePoolSpec();
        resourcePoolSpec.parent = this.getClusterRootResourcePool(targetCluster);
        resourcePoolSpec.name = rpName;
        resourcePoolSpec.configSpec = new ResourceConfigSpec();
        ResourceAllocationInfo cpuAlloc = new ResourceAllocationInfo();
        ResourceAllocationInfo memAlloc = new ResourceAllocationInfo();
        resourcePoolSpec.configSpec.setCpuAllocation(cpuAlloc);
        resourcePoolSpec.configSpec.setMemoryAllocation(memAlloc);
        return resourcePoolSpec;
    }

    private ManagedObjectReference getClusterRootResourcePool(ManagedObjectReference targetEntity) {
        ResultSet resultSet = this.fetchProperty(targetEntity, "resourcePool");
        List results = resultSet.getItems();
        return (ManagedObjectReference)((ResourceItem)results.get(0)).get("resourcePool");
    }

    public String getEntityName(ManagedObjectReference targetEntity) throws Exception {
        ResultSet resultSet = this.fetchProperty(targetEntity, TARGET_ENTITY_NAME);
        List results = resultSet.getItems();
        return (String)((ResourceItem)results.get(0)).get(TARGET_ENTITY_NAME);
    }

    public boolean hostHasNestedRps(ManagedObjectReference hostRef) throws Exception {
        ResultSet resultSet = this.fetchProperty(hostRef, ROOT_RESOURCE_POOL);
        List rootRpResult = resultSet.getItems();
        ManagedObjectReference rootRpMor = (ManagedObjectReference)((ResourceItem)rootRpResult.get(0)).get(ROOT_RESOURCE_POOL);
        return this.isHasNestedRps(rootRpMor);
    }

    private boolean isHasNestedRps(ManagedObjectReference rootRpMor) {
        boolean hasNestedRps = false;
        if (rootRpMor != null) {
            ResultSet resourcePoolsResultSet = this.fetchProperty(rootRpMor, "resourcePool");
            List resourcePools = resourcePoolsResultSet.getItems();
            ManagedObjectReference[] resultResourcePool = (ManagedObjectReference[])((ResourceItem)resourcePools.get(0)).get("resourcePool");
            hasNestedRps = resultResourcePool != null && resultResourcePool.length > 0;
        }
        return hasNestedRps;
    }

    public boolean isClusterServiceEnabled(String servicePropertyName, ManagedObjectReference targetRef) {
        ResultSet resultSet = this.fetchProperty(targetRef, servicePropertyName);
        List resultResourceItems = resultSet.getItems();
        return (Boolean)((ResourceItem)resultResourceItems.get(0)).get(servicePropertyName);
    }

    private ResultSet fetchProperty(ManagedObjectReference entity, String propertyName) {
        return this.queryService.select(new String[]{propertyName}).from(new String[]{entity.getClass().getSimpleName()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)entity)}).fetch();
    }

    public static enum HelperConstants {
        displayMaintenanceModeError,
        showWarningDialog,
        clusterName,
        showMovementDialog,
        hostName,
        unsuccessfulMovementOperation,
        dpmTurnedOn,
        hostRef;

    }
}

